/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.txn;

import com.hazelcast.concurrent.lock.LockWaitNotifyKey;
import com.hazelcast.multimap.MultiMapContainer;
import com.hazelcast.multimap.MultiMapWrapper;
import com.hazelcast.multimap.operations.MultiMapKeyBasedOperation;
import com.hazelcast.multimap.operations.MultiMapResponse;
import com.hazelcast.multimap.txn.TxnMultiMapOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.DefaultObjectNamespace;
import com.hazelcast.spi.WaitNotifyKey;
import com.hazelcast.spi.WaitSupport;
import com.hazelcast.transaction.TransactionException;
import java.io.IOException;

public class TxnLockAndGetOperation
extends MultiMapKeyBasedOperation
implements WaitSupport,
TxnMultiMapOperation {
    long ttl;
    long threadId;

    public TxnLockAndGetOperation() {
    }

    public TxnLockAndGetOperation(String name, Data dataKey, long timeout, long ttl, long threadId) {
        super(name, dataKey);
        this.ttl = ttl;
        this.threadId = threadId;
        this.setWaitTimeout(timeout);
    }

    @Override
    public void run() throws Exception {
        MultiMapContainer container = this.getOrCreateContainer();
        if (!container.txnLock(this.dataKey, this.getCallerUuid(), this.threadId, this.ttl)) {
            throw new TransactionException("Transaction couldn't obtain lock!");
        }
        MultiMapWrapper wrapper = this.getOrCreateCollectionWrapper();
        boolean isLocal = this.getResponseHandler().isLocal();
        MultiMapResponse multiMapResponse = new MultiMapResponse(wrapper.getCollection(isLocal));
        multiMapResponse.setNextRecordId(container.nextId());
        multiMapResponse.setTxVersion(wrapper.incrementAndGetVersion());
        this.response = multiMapResponse;
    }

    @Override
    public WaitNotifyKey getWaitKey() {
        return new LockWaitNotifyKey(new DefaultObjectNamespace("hz:impl:multiMapService", this.name), this.dataKey);
    }

    @Override
    public boolean shouldWait() {
        return !this.getOrCreateContainer().canAcquireLock(this.dataKey, this.getCallerUuid(), this.threadId);
    }

    @Override
    public void onWaitExpire() {
        this.getResponseHandler().sendResponse(null);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.ttl);
        out.writeLong(this.threadId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.ttl = in.readLong();
        this.threadId = in.readLong();
    }

    @Override
    public int getId() {
        return 30;
    }
}

