/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.proxy;

import com.hazelcast.core.EntryListener;
import com.hazelcast.core.EntryView;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.IMap;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.MapInterceptor;
import com.hazelcast.map.MapService;
import com.hazelcast.map.SimpleEntryView;
import com.hazelcast.map.proxy.MapProxySupport;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.Predicate;
import com.hazelcast.spi.InitializingObject;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.util.IterationType;
import com.hazelcast.util.ValidationUtil;
import com.hazelcast.util.executor.DelegatingFuture;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class MapProxyImpl<K, V>
extends MapProxySupport
implements IMap<K, V>,
InitializingObject {
    public MapProxyImpl(String name, MapService mapService, NodeEngine nodeEngine) {
        super(name, mapService, nodeEngine);
    }

    @Override
    public V get(Object k) {
        if (k == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        MapService service = (MapService)this.getService();
        Data key = service.toData(k, this.partitionStrategy);
        return (V)service.toObject(this.getInternal(key));
    }

    @Override
    public V put(K k, V v) {
        return this.put(k, v, -1L, null);
    }

    @Override
    public V put(K k, V v, long ttl, TimeUnit timeunit) {
        if (k == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        if (v == null) {
            throw new NullPointerException("Null value is not allowed!");
        }
        MapService service = (MapService)this.getService();
        Data key = service.toData(k, this.partitionStrategy);
        Data value = service.toData(v);
        Data result = this.putInternal(key, value, ttl, timeunit);
        return (V)service.toObject(result);
    }

    @Override
    public boolean tryPut(K k, V v, long timeout, TimeUnit timeunit) {
        if (k == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        if (v == null) {
            throw new NullPointerException("Null value is not allowed!");
        }
        MapService service = (MapService)this.getService();
        Data key = service.toData(k, this.partitionStrategy);
        Data value = service.toData(v);
        return this.tryPutInternal(key, value, timeout, timeunit);
    }

    @Override
    public V putIfAbsent(K k, V v) {
        return this.putIfAbsent(k, v, -1L, null);
    }

    @Override
    public V putIfAbsent(K k, V v, long ttl, TimeUnit timeunit) {
        if (k == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        if (v == null) {
            throw new NullPointerException("Null value is not allowed!");
        }
        MapService service = (MapService)this.getService();
        Data key = service.toData(k, this.partitionStrategy);
        Data value = service.toData(v);
        Data result = this.putIfAbsentInternal(key, value, ttl, timeunit);
        return (V)service.toObject(result);
    }

    @Override
    public void putTransient(K k, V v, long ttl, TimeUnit timeunit) {
        if (k == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        if (v == null) {
            throw new NullPointerException("Null value is not allowed!");
        }
        MapService service = (MapService)this.getService();
        Data key = service.toData(k, this.partitionStrategy);
        Data value = service.toData(v);
        this.putTransientInternal(key, value, ttl, timeunit);
    }

    @Override
    public boolean replace(K k, V o, V v) {
        if (k == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        if (o == null) {
            throw new NullPointerException("Null value is not allowed!");
        }
        if (v == null) {
            throw new NullPointerException("Null value is not allowed!");
        }
        MapService service = (MapService)this.getService();
        Data key = service.toData(k, this.partitionStrategy);
        Data oldValue = service.toData(o);
        Data value = service.toData(v);
        return this.replaceInternal(key, oldValue, value);
    }

    @Override
    public V replace(K k, V v) {
        if (k == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        if (v == null) {
            throw new NullPointerException("Null value is not allowed!");
        }
        MapService service = (MapService)this.getService();
        Data key = service.toData(k, this.partitionStrategy);
        Data value = service.toData(v);
        return (V)service.toObject(this.replaceInternal(key, value));
    }

    @Override
    public void set(K key, V value) {
        this.set(key, value, -1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void set(K k, V v, long ttl, TimeUnit timeunit) {
        if (k == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        if (v == null) {
            throw new NullPointerException("Null value is not allowed!");
        }
        MapService service = (MapService)this.getService();
        Data key = service.toData(k, this.partitionStrategy);
        Data value = service.toData(v);
        this.setInternal(key, value, ttl, timeunit);
    }

    @Override
    public V remove(Object k) {
        if (k == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        MapService service = (MapService)this.getService();
        Data key = service.toData(k, this.partitionStrategy);
        Data result = this.removeInternal(key);
        return (V)service.toObject(result);
    }

    @Override
    public boolean remove(Object k, Object v) {
        if (k == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        if (v == null) {
            throw new NullPointerException("Null value is not allowed!");
        }
        MapService service = (MapService)this.getService();
        Data key = service.toData(k, this.partitionStrategy);
        Data value = service.toData(v);
        return this.removeInternal(key, value);
    }

    @Override
    public void delete(Object k) {
        if (k == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        Data key = ((MapService)this.getService()).toData(k, this.partitionStrategy);
        this.deleteInternal(key);
    }

    @Override
    public boolean containsKey(Object k) {
        if (k == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        Data key = ((MapService)this.getService()).toData(k, this.partitionStrategy);
        return this.containsKeyInternal(key);
    }

    @Override
    public boolean containsValue(Object v) {
        if (v == null) {
            throw new NullPointerException("Null value is not allowed!");
        }
        Data value = ((MapService)this.getService()).toData(v);
        return this.containsValueInternal(value);
    }

    @Override
    public void lock(K key) {
        if (key == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        NodeEngine nodeEngine = this.getNodeEngine();
        Data k = ((MapService)this.getService()).toData(key, this.partitionStrategy);
        this.lockSupport.lock(nodeEngine, k);
    }

    @Override
    public void lock(Object key, long leaseTime, TimeUnit timeUnit) {
        if (key == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        ValidationUtil.shouldBePositive(leaseTime, "leaseTime");
        Data k = ((MapService)this.getService()).toData(key, this.partitionStrategy);
        this.lockSupport.lock(this.getNodeEngine(), k, timeUnit.toMillis(leaseTime));
    }

    @Override
    public void unlock(K key) {
        if (key == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        NodeEngine nodeEngine = this.getNodeEngine();
        Data k = ((MapService)this.getService()).toData(key, this.partitionStrategy);
        this.lockSupport.unlock(nodeEngine, k);
    }

    @Override
    public boolean tryRemove(K key, long timeout, TimeUnit timeunit) {
        if (key == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        Data k = ((MapService)this.getService()).toData(key, this.partitionStrategy);
        return this.tryRemoveInternal(k, timeout, timeunit);
    }

    @Override
    public Future<V> getAsync(K k) {
        if (k == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        Data key = ((MapService)this.getService()).toData(k, this.partitionStrategy);
        NodeEngine nodeEngine = this.getNodeEngine();
        return new DelegatingFuture(this.getAsyncInternal(key), nodeEngine.getSerializationService());
    }

    @Override
    public boolean isLocked(K k) {
        if (k == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        Data key = ((MapService)this.getService()).toData(k, this.partitionStrategy);
        NodeEngine nodeEngine = this.getNodeEngine();
        return this.lockSupport.isLocked(nodeEngine, key);
    }

    @Override
    public Future putAsync(K key, V value) {
        return this.putAsync((Object)key, (Object)value, -1L, (TimeUnit)null);
    }

    public ICompletableFuture putAsync(K key, V value, long ttl, TimeUnit timeunit) {
        if (key == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        if (value == null) {
            throw new NullPointerException("Null value is not allowed!");
        }
        MapService service = (MapService)this.getService();
        Data k = service.toData(key, this.partitionStrategy);
        Data v = service.toData(value);
        return new DelegatingFuture(this.putAsyncInternal(k, v, ttl, timeunit), this.getNodeEngine().getSerializationService());
    }

    public ICompletableFuture removeAsync(K key) {
        if (key == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        Data k = ((MapService)this.getService()).toData(key, this.partitionStrategy);
        return new DelegatingFuture(this.removeAsyncInternal(k), this.getNodeEngine().getSerializationService());
    }

    @Override
    public Map<K, V> getAll(Set<K> keys) {
        HashSet<Data> ks = new HashSet<Data>(keys.size());
        MapService service = (MapService)this.getService();
        for (K key : keys) {
            if (key == null) {
                throw new NullPointerException("Null key is not allowed!");
            }
            Data k = service.toData(key, this.partitionStrategy);
            ks.add(k);
        }
        return this.getAllObjectInternal(ks);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.putAllInternal(m);
    }

    @Override
    public boolean tryLock(K key) {
        if (key == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        NodeEngine nodeEngine = this.getNodeEngine();
        Data k = ((MapService)this.getService()).toData(key, this.partitionStrategy);
        return this.lockSupport.tryLock(nodeEngine, k);
    }

    @Override
    public boolean tryLock(K key, long time, TimeUnit timeunit) throws InterruptedException {
        if (key == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        NodeEngine nodeEngine = this.getNodeEngine();
        Data k = ((MapService)this.getService()).toData(key, this.partitionStrategy);
        return this.lockSupport.tryLock(nodeEngine, k, time, timeunit);
    }

    @Override
    public void forceUnlock(K key) {
        if (key == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        NodeEngine nodeEngine = this.getNodeEngine();
        Data k = ((MapService)this.getService()).toData(key, this.partitionStrategy);
        this.lockSupport.forceUnlock(nodeEngine, k);
    }

    @Override
    public String addInterceptor(MapInterceptor interceptor) {
        if (interceptor == null) {
            throw new NullPointerException("Interceptor should not be null!");
        }
        return this.addMapInterceptorInternal(interceptor);
    }

    @Override
    public void removeInterceptor(String id) {
        if (id == null) {
            throw new NullPointerException("Interceptor id should not be null!");
        }
        this.removeMapInterceptorInternal(id);
    }

    @Override
    public String addLocalEntryListener(EntryListener<K, V> listener, Predicate<K, V> predicate, boolean includeValue) {
        if (listener == null) {
            throw new NullPointerException("Listener should not be null!");
        }
        if (predicate == null) {
            throw new NullPointerException("Predicate should not be null!");
        }
        return this.addLocalEntryListenerInternal(listener, predicate, null, includeValue);
    }

    @Override
    public String addLocalEntryListener(EntryListener<K, V> listener, Predicate<K, V> predicate, K key, boolean includeValue) {
        if (listener == null) {
            throw new NullPointerException("Listener should not be null!");
        }
        if (predicate == null) {
            throw new NullPointerException("Predicate should not be null!");
        }
        return this.addLocalEntryListenerInternal(listener, predicate, ((MapService)this.getService()).toData(key, this.partitionStrategy), includeValue);
    }

    @Override
    public String addEntryListener(EntryListener listener, boolean includeValue) {
        if (listener == null) {
            throw new NullPointerException("Listener should not be null!");
        }
        return this.addEntryListenerInternal(listener, null, includeValue);
    }

    @Override
    public String addEntryListener(EntryListener<K, V> listener, K key, boolean includeValue) {
        if (listener == null) {
            throw new NullPointerException("Listener should not be null!");
        }
        return this.addEntryListenerInternal(listener, ((MapService)this.getService()).toData(key, this.partitionStrategy), includeValue);
    }

    @Override
    public String addEntryListener(EntryListener<K, V> listener, Predicate<K, V> predicate, K key, boolean includeValue) {
        if (listener == null) {
            throw new NullPointerException("Listener should not be null!");
        }
        if (predicate == null) {
            throw new NullPointerException("Predicate should not be null!");
        }
        return this.addEntryListenerInternal(listener, predicate, ((MapService)this.getService()).toData(key, this.partitionStrategy), includeValue);
    }

    @Override
    public String addEntryListener(EntryListener<K, V> listener, Predicate<K, V> predicate, boolean includeValue) {
        if (listener == null) {
            throw new NullPointerException("Listener should not be null!");
        }
        if (predicate == null) {
            throw new NullPointerException("Predicate should not be null!");
        }
        return this.addEntryListenerInternal(listener, predicate, null, includeValue);
    }

    @Override
    public boolean removeEntryListener(String id) {
        if (id == null) {
            throw new NullPointerException("Listener id should not be null!");
        }
        return this.removeEntryListenerInternal(id);
    }

    @Override
    public EntryView<K, V> getEntryView(K key) {
        if (key == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        SimpleEntryView entryViewInternal = (SimpleEntryView)this.getEntryViewInternal(((MapService)this.getService()).toData(key, this.partitionStrategy));
        if (entryViewInternal == null) {
            return null;
        }
        Data value = (Data)entryViewInternal.getValue();
        entryViewInternal.setKey(key);
        entryViewInternal.setValue(((MapService)this.getService()).toObject(value));
        return entryViewInternal;
    }

    @Override
    public boolean evict(Object key) {
        if (key == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        return this.evictInternal(((MapService)this.getService()).toData(key, this.partitionStrategy));
    }

    @Override
    public void clear() {
        this.clearInternal();
    }

    @Override
    public Set<K> keySet() {
        Set<Data> dataSet = this.keySetInternal();
        HashSet<Object> keySet = new HashSet<Object>();
        for (Data data : dataSet) {
            keySet.add(((MapService)this.getService()).toObject(data));
        }
        return keySet;
    }

    @Override
    public Collection<V> values() {
        Collection<Data> dataSet = this.valuesInternal();
        ArrayList<Object> valueSet = new ArrayList<Object>();
        for (Data data : dataSet) {
            valueSet.add(((MapService)this.getService()).toObject(data));
        }
        return valueSet;
    }

    @Override
    public Set entrySet() {
        Set<Map.Entry<Data, Data>> entries = this.entrySetInternal();
        HashSet<AbstractMap.SimpleImmutableEntry<Object, Object>> resultSet = new HashSet<AbstractMap.SimpleImmutableEntry<Object, Object>>();
        for (Map.Entry<Data, Data> entry : entries) {
            resultSet.add(new AbstractMap.SimpleImmutableEntry<Object, Object>(((MapService)this.getService()).toObject(entry.getKey()), ((MapService)this.getService()).toObject(entry.getValue())));
        }
        return resultSet;
    }

    @Override
    public Set<K> keySet(Predicate predicate) {
        if (predicate == null) {
            throw new NullPointerException("Predicate should not be null!");
        }
        return this.query(predicate, IterationType.KEY, false);
    }

    @Override
    public Set entrySet(Predicate predicate) {
        if (predicate == null) {
            throw new NullPointerException("Predicate should not be null!");
        }
        return this.query(predicate, IterationType.ENTRY, false);
    }

    @Override
    public Collection<V> values(Predicate predicate) {
        if (predicate == null) {
            throw new NullPointerException("Predicate should not be null!");
        }
        return this.query(predicate, IterationType.VALUE, false);
    }

    @Override
    public Set<K> localKeySet() {
        Set<Data> dataSet = this.localKeySetInternal();
        HashSet<Object> keySet = new HashSet<Object>(dataSet.size());
        for (Data data : dataSet) {
            keySet.add(((MapService)this.getService()).toObject(data));
        }
        return keySet;
    }

    @Override
    public Set<K> localKeySet(Predicate predicate) {
        if (predicate == null) {
            throw new NullPointerException("Predicate should not be null!");
        }
        return this.queryLocal(predicate, IterationType.KEY, false);
    }

    @Override
    public Object executeOnKey(K key, EntryProcessor entryProcessor) {
        if (key == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        MapService service = (MapService)this.getService();
        return service.toObject(this.executeOnKeyInternal(service.toData(key, this.partitionStrategy), entryProcessor));
    }

    @Override
    public Map<K, Object> executeOnKeys(Set<K> keys, EntryProcessor entryProcessor) {
        if (keys == null || keys.size() == 0) {
            throw new NullPointerException("Null key is not allowed!");
        }
        MapService service = (MapService)this.getService();
        HashSet<Data> dataKeys = new HashSet<Data>(keys.size());
        for (K key : keys) {
            dataKeys.add(service.toData(key, this.partitionStrategy));
        }
        return this.executeOnKeysInternal(dataKeys, entryProcessor);
    }

    @Override
    public void submitToKey(K key, EntryProcessor entryProcessor, ExecutionCallback callback) {
        if (key == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        MapService service = (MapService)this.getService();
        Data keyData = service.toData(key, this.partitionStrategy);
        this.executeOnKeyInternal(keyData, entryProcessor, callback);
    }

    @Override
    public ICompletableFuture submitToKey(K key, EntryProcessor entryProcessor) {
        if (key == null) {
            throw new NullPointerException("Null key is not allowed!");
        }
        MapService service = (MapService)this.getService();
        Data keyData = service.toData(key, this.partitionStrategy);
        ICompletableFuture f = this.executeOnKeyInternal(keyData, entryProcessor, null);
        return new DelegatingFuture(f, service.getSerializationService());
    }

    protected Object invoke(Operation operation, int partitionId) throws Throwable {
        NodeEngine nodeEngine = this.getNodeEngine();
        InternalCompletableFuture f = nodeEngine.getOperationService().invokeOnPartition("hz:impl:mapService", operation, partitionId);
        Object response = f.get();
        Object returnObj = ((MapService)this.getService()).toObject(response);
        if (returnObj instanceof Throwable) {
            throw (Throwable)returnObj;
        }
        return returnObj;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("IMap");
        sb.append("{name='").append(this.name).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

