/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.client;

import com.hazelcast.client.KeyBasedClientRequest;
import com.hazelcast.client.SecureRequest;
import com.hazelcast.map.MapContainer;
import com.hazelcast.map.MapPortableHook;
import com.hazelcast.map.MapService;
import com.hazelcast.map.operation.RemoveOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.security.Permission;

public class MapRemoveRequest
extends KeyBasedClientRequest
implements Portable,
SecureRequest {
    protected String name;
    protected Data key;
    protected long threadId;
    protected transient long startTime;

    public MapRemoveRequest() {
    }

    public MapRemoveRequest(String name, Data key, long threadId) {
        this.name = name;
        this.key = key;
        this.threadId = threadId;
    }

    @Override
    public int getFactoryId() {
        return MapPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 9;
    }

    @Override
    public Object getKey() {
        return this.key;
    }

    @Override
    protected void beforeProcess() {
        this.startTime = System.currentTimeMillis();
    }

    @Override
    protected void beforeResponse() {
        long latency = System.currentTimeMillis() - this.startTime;
        MapService mapService = (MapService)this.getService();
        MapContainer mapContainer = mapService.getMapContainer(this.name);
        if (mapContainer.getMapConfig().isStatisticsEnabled()) {
            mapService.getLocalMapStatsImpl(this.name).incrementRemoves(latency);
        }
    }

    @Override
    protected Operation prepareOperation() {
        RemoveOperation op = new RemoveOperation(this.name, this.key);
        op.setThreadId(this.threadId);
        return op;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        writer.writeLong("t", this.threadId);
        ObjectDataOutput out = writer.getRawDataOutput();
        this.key.writeData(out);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        this.threadId = reader.readLong("t");
        ObjectDataInput in = reader.getRawDataInput();
        this.key = new Data();
        this.key.readData(in);
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(this.name, "remove");
    }
}

