/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.client;

import com.hazelcast.client.CallableClientRequest;
import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.ClientEngine;
import com.hazelcast.client.SecureRequest;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.map.EntryEventFilter;
import com.hazelcast.map.MapPortableHook;
import com.hazelcast.map.MapService;
import com.hazelcast.map.QueryEventFilter;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.query.Predicate;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.impl.PortableEntryEvent;
import java.security.Permission;

public abstract class AbstractMapAddEntryListenerRequest
extends CallableClientRequest
implements Portable,
SecureRequest {
    protected String name;
    protected Data key;
    protected boolean includeValue;

    public AbstractMapAddEntryListenerRequest() {
    }

    public AbstractMapAddEntryListenerRequest(String name, boolean includeValue) {
        this.name = name;
        this.includeValue = includeValue;
    }

    public AbstractMapAddEntryListenerRequest(String name, Data key, boolean includeValue) {
        this(name, includeValue);
        this.key = key;
    }

    protected abstract Predicate getPredicate();

    public Object call() {
        final ClientEndpoint endpoint = this.getEndpoint();
        final ClientEngine clientEngine = this.getClientEngine();
        MapService mapService = (MapService)this.getService();
        EntryListener<Object, Object> listener = new EntryListener<Object, Object>(){

            private void handleEvent(EntryEvent<Object, Object> event) {
                if (endpoint.live()) {
                    Data key = clientEngine.toData(event.getKey());
                    Data value = clientEngine.toData(event.getValue());
                    Data oldValue = clientEngine.toData(event.getOldValue());
                    PortableEntryEvent portableEntryEvent = new PortableEntryEvent(key, value, oldValue, event.getEventType(), event.getMember().getUuid());
                    endpoint.sendEvent(portableEntryEvent, AbstractMapAddEntryListenerRequest.this.getCallId());
                }
            }

            @Override
            public void entryAdded(EntryEvent<Object, Object> event) {
                this.handleEvent(event);
            }

            @Override
            public void entryRemoved(EntryEvent<Object, Object> event) {
                this.handleEvent(event);
            }

            @Override
            public void entryUpdated(EntryEvent<Object, Object> event) {
                this.handleEvent(event);
            }

            @Override
            public void entryEvicted(EntryEvent<Object, Object> event) {
                this.handleEvent(event);
            }
        };
        EntryEventFilter eventFilter = this.getPredicate() == null ? new EntryEventFilter(this.includeValue, this.key) : new QueryEventFilter(this.includeValue, this.key, this.getPredicate());
        String registrationId = mapService.addEventListener(listener, eventFilter, this.name);
        endpoint.setListenerRegistration("hz:impl:mapService", this.name, registrationId);
        return registrationId;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public int getFactoryId() {
        return MapPortableHook.F_ID;
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(this.name, "listen");
    }
}

