/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

import com.hazelcast.nio.IOUtil;
import com.hazelcast.util.ValidationUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FilteringClassLoader
extends ClassLoader {
    private static final int BUFFER_SIZE = 1024;
    private final Map<String, Class<?>> cache = new ConcurrentHashMap();
    private final List<String> excludePackages;
    private final ClassLoader delegatingClassLoader;

    public FilteringClassLoader(List<String> excludePackages) {
        this.excludePackages = Collections.unmodifiableList(excludePackages);
        try {
            Field parent = ClassLoader.class.getDeclaredField("parent");
            parent.setAccessible(true);
            this.delegatingClassLoader = (ClassLoader)parent.get(this);
            parent.set(this, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public URL getResource(String name) {
        return this.delegatingClassLoader.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return this.delegatingClassLoader.getResources(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return this.delegatingClassLoader.getResourceAsStream(name);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        ValidationUtil.isNotNull(name, "name");
        for (String excludePackage : this.excludePackages) {
            if (!name.startsWith(excludePackage)) continue;
            throw new ClassNotFoundException(name + " - Package excluded explicitly!");
        }
        if (name.startsWith("com.hazelcast")) {
            Class<?> clazz = this.cache.get(name);
            if (clazz != null) {
                return clazz;
            }
            InputStream is = this.getResourceAsStream(name.replaceAll("\\.", "/").concat(".class"));
            try {
                int length;
                byte[] temp = new byte[1024];
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                while ((length = is.read(temp)) != -1) {
                    baos.write(temp, 0, length);
                }
                byte[] data = baos.toByteArray();
                clazz = this.defineClass(name, data, 0, data.length);
                this.cache.put(name, clazz);
                Class<?> clazz2 = clazz;
                return clazz2;
            }
            catch (Exception e) {
                throw new ClassNotFoundException(name, e);
            }
            finally {
                IOUtil.closeResource(is);
            }
        }
        return this.delegatingClassLoader.loadClass(name);
    }
}

