/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.util.ConcurrentReferenceHashMap;
import com.hazelcast.util.ValidationUtil;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class ClassLoaderUtil {
    public static final String HAZELCAST_BASE_PACKAGE = "com.hazelcast.";
    public static final String HAZELCAST_ARRAY = "[Lcom.hazelcast.";
    private static final Map<String, Class> PRIMITIVE_CLASSES;
    private static final int MAX_PRIM_CLASSNAME_LENGTH = 7;
    private static final ConstructorCache CONSTRUCTOR_CACHE;

    public static <T> T newInstance(ClassLoader classLoader, String className) throws Exception {
        Constructor constructor = CONSTRUCTOR_CACHE.get(classLoader = classLoader == null ? ClassLoaderUtil.class.getClassLoader() : classLoader, className);
        if (constructor != null) {
            return constructor.newInstance(new Object[0]);
        }
        Class<?> klass = ClassLoaderUtil.loadClass(classLoader, className);
        return (T)ClassLoaderUtil.newInstance(klass, classLoader, className);
    }

    public static <T> T newInstance(Class<T> klass, ClassLoader classLoader, String className) throws Exception {
        Constructor<T> constructor = klass.getDeclaredConstructor(new Class[0]);
        if (!constructor.isAccessible()) {
            constructor.setAccessible(true);
        }
        ClassLoaderUtil.CONSTRUCTOR_CACHE.put(classLoader, className, constructor);
        return constructor.newInstance(new Object[0]);
    }

    public static Class<?> loadClass(ClassLoader classLoader, String className) throws ClassNotFoundException {
        Class primitiveClass;
        ValidationUtil.isNotNull(className, "className");
        if (className.length() <= 7 && Character.isLowerCase(className.charAt(0)) && (primitiveClass = PRIMITIVE_CLASSES.get(className)) != null) {
            return primitiveClass;
        }
        ClassLoader theClassLoader = classLoader;
        if (theClassLoader == null) {
            theClassLoader = Thread.currentThread().getContextClassLoader();
        }
        if (theClassLoader != null) {
            try {
                return theClassLoader.loadClass(className);
            }
            catch (ClassNotFoundException ignore) {
                theClassLoader = null;
            }
        }
        if (className.startsWith(HAZELCAST_BASE_PACKAGE) || className.startsWith(HAZELCAST_ARRAY)) {
            theClassLoader = ClassLoaderUtil.class.getClassLoader();
        }
        if (theClassLoader == null) {
            theClassLoader = Thread.currentThread().getContextClassLoader();
        }
        if (theClassLoader != null) {
            if (className.startsWith("[")) {
                return Class.forName(className, true, theClassLoader);
            }
            return theClassLoader.loadClass(className);
        }
        return Class.forName(className);
    }

    public static boolean isInternalType(Class type) {
        return type.getClassLoader() == ClassLoaderUtil.class.getClassLoader() && type.getName().startsWith(HAZELCAST_BASE_PACKAGE);
    }

    private ClassLoaderUtil() {
    }

    static {
        CONSTRUCTOR_CACHE = new ConstructorCache();
        HashMap<String, Class<Object>> primitives = new HashMap<String, Class<Object>>(10, 1.0f);
        primitives.put("boolean", Boolean.TYPE);
        primitives.put("byte", Byte.TYPE);
        primitives.put("int", Integer.TYPE);
        primitives.put("long", Long.TYPE);
        primitives.put("short", Short.TYPE);
        primitives.put("float", Float.TYPE);
        primitives.put("double", Double.TYPE);
        primitives.put("char", Character.TYPE);
        primitives.put("void", Void.TYPE);
        PRIMITIVE_CLASSES = Collections.unmodifiableMap(primitives);
    }

    private static class ConstructorCache {
        private final ConcurrentMap<ClassLoader, ConcurrentMap<String, WeakReference<Constructor>>> cache = new ConcurrentReferenceHashMap<ClassLoader, ConcurrentMap<String, WeakReference<Constructor>>>(16);

        private ConstructorCache() {
        }

        private <T> Constructor put(ClassLoader classLoader, String className, Constructor<T> constructor) {
            ConcurrentMap old;
            ClassLoader cl = classLoader == null ? ClassLoaderUtil.class.getClassLoader() : classLoader;
            ConcurrentMap<String, WeakReference<Constructor<Object>>> innerCache = (ConcurrentHashMap<String, WeakReference<Constructor<T>>>)this.cache.get(cl);
            if (innerCache == null && (old = (ConcurrentMap)this.cache.putIfAbsent(cl, innerCache = new ConcurrentHashMap<String, WeakReference<Constructor<T>>>(100))) != null) {
                innerCache = old;
            }
            innerCache.put(className, new WeakReference<Constructor<T>>(constructor));
            return constructor;
        }

        public <T> Constructor<T> get(ClassLoader classLoader, String className) {
            Constructor constructor;
            ConcurrentMap innerCache = (ConcurrentMap)this.cache.get(classLoader);
            if (innerCache == null) {
                return null;
            }
            WeakReference reference = (WeakReference)innerCache.get(className);
            Constructor constructor2 = constructor = reference == null ? null : (Constructor)reference.get();
            if (reference != null && constructor == null) {
                innerCache.remove(className);
            }
            return constructor;
        }
    }
}

