/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.spi.ExceptionAction;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.ResponseHandler;
import com.hazelcast.spi.UrgentSystemOperation;
import com.hazelcast.spi.exception.RetryableException;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.io.IOException;
import java.util.logging.Level;

public abstract class Operation
implements DataSerializable {
    private String serviceName;
    private int partitionId = -1;
    private int replicaIndex;
    private long callId = 0L;
    private boolean validateTarget = true;
    private long invocationTime = -1L;
    private long callTimeout = Long.MAX_VALUE;
    private String callerUuid;
    private String executorName;
    private transient NodeEngine nodeEngine;
    private transient Object service;
    private transient Address callerAddress;
    private transient Connection connection;
    private transient ResponseHandler responseHandler;
    private transient long startTime;

    public boolean isUrgent() {
        return this instanceof UrgentSystemOperation;
    }

    public abstract void beforeRun() throws Exception;

    public abstract void run() throws Exception;

    public abstract void afterRun() throws Exception;

    public abstract boolean returnsResponse();

    public abstract Object getResponse();

    public String getServiceName() {
        return this.serviceName;
    }

    public final Operation setServiceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    public final int getPartitionId() {
        return this.partitionId;
    }

    public final Operation setPartitionId(int partitionId) {
        this.partitionId = partitionId;
        return this;
    }

    public final int getReplicaIndex() {
        return this.replicaIndex;
    }

    public final Operation setReplicaIndex(int replicaIndex) {
        if (replicaIndex < 0 || replicaIndex >= 7) {
            throw new IllegalArgumentException("Replica index is out of range [0-6]");
        }
        this.replicaIndex = replicaIndex;
        return this;
    }

    public String getExecutorName() {
        return this.executorName;
    }

    public void setExecutorName(String executorName) {
        this.executorName = executorName;
    }

    public final long getCallId() {
        return this.callId;
    }

    final Operation setCallId(long callId) {
        this.callId = callId;
        return this;
    }

    public boolean validatesTarget() {
        return this.validateTarget;
    }

    public final Operation setValidateTarget(boolean validateTarget) {
        this.validateTarget = validateTarget;
        return this;
    }

    public final NodeEngine getNodeEngine() {
        return this.nodeEngine;
    }

    public final Operation setNodeEngine(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
        return this;
    }

    public final <T> T getService() {
        if (this.service == null) {
            String name = this.serviceName != null ? this.serviceName : this.getServiceName();
            this.service = ((NodeEngineImpl)this.nodeEngine).getService(name);
            if (this.service == null) {
                if (this.nodeEngine.isActive()) {
                    throw new HazelcastException("Service with name '" + name + "' not found!");
                }
                throw new RetryableHazelcastException("HazelcastInstance[" + this.nodeEngine.getThisAddress() + "] is not active!");
            }
        }
        return (T)this.service;
    }

    public final Operation setService(Object service) {
        this.service = service;
        return this;
    }

    public final Address getCallerAddress() {
        return this.callerAddress;
    }

    final Operation setCallerAddress(Address callerAddress) {
        this.callerAddress = callerAddress;
        return this;
    }

    public final Connection getConnection() {
        return this.connection;
    }

    final Operation setConnection(Connection connection) {
        this.connection = connection;
        return this;
    }

    public final Operation setResponseHandler(ResponseHandler responseHandler) {
        this.responseHandler = responseHandler;
        return this;
    }

    public final ResponseHandler getResponseHandler() {
        return this.responseHandler;
    }

    public final long getStartTime() {
        return this.startTime;
    }

    final Operation setStartTime(long startTime) {
        this.startTime = startTime;
        return this;
    }

    public final long getInvocationTime() {
        return this.invocationTime;
    }

    final Operation setInvocationTime(long invocationTime) {
        this.invocationTime = invocationTime;
        return this;
    }

    public final long getCallTimeout() {
        return this.callTimeout;
    }

    final Operation setCallTimeout(long callTimeout) {
        this.callTimeout = callTimeout;
        return this;
    }

    public ExceptionAction onException(Throwable throwable) {
        return throwable instanceof RetryableException ? ExceptionAction.RETRY_INVOCATION : ExceptionAction.THROW_EXCEPTION;
    }

    public String getCallerUuid() {
        return this.callerUuid;
    }

    public Operation setCallerUuid(String callerUuid) {
        this.callerUuid = callerUuid;
        return this;
    }

    protected final ILogger getLogger() {
        NodeEngine ne = this.nodeEngine;
        return ne != null ? ne.getLogger(this.getClass()) : Logger.getLogger(this.getClass());
    }

    public void logError(Throwable e) {
        ILogger logger = this.getLogger();
        if (e instanceof RetryableException) {
            Level level;
            Level level2 = level = this.returnsResponse() ? Level.FINEST : Level.WARNING;
            if (logger.isLoggable(level)) {
                logger.log(level, e.getClass().getName() + ": " + e.getMessage());
            }
        } else if (e instanceof OutOfMemoryError) {
            try {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            catch (Throwable ignored) {}
        } else {
            Level level;
            Level level3 = level = this.nodeEngine != null && this.nodeEngine.isActive() ? Level.SEVERE : Level.FINEST;
            if (logger.isLoggable(level)) {
                logger.log(level, e.getMessage(), e);
            }
        }
    }

    @Override
    public final void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.serviceName);
        out.writeInt(this.partitionId);
        out.writeInt(this.replicaIndex);
        out.writeLong(this.callId);
        out.writeBoolean(this.validateTarget);
        out.writeLong(this.invocationTime);
        out.writeLong(this.callTimeout);
        out.writeUTF(this.callerUuid);
        out.writeUTF(this.executorName);
        this.writeInternal(out);
    }

    @Override
    public final void readData(ObjectDataInput in) throws IOException {
        this.serviceName = in.readUTF();
        this.partitionId = in.readInt();
        this.replicaIndex = in.readInt();
        this.callId = in.readLong();
        this.validateTarget = in.readBoolean();
        this.invocationTime = in.readLong();
        this.callTimeout = in.readLong();
        this.callerUuid = in.readUTF();
        this.executorName = in.readUTF();
        this.readInternal(in);
    }

    protected abstract void writeInternal(ObjectDataOutput var1) throws IOException;

    protected abstract void readInternal(ObjectDataInput var1) throws IOException;
}

