/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.core.EntryView;
import com.hazelcast.map.MapService;
import com.hazelcast.map.RecordStore;
import com.hazelcast.map.SimpleEntryView;
import com.hazelcast.map.operation.KeyBasedMapOperation;
import com.hazelcast.map.record.Record;
import com.hazelcast.nio.serialization.Data;

public class GetEntryViewOperation
extends KeyBasedMapOperation {
    private EntryView<Data, Data> result;

    public GetEntryViewOperation(String name, Data dataKey) {
        super(name, dataKey);
    }

    public GetEntryViewOperation() {
    }

    @Override
    public void run() {
        MapService mapService = (MapService)this.getService();
        RecordStore recordStore = mapService.getRecordStore(this.getPartitionId(), this.name);
        Record record = recordStore.getRecord(this.dataKey);
        if (record != null) {
            this.result = new SimpleEntryView<Data, Data>(record.getKey(), mapService.toData(record.getValue()), record.getStatistics(), record.getCost(), record.getVersion());
        }
    }

    @Override
    public Object getResponse() {
        return this.result;
    }

    public String toString() {
        return "GetEntryViewOperation{}";
    }
}

