/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.ClientPartitionService;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.util.ClientCancellableDelegatingFuture;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberSelector;
import com.hazelcast.core.MultiExecutionCallback;
import com.hazelcast.core.PartitionAware;
import com.hazelcast.executor.RunnableAdapter;
import com.hazelcast.executor.client.IsShutdownRequest;
import com.hazelcast.executor.client.TargetCallableRequest;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.monitor.LocalExecutorStats;
import com.hazelcast.nio.Address;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.UuidUtil;
import com.hazelcast.util.executor.CompletedFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public class ClientExecutorServiceProxy
extends ClientProxy
implements IExecutorService {
    private final String name;
    private final Random random = new Random(-System.currentTimeMillis());
    private final AtomicInteger consecutiveSubmits = new AtomicInteger();
    private volatile long lastSubmitTime = 0L;

    public ClientExecutorServiceProxy(String instanceName, String serviceName, String objectId) {
        super(instanceName, serviceName, objectId);
        this.name = objectId;
    }

    @Override
    public void execute(Runnable command, MemberSelector memberSelector) {
        List<Member> members = this.selectMembers(memberSelector);
        int selectedMember = this.random.nextInt(members.size());
        this.executeOnMember(command, members.get(selectedMember));
    }

    @Override
    public void executeOnMembers(Runnable command, MemberSelector memberSelector) {
        List<Member> members = this.selectMembers(memberSelector);
        this.executeOnMembers(command, members);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task, MemberSelector memberSelector) {
        List<Member> members = this.selectMembers(memberSelector);
        int selectedMember = this.random.nextInt(members.size());
        return this.submitToMember(task, members.get(selectedMember));
    }

    @Override
    public <T> Map<Member, Future<T>> submitToMembers(Callable<T> task, MemberSelector memberSelector) {
        List<Member> members = this.selectMembers(memberSelector);
        return this.submitToMembers(task, members);
    }

    @Override
    public void submit(Runnable task, MemberSelector memberSelector, ExecutionCallback callback) {
        List<Member> members = this.selectMembers(memberSelector);
        int selectedMember = this.random.nextInt(members.size());
        this.submitToMember(task, members.get(selectedMember), callback);
    }

    @Override
    public void submitToMembers(Runnable task, MemberSelector memberSelector, MultiExecutionCallback callback) {
        List<Member> members = this.selectMembers(memberSelector);
        this.submitToMembers(task, members, callback);
    }

    @Override
    public <T> void submit(Callable<T> task, MemberSelector memberSelector, ExecutionCallback<T> callback) {
        List<Member> members = this.selectMembers(memberSelector);
        int selectedMember = this.random.nextInt(members.size());
        this.submitToMember(task, members.get(selectedMember), callback);
    }

    @Override
    public <T> void submitToMembers(Callable<T> task, MemberSelector memberSelector, MultiExecutionCallback callback) {
        List<Member> members = this.selectMembers(memberSelector);
        this.submitToMembers(task, members, callback);
    }

    @Override
    public Future<?> submit(Runnable command) {
        Address partitionOwner = this.getTaskPartitionOwner(command);
        RunnableAdapter callable = this.createRunnableAdapter(command);
        return this.submitToTargetInternal(callable, partitionOwner, false);
    }

    @Override
    public <T> Future<T> submit(Runnable command, T result) {
        Address partitionOwner = this.getTaskPartitionOwner(command);
        RunnableAdapter<T> callable = this.createRunnableAdapter(command);
        return this.submitToTargetInternal(callable, partitionOwner, false, result);
    }

    @Override
    public void execute(Runnable command) {
        Address partitionOwner = this.getTaskPartitionOwner(command);
        RunnableAdapter callable = this.createRunnableAdapter(command);
        this.submitToTargetInternal(callable, partitionOwner, false);
    }

    @Override
    public void executeOnKeyOwner(Runnable command, Object key) {
        RunnableAdapter callable = this.createRunnableAdapter(command);
        this.submitToTargetInternal(callable, this.getPartitionOwner(key), false);
    }

    @Override
    public void executeOnMember(Runnable command, Member member) {
        RunnableAdapter callable = this.createRunnableAdapter(command);
        MemberImpl m = this.getContext().getClusterService().getMember(member.getUuid());
        if (m == null) {
            throw new HazelcastException("Member is not available!!!");
        }
        this.submitToTargetInternal(callable, m.getAddress(), false);
    }

    @Override
    public void executeOnMembers(Runnable command, Collection<Member> members) {
        for (Member member : members) {
            this.executeOnMember(command, member);
        }
    }

    @Override
    public void executeOnAllMembers(Runnable command) {
        RunnableAdapter callable = this.createRunnableAdapter(command);
        Collection<MemberImpl> memberList = this.getContext().getClusterService().getMemberList();
        for (MemberImpl m : memberList) {
            this.submitToTargetInternal(callable, m.getAddress(), false);
        }
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        Address partitionOwner = this.getTaskPartitionOwner(task);
        return this.submitToTargetInternal(task, partitionOwner, false);
    }

    @Override
    public <T> Future<T> submitToKeyOwner(Callable<T> task, Object key) {
        return this.submitToTargetInternal(task, this.getPartitionOwner(key), false);
    }

    @Override
    public <T> Future<T> submitToMember(Callable<T> task, Member member) {
        MemberImpl m = this.getContext().getClusterService().getMember(member.getUuid());
        if (m != null) {
            return this.submitToTargetInternal(task, m.getAddress(), false);
        }
        throw new HazelcastException("Member is not available!!!");
    }

    @Override
    public <T> Map<Member, Future<T>> submitToMembers(Callable<T> task, Collection<Member> members) {
        HashMap<Member, Future<T>> futureMap = new HashMap<Member, Future<T>>(members.size());
        ClientClusterService clusterService = this.getContext().getClusterService();
        for (Member m : members) {
            MemberImpl member = clusterService.getMember(m.getUuid());
            if (member == null) {
                throw new HazelcastException("Member is not available!!!");
            }
            ICompletableFuture<T> f = this.submitToTargetInternal(task, member.getAddress(), true);
            futureMap.put(m, f);
        }
        return futureMap;
    }

    @Override
    public <T> Map<Member, Future<T>> submitToAllMembers(Callable<T> task) {
        Collection<MemberImpl> memberList = this.getContext().getClusterService().getMemberList();
        HashMap<Member, Future<T>> futureMap = new HashMap<Member, Future<T>>(memberList.size());
        for (MemberImpl m : memberList) {
            ICompletableFuture<T> f = this.submitToTargetInternal(task, m.getAddress(), true);
            futureMap.put(m, f);
        }
        return futureMap;
    }

    @Override
    public void submit(Runnable command, ExecutionCallback callback) {
        Address partitionOwner = this.getTaskPartitionOwner(command);
        RunnableAdapter callable = this.createRunnableAdapter(command);
        this.submitToTargetInternal(callable, partitionOwner, callback);
    }

    @Override
    public void submitToKeyOwner(Runnable command, Object key, ExecutionCallback callback) {
        RunnableAdapter callable = this.createRunnableAdapter(command);
        this.submitToTargetInternal(callable, this.getPartitionOwner(key), callback);
    }

    @Override
    public void submitToMember(Runnable command, Member member, ExecutionCallback callback) {
        RunnableAdapter callable = this.createRunnableAdapter(command);
        MemberImpl m = this.getContext().getClusterService().getMember(member.getUuid());
        if (m == null) {
            throw new HazelcastException("Member is not available!!!");
        }
        this.submitToTargetInternal(callable, m.getAddress(), callback);
    }

    @Override
    public void submitToMembers(Runnable command, Collection<Member> members, MultiExecutionCallback callback) {
        MultiExecutionCallbackWrapper multiExecutionCallbackWrapper = new MultiExecutionCallbackWrapper(members.size(), callback);
        for (Member member : members) {
            ExecutionCallbackWrapper executionCallback = new ExecutionCallbackWrapper(multiExecutionCallbackWrapper, member);
            this.submitToMember(command, member, executionCallback);
        }
    }

    @Override
    public void submitToAllMembers(Runnable command, MultiExecutionCallback callback) {
        Collection<MemberImpl> memberList = this.getContext().getClusterService().getMemberList();
        MultiExecutionCallbackWrapper multiExecutionCallbackWrapper = new MultiExecutionCallbackWrapper(memberList.size(), callback);
        for (MemberImpl member : memberList) {
            ExecutionCallbackWrapper executionCallback = new ExecutionCallbackWrapper(multiExecutionCallbackWrapper, member);
            this.submitToMember(command, (Member)member, executionCallback);
        }
    }

    @Override
    public <T> void submit(Callable<T> task, ExecutionCallback<T> callback) {
        Address partitionOwner = this.getTaskPartitionOwner(task);
        this.submitToTargetInternal(task, partitionOwner, callback);
    }

    @Override
    public <T> void submitToKeyOwner(Callable<T> task, Object key, ExecutionCallback<T> callback) {
        this.submitToTargetInternal(task, this.getPartitionOwner(key), callback);
    }

    @Override
    public <T> void submitToMember(Callable<T> task, Member member, ExecutionCallback<T> callback) {
        MemberImpl m = this.getContext().getClusterService().getMember(member.getUuid());
        if (m == null) {
            throw new HazelcastException("Member is not available!!!");
        }
        this.submitToTargetInternal(task, m.getAddress(), callback);
    }

    @Override
    public <T> void submitToMembers(Callable<T> task, Collection<Member> members, MultiExecutionCallback callback) {
        MultiExecutionCallbackWrapper multiExecutionCallbackWrapper = new MultiExecutionCallbackWrapper(members.size(), callback);
        for (Member member : members) {
            ExecutionCallbackWrapper executionCallback = new ExecutionCallbackWrapper(multiExecutionCallbackWrapper, member);
            this.submitToMember(task, member, executionCallback);
        }
    }

    @Override
    public <T> void submitToAllMembers(Callable<T> task, MultiExecutionCallback callback) {
        Collection<MemberImpl> memberList = this.getContext().getClusterService().getMemberList();
        MultiExecutionCallbackWrapper multiExecutionCallbackWrapper = new MultiExecutionCallbackWrapper(memberList.size(), callback);
        for (MemberImpl member : memberList) {
            ExecutionCallbackWrapper executionCallback = new ExecutionCallbackWrapper(multiExecutionCallbackWrapper, member);
            this.submitToMember(task, (Member)member, executionCallback);
        }
    }

    @Override
    public LocalExecutorStats getLocalExecutorStats() {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    @Override
    public void shutdown() {
        this.destroy();
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown();
        return Collections.emptyList();
    }

    @Override
    public boolean isShutdown() {
        try {
            IsShutdownRequest request = new IsShutdownRequest(this.name);
            Boolean result = (Boolean)this.invoke(request);
            return result;
        }
        catch (HazelcastInstanceNotActiveException e) {
            return true;
        }
    }

    @Override
    public boolean isTerminated() {
        return this.isShutdown();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return false;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        ArrayList<ICompletableFuture<T>> futures = new ArrayList<ICompletableFuture<T>>(tasks.size());
        ArrayList<Future<T>> result = new ArrayList<Future<T>>(tasks.size());
        for (Callable<T> task : tasks) {
            Address address = this.getTaskPartitionOwner(task);
            futures.add(this.submitToTargetInternal(task, address, true));
        }
        ExecutorService asyncExecutor = this.getContext().getExecutionService().getAsyncExecutor();
        for (Future future : futures) {
            Object value;
            try {
                value = future.get();
            }
            catch (ExecutionException e) {
                value = e;
            }
            result.add(new CompletedFuture(this.getContext().getSerializationService(), value, asyncExecutor));
        }
        return result;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void onDestroy() {
    }

    private Address getTaskPartitionOwner(Object task) {
        if (task instanceof PartitionAware) {
            Object partitionKey = ((PartitionAware)task).getPartitionKey();
            return this.getPartitionOwner(partitionKey);
        }
        ClientPartitionService partitionService = this.getContext().getPartitionService();
        int partitionId = this.random.nextInt(partitionService.getPartitionCount());
        return partitionService.getPartitionOwner(partitionId);
    }

    private Address getPartitionOwner(Object key) {
        ClientPartitionService partitionService = this.getContext().getPartitionService();
        int partitionId = partitionService.getPartitionId(key);
        return partitionService.getPartitionOwner(partitionId);
    }

    private <T> RunnableAdapter<T> createRunnableAdapter(Runnable command) {
        if (command == null) {
            throw new NullPointerException();
        }
        return new RunnableAdapter(command);
    }

    private <T> ICompletableFuture<T> submitToTargetInternal(Callable<T> task, Address address, boolean preventSync) {
        return this.submitToTargetInternal(task, address, preventSync, null);
    }

    private <T> ICompletableFuture<T> submitToTargetInternal(Callable<T> task, Address address, boolean preventSync, T defaultValue) {
        this.check(task);
        String uuid = this.getUUID();
        TargetCallableRequest request = new TargetCallableRequest(this.name, uuid, task, address);
        ICompletableFuture f = this.invokeFuture(request);
        return this.checkSync(f, uuid, address, preventSync, defaultValue);
    }

    private <T> void submitToTargetInternal(Callable<T> task, Address address, ExecutionCallback<T> callback) {
        this.check(task);
        TargetCallableRequest request = new TargetCallableRequest(this.name, null, task, address);
        ICompletableFuture f = this.invokeFuture(request);
        f.andThen(callback);
    }

    private void check(Callable task) {
        if (task == null) {
            throw new NullPointerException();
        }
    }

    public String toString() {
        return "IExecutorService{name='" + this.getName() + '\'' + '}';
    }

    private <T> ICompletableFuture<T> checkSync(ICompletableFuture<T> f, String uuid, Address address, boolean preventSync, T defaultValue) {
        boolean sync = false;
        long last = this.lastSubmitTime;
        long now = Clock.currentTimeMillis();
        if (last + 10L < now) {
            this.consecutiveSubmits.set(0);
        } else if (this.consecutiveSubmits.incrementAndGet() % 100 == 0) {
            sync = true;
        }
        this.lastSubmitTime = now;
        if (sync && !preventSync) {
            Object response;
            try {
                response = f.get();
            }
            catch (Exception e) {
                response = e;
            }
            ExecutorService asyncExecutor = this.getContext().getExecutionService().getAsyncExecutor();
            return new CompletedFuture(this.getContext().getSerializationService(), response, asyncExecutor);
        }
        if (defaultValue != null) {
            return new ClientCancellableDelegatingFuture<T>(f, this.getContext(), uuid, address, defaultValue);
        }
        return new ClientCancellableDelegatingFuture(f, this.getContext(), uuid, address);
    }

    private List<Member> selectMembers(MemberSelector memberSelector) {
        if (memberSelector == null) {
            throw new IllegalArgumentException("memberSelector must not be null");
        }
        ArrayList<Member> selected = new ArrayList<Member>();
        Collection<MemberImpl> members = this.getContext().getClusterService().getMemberList();
        for (MemberImpl member : members) {
            if (!memberSelector.select(member)) continue;
            selected.add(member);
        }
        return selected;
    }

    private ICompletableFuture invokeFuture(TargetCallableRequest request) {
        try {
            return this.getContext().getInvocationService().invokeOnTarget(request, request.getTarget());
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    private String getUUID() {
        return UuidUtil.buildRandomUuidString();
    }

    private static class MultiExecutionCallbackWrapper
    implements MultiExecutionCallback {
        private final AtomicInteger members;
        private final MultiExecutionCallback multiExecutionCallback;
        private final Map<Member, Object> values;

        private MultiExecutionCallbackWrapper(int memberSize, MultiExecutionCallback multiExecutionCallback) {
            this.multiExecutionCallback = multiExecutionCallback;
            this.members = new AtomicInteger(memberSize);
            this.values = new HashMap<Member, Object>(memberSize);
        }

        @Override
        public void onResponse(Member member, Object value) {
            this.multiExecutionCallback.onResponse(member, value);
            this.values.put(member, value);
            int waitingResponse = this.members.decrementAndGet();
            if (waitingResponse == 0) {
                this.onComplete(this.values);
            }
        }

        @Override
        public void onComplete(Map<Member, Object> values) {
            this.multiExecutionCallback.onComplete(values);
        }
    }

    private static class ExecutionCallbackWrapper<T>
    implements ExecutionCallback<T> {
        MultiExecutionCallbackWrapper multiExecutionCallbackWrapper;
        Member member;

        private ExecutionCallbackWrapper(MultiExecutionCallbackWrapper multiExecutionCallback, Member member) {
            this.multiExecutionCallbackWrapper = multiExecutionCallback;
            this.member = member;
        }

        @Override
        public void onResponse(T response) {
            this.multiExecutionCallbackWrapper.onResponse(this.member, response);
        }

        @Override
        public void onFailure(Throwable t) {
        }
    }
}

