/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.IOUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ServiceLoader {
    private static final ILogger logger = Logger.getLogger(ServiceLoader.class);

    private ServiceLoader() {
    }

    public static <T> T load(Class<T> clazz, String factoryId, ClassLoader classLoader) throws Exception {
        Iterator<T> iter = ServiceLoader.iterator(clazz, factoryId, classLoader);
        if (iter.hasNext()) {
            return iter.next();
        }
        return null;
    }

    public static <T> Iterator<T> iterator(final Class<T> clazz, String factoryId, ClassLoader classLoader) throws Exception {
        final Set<ServiceDefinition> serviceDefinitions = ServiceLoader.parse(factoryId, classLoader);
        ClassLoader systemClassLoader = ServiceLoader.class.getClassLoader();
        if (classLoader != null && systemClassLoader != classLoader) {
            Set<ServiceDefinition> systemDefinitions = ServiceLoader.parse(factoryId, systemClassLoader);
            serviceDefinitions.addAll(systemDefinitions);
        }
        if (serviceDefinitions.isEmpty()) {
            Logger.getLogger(ServiceLoader.class).warning("Service loader could not load 'META-INF/services/" + factoryId + "' It may be empty or does not exist.");
        }
        return new Iterator<T>(){
            final Iterator<ServiceDefinition> iterator;
            {
                this.iterator = serviceDefinitions.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public T next() {
                ServiceDefinition definition = this.iterator.next();
                try {
                    String className = definition.className;
                    ClassLoader classLoader = definition.classLoader;
                    return clazz.cast(ClassLoaderUtil.newInstance(classLoader, className));
                }
                catch (Exception e) {
                    throw new HazelcastException(e);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<ServiceDefinition> parse(String factoryId, ClassLoader classLoader) {
        ClassLoader cl = classLoader == null ? Thread.currentThread().getContextClassLoader() : classLoader;
        String resourceName = "META-INF/services/" + factoryId;
        try {
            Enumeration<URL> configs = cl != null ? cl.getResources(resourceName) : ClassLoader.getSystemResources(resourceName);
            HashSet<ServiceDefinition> names = new HashSet<ServiceDefinition>();
            while (configs.hasMoreElements()) {
                URL url = configs.nextElement();
                BufferedReader r = null;
                try {
                    String line;
                    r = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
                    while ((line = r.readLine()) != null) {
                        String name;
                        int comment = line.indexOf(35);
                        if (comment >= 0) {
                            line = line.substring(0, comment);
                        }
                        if ((name = line.trim()).length() == 0) continue;
                        names.add(new ServiceDefinition(name, cl));
                    }
                }
                catch (Throwable throwable) {
                    IOUtil.closeResource(r);
                    throw throwable;
                }
                IOUtil.closeResource(r);
            }
            return names;
        }
        catch (Exception e) {
            logger.severe(e);
            return Collections.emptySet();
        }
    }

    private static class ServiceDefinition {
        private final String className;
        private final ClassLoader classLoader;

        private ServiceDefinition(String className, ClassLoader classLoader) {
            this.className = className;
            this.classLoader = classLoader;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ServiceDefinition that = (ServiceDefinition)o;
            return !(this.className != null ? !this.className.equals(that.className) : that.className != null);
        }

        public int hashCode() {
            return this.className != null ? this.className.hashCode() : 0;
        }
    }
}

