/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

import com.hazelcast.client.ClientEngineImpl;
import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.instance.Node;
import com.hazelcast.jmx.InstanceMBean;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ConnectionManager;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.ExecutionService;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.ProxyService;
import com.hazelcast.util.HealthMonitorLevel;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class HealthMonitor
extends Thread {
    private final ILogger logger;
    private final Node node;
    private final Runtime runtime;
    private final OperatingSystemMXBean osMxBean;
    private final HealthMonitorLevel logLevel;
    private final HazelcastInstanceImpl hazelcastInstance;
    private final InstanceMBean instanceMBean;
    private final int delaySeconds;
    private final ExecutionService executionService;
    private final EventService eventService;
    private final OperationService operationService;
    private final ProxyService proxyService;
    private final ConnectionManager connectionManager;
    private final ClientEngineImpl clientEngine;
    private final ThreadMXBean threadMxBean;
    private double treshold = 70.0;
    private static final String[] UNITS = new String[]{"", "K", "M", "G", "T", "P", "E"};

    public HealthMonitor(HazelcastInstanceImpl hazelcastInstance, HealthMonitorLevel logLevel, int delaySeconds) {
        super(hazelcastInstance.node.threadGroup, hazelcastInstance.node.getThreadNamePrefix("HealthMonitor"));
        this.setDaemon(true);
        this.hazelcastInstance = hazelcastInstance;
        this.node = hazelcastInstance.node;
        this.logger = this.node.getLogger(HealthMonitor.class.getName());
        this.runtime = Runtime.getRuntime();
        this.osMxBean = ManagementFactory.getOperatingSystemMXBean();
        this.logLevel = logLevel;
        this.instanceMBean = hazelcastInstance.getManagementService().getInstanceMBean();
        this.delaySeconds = delaySeconds;
        this.threadMxBean = ManagementFactory.getThreadMXBean();
        this.executionService = this.node.nodeEngine.getExecutionService();
        this.eventService = this.node.nodeEngine.getEventService();
        this.operationService = this.node.nodeEngine.getOperationService();
        this.proxyService = this.node.nodeEngine.getProxyService();
        this.clientEngine = this.node.clientEngine;
        this.connectionManager = this.node.connectionManager;
    }

    @Override
    public void run() {
        if (this.logLevel == HealthMonitorLevel.OFF) {
            return;
        }
        while (this.node.isActive()) {
            switch (this.logLevel) {
                case NOISY: {
                    HealthMetrics metrics = new HealthMetrics();
                    this.logger.log(Level.INFO, metrics.toString());
                    break;
                }
                case SILENT: {
                    HealthMetrics metrics = new HealthMetrics();
                    if (!metrics.exceedsTreshold()) break;
                    this.logger.log(Level.INFO, metrics.toString());
                    break;
                }
                default: {
                    throw new IllegalStateException("unrecognized logLevel:" + (Object)((Object)this.logLevel));
                }
            }
            try {
                Thread.sleep(TimeUnit.SECONDS.toMillis(this.delaySeconds));
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    private static Long get(OperatingSystemMXBean mbean, String methodName, Long defaultValue) {
        try {
            Method method = mbean.getClass().getMethod(methodName, new Class[0]);
            method.setAccessible(true);
            Object value = method.invoke((Object)mbean, new Object[0]);
            if (value == null) {
                return defaultValue;
            }
            if (value instanceof Integer) {
                return (long)((Integer)value);
            }
            if (value instanceof Double) {
                double v = (Double)value;
                return Math.round(v * 100.0);
            }
            if (value instanceof Long) {
                return (Long)value;
            }
            return defaultValue;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String percentageString(double p) {
        return String.format("%.2f", p) + "%";
    }

    public static String bytesToString(long bytes) {
        for (int i = 6; i > 0; --i) {
            double step = Math.pow(1024.0, i);
            if (!((double)bytes > step)) continue;
            return String.format("%3.1f%s", (double)bytes / step, UNITS[i]);
        }
        return Long.toString(bytes);
    }

    public class HealthMetrics {
        private final long memoryFree;
        private final long memoryTotal;
        private final long memoryUsed;
        private final long memoryMax;
        private final double memoryUsedOfTotalPercentage;
        private final double memoryUsedOfMaxPercentage;
        private final double processCpuLoad;
        private final double systemLoadAverage;
        private final double systemCpuLoad;
        private final int threadCount;
        private final int peakThreadCount;
        private final int asyncExecutorQueueSize;
        private final int clientExecutorQueueSize;
        private final int operationExecutorQueueSize;
        private final int queryExecutorQueueSize;
        private final int scheduledExecutorQueueSize;
        private final int systemExecutorQueueSize;
        private final int eventQueueSize;
        private final int operationServiceOperationExecutorQueueSize;
        private final int operationServiceOperationResponseQueueSize;
        private final int runningOperationsCount;
        private final int remoteOperationsCount;
        private final int proxyCount;
        private final int clientEndpointCount;
        private final int activeConnectionCount;
        private final int connectionCount;
        private final int ioExecutorQueueSize;

        public HealthMetrics() {
            this.memoryFree = HealthMonitor.this.runtime.freeMemory();
            this.memoryTotal = HealthMonitor.this.runtime.totalMemory();
            this.memoryUsed = this.memoryTotal - this.memoryFree;
            this.memoryMax = HealthMonitor.this.runtime.maxMemory();
            this.memoryUsedOfTotalPercentage = 100.0 * (double)this.memoryUsed / (double)this.memoryTotal;
            this.memoryUsedOfMaxPercentage = 100.0 * (double)this.memoryUsed / (double)this.memoryMax;
            this.processCpuLoad = HealthMonitor.get(HealthMonitor.this.osMxBean, "getProcessCpuLoad", -1L).longValue();
            this.systemLoadAverage = HealthMonitor.get(HealthMonitor.this.osMxBean, "getSystemLoadAverage", -1L).longValue();
            this.systemCpuLoad = HealthMonitor.get(HealthMonitor.this.osMxBean, "getSystemCpuLoad", -1L).longValue();
            this.threadCount = HealthMonitor.this.threadMxBean.getThreadCount();
            this.peakThreadCount = HealthMonitor.this.threadMxBean.getPeakThreadCount();
            this.asyncExecutorQueueSize = HealthMonitor.this.executionService.getExecutor("hz:async").queueSize();
            this.clientExecutorQueueSize = HealthMonitor.this.executionService.getExecutor("hz:client").queueSize();
            this.operationExecutorQueueSize = HealthMonitor.this.executionService.getExecutor("hz:operation").queueSize();
            this.queryExecutorQueueSize = HealthMonitor.this.executionService.getExecutor("hz:query").queueSize();
            this.scheduledExecutorQueueSize = HealthMonitor.this.executionService.getExecutor("hz:scheduled").queueSize();
            this.systemExecutorQueueSize = HealthMonitor.this.executionService.getExecutor("hz:system").queueSize();
            this.ioExecutorQueueSize = HealthMonitor.this.executionService.getExecutor("hz:io").queueSize();
            this.eventQueueSize = HealthMonitor.this.eventService.getEventQueueSize();
            this.operationServiceOperationExecutorQueueSize = HealthMonitor.this.operationService.getOperationExecutorQueueSize();
            this.operationServiceOperationResponseQueueSize = HealthMonitor.this.operationService.getResponseQueueSize();
            this.runningOperationsCount = HealthMonitor.this.operationService.getRunningOperationsCount();
            this.remoteOperationsCount = HealthMonitor.this.operationService.getRemoteOperationsCount();
            this.proxyCount = HealthMonitor.this.proxyService.getProxyCount();
            this.clientEndpointCount = HealthMonitor.this.clientEngine.getClientEndpointCount();
            this.activeConnectionCount = HealthMonitor.this.connectionManager.getActiveConnectionCount();
            this.connectionCount = HealthMonitor.this.connectionManager.getConnectionCount();
        }

        public boolean exceedsTreshold() {
            if (this.memoryUsedOfMaxPercentage > HealthMonitor.this.treshold) {
                return true;
            }
            if (this.processCpuLoad > HealthMonitor.this.treshold) {
                return true;
            }
            if (this.systemCpuLoad > HealthMonitor.this.treshold) {
                return true;
            }
            return this.systemCpuLoad > HealthMonitor.this.treshold;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("memory.used=").append(HealthMonitor.bytesToString(this.memoryUsed)).append(", ");
            sb.append("memory.free=").append(HealthMonitor.bytesToString(this.memoryFree)).append(", ");
            sb.append("memory.total=").append(HealthMonitor.bytesToString(this.memoryTotal)).append(", ");
            sb.append("memory.max=").append(HealthMonitor.bytesToString(this.memoryMax)).append(", ");
            sb.append("memory.used/total=").append(HealthMonitor.percentageString(this.memoryUsedOfTotalPercentage)).append(", ");
            sb.append("memory.used/max=").append(HealthMonitor.percentageString(this.memoryUsedOfMaxPercentage)).append(", ");
            sb.append("load.process=").append(String.format("%.2f", this.processCpuLoad)).append("%, ");
            sb.append("load.system=").append(String.format("%.2f", this.systemCpuLoad)).append("%, ");
            sb.append("load.systemAverage=").append(String.format("%.2f", this.systemLoadAverage)).append("%, ");
            sb.append("thread.count=").append(this.threadCount).append(", ");
            sb.append("thread.peakCount=").append(this.peakThreadCount).append(", ");
            sb.append("event.q.size=").append(this.eventQueueSize).append(", ");
            sb.append("executor.q.async.size=").append(this.asyncExecutorQueueSize).append(", ");
            sb.append("executor.q.client.size=").append(this.clientExecutorQueueSize).append(", ");
            sb.append("executor.q.operation.size=").append(this.operationExecutorQueueSize).append(", ");
            sb.append("executor.q.query.size=").append(this.queryExecutorQueueSize).append(", ");
            sb.append("executor.q.scheduled.size=").append(this.scheduledExecutorQueueSize).append(", ");
            sb.append("executor.q.io.size=").append(this.ioExecutorQueueSize).append(", ");
            sb.append("executor.q.system.size=").append(this.systemExecutorQueueSize).append(", ");
            sb.append("executor.q.operation.size=").append(this.operationServiceOperationExecutorQueueSize).append(", ");
            sb.append("executor.q.response.size=").append(this.operationServiceOperationResponseQueueSize).append(", ");
            sb.append("operations.remote.size=").append(this.remoteOperationsCount).append(", ");
            sb.append("operations.running.size=").append(this.runningOperationsCount).append(", ");
            sb.append("proxy.count=").append(this.proxyCount).append(", ");
            sb.append("clientEndpoint.count=").append(this.clientEndpointCount).append(", ");
            sb.append("connection.active.count=").append(this.activeConnectionCount).append(", ");
            sb.append("connection.count=").append(this.connectionCount);
            return sb.toString();
        }
    }
}

