/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.queue.client;

import com.hazelcast.client.CallableClientRequest;
import com.hazelcast.client.RetryableRequest;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.queue.QueueContainer;
import com.hazelcast.queue.QueuePortableHook;
import com.hazelcast.queue.QueueService;
import java.io.IOException;

public class RemainingCapacityRequest
extends CallableClientRequest
implements Portable,
RetryableRequest {
    protected String name;

    public RemainingCapacityRequest() {
    }

    public RemainingCapacityRequest(String name) {
        this.name = name;
    }

    @Override
    public int getFactoryId() {
        return QueuePortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 13;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
    }

    public Object call() throws Exception {
        QueueService service = (QueueService)this.getService();
        QueueContainer container = service.getOrCreateContainer(this.name, false);
        return container.getConfig().getMaxSize() - container.size();
    }

    @Override
    public String getServiceName() {
        return "hz:impl:queueService";
    }
}

