/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.partition;

import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.BufferObjectDataInput;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.partition.PartitionServiceImpl;
import com.hazelcast.partition.ReplicaErrorLogger;
import com.hazelcast.spi.BackupOperation;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionAwareOperation;
import com.hazelcast.spi.ResponseHandler;
import com.hazelcast.spi.UrgentSystemOperation;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;

public class ReplicaSyncResponse
extends Operation
implements PartitionAwareOperation,
BackupOperation,
UrgentSystemOperation {
    private byte[] data;
    private long[] replicaVersions;

    public ReplicaSyncResponse() {
    }

    public ReplicaSyncResponse(byte[] data, long[] replicaVersions) {
        this.data = data;
        this.replicaVersions = replicaVersions;
    }

    @Override
    public void beforeRun() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        PartitionServiceImpl partitionService = (PartitionServiceImpl)nodeEngine.getPartitionService();
        SerializationService serializationService = nodeEngine.getSerializationService();
        int partitionId = this.getPartitionId();
        int replicaIndex = this.getReplicaIndex();
        BufferObjectDataInput in = null;
        try {
            if (this.data != null) {
                ILogger logger = nodeEngine.getLogger(this.getClass());
                if (logger.isFinestEnabled()) {
                    logger.finest("Applying replica sync for partition: " + partitionId + ", replica: " + replicaIndex);
                }
                byte[] taskData = IOUtil.decompress(this.data);
                in = serializationService.createObjectDataInput(taskData);
                int size = in.readInt();
                for (int i = 0; i < size; ++i) {
                    Operation op = (Operation)serializationService.readObject(in);
                    try {
                        op.setNodeEngine(nodeEngine).setPartitionId(partitionId).setReplicaIndex(replicaIndex);
                        op.setResponseHandler(new ErrorLoggingResponseHandler(nodeEngine.getLogger(op.getClass())));
                        op.beforeRun();
                        op.run();
                        op.afterRun();
                        continue;
                    }
                    catch (Throwable e) {
                        Level level;
                        Level level2 = level = nodeEngine.isActive() ? Level.WARNING : Level.FINEST;
                        if (!logger.isLoggable(level)) continue;
                        logger.log(level, "While executing " + op, e);
                    }
                }
            }
        }
        finally {
            IOUtil.closeResource(in);
            partitionService.finalizeReplicaSync(partitionId, this.replicaVersions);
        }
    }

    @Override
    public void afterRun() throws Exception {
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public Object getResponse() {
        return null;
    }

    @Override
    public boolean validatesTarget() {
        return true;
    }

    @Override
    public void logError(Throwable e) {
        ReplicaErrorLogger.log(e, this.getLogger());
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        IOUtil.writeByteArray(out, this.data);
        out.writeLongArray(this.replicaVersions);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.data = IOUtil.readByteArray(in);
        this.replicaVersions = in.readLongArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ReplicaSyncResponse");
        sb.append("{partition=").append(this.getPartitionId());
        sb.append(", replica=").append(this.getReplicaIndex());
        sb.append(", version=").append(Arrays.toString(this.replicaVersions));
        sb.append('}');
        return sb.toString();
    }

    private static class ErrorLoggingResponseHandler
    implements ResponseHandler {
        private final ILogger logger;

        private ErrorLoggingResponseHandler(ILogger logger) {
            this.logger = logger;
        }

        @Override
        public void sendResponse(Object obj) {
            if (obj instanceof Throwable) {
                Throwable t = (Throwable)obj;
                this.logger.severe(t);
            }
        }

        @Override
        public boolean isLocal() {
            return true;
        }
    }
}

