/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.osgi;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.osgi.OSGiScriptEngine;
import com.hazelcast.osgi.OSGiScriptEngineFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.SimpleBindings;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class OSGiScriptEngineManager
extends ScriptEngineManager {
    private Bindings bindings;
    private Map<ScriptEngineManager, ClassLoader> classLoaders;
    private BundleContext context;
    private final ILogger logger = Logger.getLogger(this.getClass());

    public OSGiScriptEngineManager(BundleContext context) {
        this.context = context;
        this.bindings = new SimpleBindings();
        this.classLoaders = this.findManagers(context);
    }

    public void reloadManagers() {
        this.classLoaders = this.findManagers(this.context);
    }

    @Override
    public Object get(String key) {
        return this.bindings.get(key);
    }

    @Override
    public Bindings getBindings() {
        return this.bindings;
    }

    @Override
    public void setBindings(Bindings bindings) {
        this.bindings = bindings;
        for (ScriptEngineManager manager : this.classLoaders.keySet()) {
            manager.setBindings(bindings);
        }
    }

    @Override
    public ScriptEngine getEngineByExtension(String extension) {
        ScriptEngine engine = null;
        for (ScriptEngineManager manager : this.classLoaders.keySet()) {
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.classLoaders.get(manager));
            engine = manager.getEngineByExtension(extension);
            Thread.currentThread().setContextClassLoader(old);
            if (engine == null) continue;
            break;
        }
        return engine;
    }

    @Override
    public ScriptEngine getEngineByMimeType(String mimeType) {
        ScriptEngine engine = null;
        for (ScriptEngineManager manager : this.classLoaders.keySet()) {
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.classLoaders.get(manager));
            engine = manager.getEngineByMimeType(mimeType);
            Thread.currentThread().setContextClassLoader(old);
            if (engine == null) continue;
            break;
        }
        return engine;
    }

    @Override
    public ScriptEngine getEngineByName(String shortName) {
        for (ScriptEngineManager manager : this.classLoaders.keySet()) {
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.classLoaders.get(manager));
            ScriptEngine engine = manager.getEngineByName(shortName);
            Thread.currentThread().setContextClassLoader(old);
            if (engine == null) continue;
            return new OSGiScriptEngine(engine, new OSGiScriptEngineFactory(engine.getFactory(), this.classLoaders.get(manager)));
        }
        return null;
    }

    @Override
    public List<ScriptEngineFactory> getEngineFactories() {
        ArrayList<ScriptEngineFactory> osgiFactories = new ArrayList<ScriptEngineFactory>();
        for (ScriptEngineManager engineManager : this.classLoaders.keySet()) {
            for (ScriptEngineFactory factory : engineManager.getEngineFactories()) {
                osgiFactories.add(new OSGiScriptEngineFactory(factory, this.classLoaders.get(engineManager)));
            }
        }
        return osgiFactories;
    }

    @Override
    public void put(String key, Object value) {
        this.bindings.put(key, value);
    }

    @Override
    public void registerEngineExtension(String extension, ScriptEngineFactory factory) {
        for (ScriptEngineManager engineManager : this.classLoaders.keySet()) {
            engineManager.registerEngineExtension(extension, factory);
        }
    }

    @Override
    public void registerEngineMimeType(String type, ScriptEngineFactory factory) {
        for (ScriptEngineManager engineManager : this.classLoaders.keySet()) {
            engineManager.registerEngineMimeType(type, factory);
        }
    }

    @Override
    public void registerEngineName(String name, ScriptEngineFactory factory) {
        for (ScriptEngineManager engineManager : this.classLoaders.keySet()) {
            engineManager.registerEngineName(name, factory);
        }
    }

    private Map<ScriptEngineManager, ClassLoader> findManagers(BundleContext context) {
        HashMap<ScriptEngineManager, ClassLoader> managers = new HashMap<ScriptEngineManager, ClassLoader>();
        try {
            for (String factoryName : this.findFactoryCandidates(context)) {
                ClassLoader factoryLoader;
                try {
                    factoryLoader = Class.forName(factoryName).getClassLoader();
                }
                catch (ClassNotFoundException cnfe) {
                    this.logger.warning("Found ScriptEngineFactory candidate for " + factoryName + ", but cannot load class! -> " + cnfe);
                    if (!this.logger.isFinestEnabled()) continue;
                    this.logger.finest(cnfe);
                    continue;
                }
                try {
                    ScriptEngineManager manager = new ScriptEngineManager(factoryLoader);
                    manager.setBindings(this.bindings);
                    managers.put(manager, factoryLoader);
                }
                catch (Exception e) {
                    this.logger.warning("Found ScriptEngineFactory candidate for " + factoryName + ", but could not load ScripEngineManager! -> " + e);
                    if (!this.logger.isFinestEnabled()) continue;
                    this.logger.finest(e);
                }
            }
            return managers;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private List<String> findFactoryCandidates(BundleContext context) throws IOException {
        Bundle[] bundles = context.getBundles();
        ArrayList<String> factoryCandidates = new ArrayList<String>();
        for (Bundle bundle : bundles) {
            Enumeration urls;
            if (bundle.getSymbolicName().equals("system.bundle") || (urls = bundle.findEntries("META-INF/services", "javax.script.ScriptEngineFactory", false)) == null) continue;
            while (urls.hasMoreElements()) {
                String line;
                URL u = (URL)urls.nextElement();
                BufferedReader reader = new BufferedReader(new InputStreamReader(u.openStream()));
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).startsWith("#") || line.length() <= 0) continue;
                    factoryCandidates.add(line);
                }
                reader.close();
            }
        }
        factoryCandidates.add("com.sun.script.javascript.RhinoScriptEngineFactory");
        return factoryCandidates;
    }
}

