/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap;

import com.hazelcast.config.MultiMapConfig;
import com.hazelcast.multimap.MultiMapRecord;
import com.hazelcast.multimap.MultiMapService;
import com.hazelcast.multimap.MultiMapWrapper;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.AbstractOperation;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MultiMapMigrationOperation
extends AbstractOperation {
    Map<String, Map> map;

    public MultiMapMigrationOperation() {
    }

    public MultiMapMigrationOperation(Map<String, Map> map) {
        this.map = map;
    }

    @Override
    public void run() throws Exception {
        MultiMapService service = (MultiMapService)this.getService();
        service.insertMigratedData(this.getPartitionId(), this.map);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeInt(this.map.size());
        for (Map.Entry<String, Map> entry : this.map.entrySet()) {
            String name = entry.getKey();
            out.writeUTF(name);
            Map collections = entry.getValue();
            out.writeInt(collections.size());
            for (Map.Entry collectionEntry : collections.entrySet()) {
                Data key = (Data)collectionEntry.getKey();
                key.writeData(out);
                MultiMapWrapper wrapper = (MultiMapWrapper)collectionEntry.getValue();
                Collection<MultiMapRecord> coll = wrapper.getCollection();
                out.writeInt(coll.size());
                String collectionType = MultiMapConfig.ValueCollectionType.SET.name();
                if (coll instanceof List) {
                    collectionType = MultiMapConfig.ValueCollectionType.LIST.name();
                }
                out.writeUTF(collectionType);
                for (MultiMapRecord record : coll) {
                    record.writeData(out);
                }
            }
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        int mapSize = in.readInt();
        this.map = new HashMap<String, Map>(mapSize);
        for (int i = 0; i < mapSize; ++i) {
            String name = in.readUTF();
            int collectionSize = in.readInt();
            HashMap<Data, MultiMapWrapper> collections = new HashMap<Data, MultiMapWrapper>();
            for (int j = 0; j < collectionSize; ++j) {
                Data key = new Data();
                key.readData(in);
                int collSize = in.readInt();
                String collectionType = in.readUTF();
                AbstractCollection coll = collectionType.equals(MultiMapConfig.ValueCollectionType.SET.name()) ? new HashSet() : new LinkedList();
                for (int k = 0; k < collSize; ++k) {
                    MultiMapRecord record = new MultiMapRecord();
                    record.readData(in);
                    coll.add((MultiMapRecord)record);
                }
                collections.put(key, new MultiMapWrapper(coll));
            }
            this.map.put(name, collections);
        }
    }
}

