/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.monitor;

import com.hazelcast.monitor.MemberState;
import com.hazelcast.monitor.impl.MemberStateImpl;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TimedMemberState
implements DataSerializable,
Cloneable {
    long time;
    MemberState memberState = null;
    Set<String> instanceNames = null;
    List<String> memberList;
    Boolean master;
    String clusterName;

    public TimedMemberState clone() {
        TimedMemberState st = new TimedMemberState();
        st.setTime(this.time);
        st.setMemberState(this.memberState);
        st.setInstanceNames(this.instanceNames);
        st.setMemberList(this.memberList);
        st.setMaster(this.master);
        st.setClusterName(this.clusterName);
        return st;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.time);
        out.writeBoolean(this.master);
        this.memberState.writeData(out);
        out.writeUTF(this.clusterName);
        int nameCount = this.instanceNames == null ? 0 : this.instanceNames.size();
        out.writeInt(nameCount);
        if (this.instanceNames != null) {
            for (String name : this.instanceNames) {
                out.writeUTF(name);
            }
        }
        int memberCount = this.memberList == null ? 0 : this.memberList.size();
        out.writeInt(memberCount);
        if (this.memberList != null) {
            for (String address : this.memberList) {
                out.writeUTF(address);
            }
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.time = in.readLong();
        this.master = in.readBoolean();
        this.memberState = new MemberStateImpl();
        this.memberState.readData(in);
        this.clusterName = in.readUTF();
        int nameCount = in.readInt();
        this.instanceNames = new HashSet<String>(nameCount);
        for (int i = 0; i < nameCount; ++i) {
            this.instanceNames.add(in.readUTF());
        }
        int memberCount = in.readInt();
        this.memberList = new ArrayList<String>();
        for (int i = 0; i < memberCount; ++i) {
            this.memberList.add(in.readUTF());
        }
    }

    public List<String> getMemberList() {
        return this.memberList;
    }

    public void setMemberList(List<String> memberList) {
        this.memberList = memberList;
    }

    public Boolean getMaster() {
        return this.master;
    }

    public void setMaster(Boolean master) {
        this.master = master;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public long getTime() {
        return this.time;
    }

    public Set<String> getInstanceNames() {
        return this.instanceNames;
    }

    public void setInstanceNames(Set<String> longInstanceNames) {
        this.instanceNames = longInstanceNames;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TimedMemberState{\n");
        sb.append("\t");
        sb.append(this.memberState);
        sb.append("\n");
        sb.append("}\n");
        sb.append("Instances : ");
        sb.append(this.instanceNames);
        return sb.toString();
    }

    public MemberState getMemberState() {
        return this.memberState;
    }

    public void setMemberState(MemberState memberState) {
        this.memberState = memberState;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimedMemberState that = (TimedMemberState)o;
        if (this.time != that.time) {
            return false;
        }
        if (this.clusterName != null ? !this.clusterName.equals(that.clusterName) : that.clusterName != null) {
            return false;
        }
        if (this.instanceNames != null ? !((Object)this.instanceNames).equals(that.instanceNames) : that.instanceNames != null) {
            return false;
        }
        if (this.master != null ? !this.master.equals(that.master) : that.master != null) {
            return false;
        }
        if (this.memberList != null ? !((Object)this.memberList).equals(that.memberList) : that.memberList != null) {
            return false;
        }
        return !(this.memberState != null ? !this.memberState.equals(that.memberState) : that.memberState != null);
    }

    public int hashCode() {
        int result = (int)(this.time ^ this.time >>> 32);
        result = 31 * result + (this.memberState != null ? this.memberState.hashCode() : 0);
        result = 31 * result + (this.instanceNames != null ? ((Object)this.instanceNames).hashCode() : 0);
        result = 31 * result + (this.memberList != null ? ((Object)this.memberList).hashCode() : 0);
        result = 31 * result + (this.master != null ? this.master.hashCode() : 0);
        result = 31 * result + (this.clusterName != null ? this.clusterName.hashCode() : 0);
        return result;
    }
}

