/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.mapreduce.impl.task;

import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.mapreduce.Collator;
import com.hazelcast.mapreduce.JobCompletableFuture;
import com.hazelcast.mapreduce.JobPartitionState;
import com.hazelcast.mapreduce.JobProcessInformation;
import com.hazelcast.mapreduce.JobTracker;
import com.hazelcast.mapreduce.TrackableJob;
import com.hazelcast.mapreduce.impl.MapReduceService;
import com.hazelcast.mapreduce.impl.task.JobSupervisor;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.impl.AbstractCompletableFuture;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.util.ValidationUtil;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TrackableJobFuture<V>
extends AbstractCompletableFuture<V>
implements TrackableJob<V>,
JobCompletableFuture<V> {
    private final String name;
    private final String jobId;
    private final JobTracker jobTracker;
    private final Collator collator;
    private final CountDownLatch latch;
    private final MapReduceService mapReduceService;
    private volatile boolean cancelled;

    public TrackableJobFuture(String name, String jobId, JobTracker jobTracker, NodeEngine nodeEngine, Collator collator) {
        super(nodeEngine, nodeEngine.getLogger(TrackableJobFuture.class));
        this.name = name;
        this.jobId = jobId;
        this.jobTracker = jobTracker;
        this.collator = collator;
        this.latch = new CountDownLatch(1);
        this.mapReduceService = (MapReduceService)((NodeEngineImpl)nodeEngine).getService("hz:impl:mapReduceService");
    }

    @Override
    public void setResult(Object result) {
        Object finalResult = result;
        if (this.collator != null) {
            finalResult = this.collator.collate(((Map)finalResult).entrySet());
        }
        if (finalResult instanceof Throwable && !(finalResult instanceof CancellationException)) {
            finalResult = new ExecutionException((Throwable)finalResult);
        }
        super.setResult(finalResult);
        this.latch.countDown();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        Address jobOwner = this.mapReduceService.getLocalAddress();
        if (!this.mapReduceService.registerJobSupervisorCancellation(this.name, this.jobId, jobOwner)) {
            return false;
        }
        JobSupervisor supervisor = this.mapReduceService.getJobSupervisor(this.name, this.jobId);
        if (supervisor == null || !supervisor.isOwnerNode()) {
            return false;
        }
        CancellationException exception = new CancellationException("Operation was cancelled by the user");
        this.cancelled = supervisor.cancelAndNotify(exception);
        return this.cancelled;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        ValidationUtil.isNotNull(unit, "unit");
        this.latch.await(timeout, unit);
        if (!this.isDone()) {
            throw new TimeoutException("timeout reached");
        }
        return this.getResult();
    }

    @Override
    public JobTracker getJobTracker() {
        return this.jobTracker;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getJobId() {
        return this.jobId;
    }

    @Override
    public ICompletableFuture<V> getCompletableFuture() {
        JobSupervisor supervisor = this.mapReduceService.getJobSupervisor(this.name, this.jobId);
        if (supervisor == null || !supervisor.isOwnerNode()) {
            return null;
        }
        return this;
    }

    @Override
    public JobProcessInformation getJobProcessInformation() {
        JobSupervisor supervisor = this.mapReduceService.getJobSupervisor(this.name, this.jobId);
        if (supervisor == null || !supervisor.isOwnerNode()) {
            return null;
        }
        return new JobProcessInformationAdapter(supervisor.getJobProcessInformation());
    }

    private static final class JobProcessInformationAdapter
    implements JobProcessInformation {
        private final JobProcessInformation processInformation;

        private JobProcessInformationAdapter(JobProcessInformation processInformation) {
            this.processInformation = processInformation;
        }

        @Override
        public JobPartitionState[] getPartitionStates() {
            JobPartitionState[] partitionStates = this.processInformation.getPartitionStates();
            return Arrays.copyOf(partitionStates, partitionStates.length);
        }

        @Override
        public int getProcessedRecords() {
            return this.processInformation.getProcessedRecords();
        }
    }
}

