/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.mapreduce.impl.task;

import com.hazelcast.mapreduce.Combiner;
import com.hazelcast.mapreduce.CombinerFactory;
import com.hazelcast.mapreduce.Context;
import com.hazelcast.mapreduce.impl.task.MapCombineTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class DefaultContext<KeyIn, ValueIn>
implements Context<KeyIn, ValueIn> {
    private final Map<KeyIn, Combiner<KeyIn, ValueIn, ?>> combiners = new HashMap();
    private final CombinerFactory<KeyIn, ValueIn, ?> combinerFactory;
    private final MapCombineTask mapCombineTask;
    private volatile int partitionId;
    private volatile int collected;

    protected DefaultContext(CombinerFactory<KeyIn, ValueIn, ?> combinerFactory, MapCombineTask mapCombineTask) {
        this.mapCombineTask = mapCombineTask;
        this.combinerFactory = combinerFactory != null ? combinerFactory : new CollectingCombinerFactory();
    }

    public void setPartitionId(int partitionId) {
        this.partitionId = partitionId;
    }

    @Override
    public void emit(KeyIn key, ValueIn value) {
        Combiner<KeyIn, ValueIn, ?> combiner = this.getOrCreateCombiner(key);
        combiner.combine(key, value);
        ++this.collected;
        this.mapCombineTask.onEmit(this, this.partitionId);
    }

    public <Chunk> Map<KeyIn, Chunk> requestChunk() {
        HashMap chunkMap = new HashMap(this.combiners.size());
        for (Map.Entry<KeyIn, Combiner<KeyIn, ValueIn, ?>> entry : this.combiners.entrySet()) {
            Object chunk = entry.getValue().finalizeChunk();
            chunkMap.put(entry.getKey(), chunk);
        }
        this.collected = 0;
        return chunkMap;
    }

    public int getCollected() {
        return this.collected;
    }

    public <Chunk> Map<KeyIn, Chunk> finish() {
        for (Combiner<KeyIn, ValueIn, ?> combiner : this.combiners.values()) {
            combiner.finalizeCombine();
        }
        return this.requestChunk();
    }

    private Combiner<KeyIn, ValueIn, ?> getOrCreateCombiner(KeyIn key) {
        Combiner<KeyIn, ValueIn, ?> combiner = this.combiners.get(key);
        if (combiner == null) {
            combiner = this.combinerFactory.newCombiner(key);
            this.combiners.put(key, combiner);
            combiner.beginCombine();
        }
        return combiner;
    }

    private static class CollectingCombinerFactory<KeyIn, ValueIn>
    implements CombinerFactory<KeyIn, ValueIn, List<ValueIn>> {
        private CollectingCombinerFactory() {
        }

        @Override
        public Combiner<KeyIn, ValueIn, List<ValueIn>> newCombiner(KeyIn key) {
            return new Combiner<KeyIn, ValueIn, List<ValueIn>>(){
                private final List<ValueIn> values = new CopyOnWriteArrayList();

                @Override
                public void combine(KeyIn key, ValueIn value) {
                    this.values.add(value);
                }

                @Override
                public List<ValueIn> finalizeChunk() {
                    ArrayList values = new ArrayList(this.values);
                    this.values.clear();
                    return values;
                }
            };
        }
    }
}

