/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.map.operation.BaseRemoveOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import java.io.IOException;

public class TryRemoveOperation
extends BaseRemoveOperation {
    private long timeout;
    private boolean successful = false;

    public TryRemoveOperation(String name, Data dataKey, long timeout) {
        super(name, dataKey);
        this.timeout = timeout;
    }

    public TryRemoveOperation() {
    }

    @Override
    public void run() {
        this.dataOldValue = this.mapService.toData(this.recordStore.remove(this.dataKey));
        this.successful = this.dataOldValue != null;
    }

    @Override
    public void afterRun() {
        if (this.successful) {
            super.afterRun();
        }
    }

    @Override
    public Object getResponse() {
        return this.successful;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.timeout);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.timeout = in.readLong();
    }

    @Override
    public long getWaitTimeoutMillis() {
        return this.timeout;
    }

    @Override
    public boolean shouldBackup() {
        return this.successful;
    }

    @Override
    public void onWaitExpire() {
        this.getResponseHandler().sendResponse(false);
    }

    @Override
    public String toString() {
        return "TryRemoveOperation{" + this.name + "}";
    }
}

