/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.client;

import com.hazelcast.client.AllPartitionsClientRequest;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.MapEntrySet;
import com.hazelcast.map.MapPortableHook;
import com.hazelcast.map.MapService;
import com.hazelcast.map.operation.PartitionWideEntryWithPredicateOperationFactory;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.query.Predicate;
import com.hazelcast.spi.OperationFactory;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

public class MapExecuteWithPredicateRequest
extends AllPartitionsClientRequest
implements Portable {
    private String name;
    private EntryProcessor processor;
    private Predicate predicate;

    public MapExecuteWithPredicateRequest() {
    }

    public MapExecuteWithPredicateRequest(String name, EntryProcessor processor, Predicate predicate) {
        this.name = name;
        this.processor = processor;
        this.predicate = predicate;
    }

    @Override
    protected OperationFactory createOperationFactory() {
        return new PartitionWideEntryWithPredicateOperationFactory(this.name, this.processor, this.predicate);
    }

    @Override
    protected Object reduce(Map<Integer, Object> map) {
        MapEntrySet result = new MapEntrySet();
        MapService mapService = (MapService)this.getService();
        for (Object o : map.values()) {
            if (o == null) continue;
            MapEntrySet entrySet = (MapEntrySet)mapService.toObject(o);
            Set<Map.Entry<Data, Data>> entries = entrySet.getEntrySet();
            for (Map.Entry<Data, Data> entry : entries) {
                result.add(entry);
            }
        }
        return result;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public int getFactoryId() {
        return MapPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 43;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        ObjectDataOutput out = writer.getRawDataOutput();
        out.writeObject(this.processor);
        out.writeObject(this.predicate);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        ObjectDataInput in = reader.getRawDataInput();
        this.processor = (EntryProcessor)in.readObject();
        this.predicate = (Predicate)in.readObject();
    }
}

