/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance;

import com.hazelcast.instance.Node;
import com.hazelcast.instance.NodeInitializer;
import com.hazelcast.logging.ILogger;
import com.hazelcast.security.SecurityContext;
import com.hazelcast.storage.DataRef;
import com.hazelcast.storage.Storage;

public class DefaultNodeInitializer
implements NodeInitializer {
    protected ILogger logger;
    protected ILogger systemLogger;
    protected Node node;
    protected String version;
    protected String build;

    @Override
    public void beforeInitialize(Node node) {
        this.node = node;
        this.systemLogger = node.getLogger("com.hazelcast.system");
        this.logger = node.getLogger("com.hazelcast.initializer");
        this.parseSystemProps();
    }

    @Override
    public void printNodeInfo(Node node) {
        this.systemLogger.info("Hazelcast Community Edition " + this.version + " (" + this.build + ") starting at " + node.getThisAddress());
        this.systemLogger.info("Copyright (C) 2008-2013 Hazelcast.com");
    }

    @Override
    public void afterInitialize(Node node) {
    }

    protected void parseSystemProps() {
        this.version = this.node.getBuildInfo().getVersion();
        this.build = this.node.getBuildInfo().getBuild();
    }

    @Override
    public SecurityContext getSecurityContext() {
        this.logger.warning("Security features are only available on Hazelcast Enterprise Edition!");
        return null;
    }

    @Override
    public Storage<DataRef> getOffHeapStorage() {
        throw new UnsupportedOperationException("Offheap feature is only available on Hazelcast Enterprise Edition!");
    }

    @Override
    public void destroy() {
        this.logger.info("Destroying node initializer.");
    }
}

