/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.client;

import com.hazelcast.client.BaseClientRemoveListenerRequest;
import com.hazelcast.client.ClientEngine;
import com.hazelcast.collection.CollectionPortableHook;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.EventService;
import java.io.IOException;

public class CollectionRemoveListenerRequest
extends BaseClientRemoveListenerRequest {
    private String serviceName;

    public CollectionRemoveListenerRequest() {
    }

    public CollectionRemoveListenerRequest(String name, String registrationId, String serviceName) {
        super(name, registrationId);
        this.serviceName = serviceName;
    }

    public Object call() throws Exception {
        ClientEngine clientEngine = this.getClientEngine();
        EventService eventService = clientEngine.getEventService();
        return eventService.deregisterListener(this.serviceName, this.name, this.registrationId);
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public int getFactoryId() {
        return CollectionPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 23;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        writer.writeUTF("s", this.serviceName);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        this.serviceName = reader.readUTF("s");
    }
}

