/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi;

import com.hazelcast.client.ClientCreateRequest;
import com.hazelcast.client.DistributedObjectListenerRequest;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.RemoveDistributedObjectListenerRequest;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ProxyFactoryConfig;
import com.hazelcast.client.proxy.ClientAtomicLongProxy;
import com.hazelcast.client.proxy.ClientAtomicReferenceProxy;
import com.hazelcast.client.proxy.ClientCountDownLatchProxy;
import com.hazelcast.client.proxy.ClientExecutorServiceProxy;
import com.hazelcast.client.proxy.ClientIdGeneratorProxy;
import com.hazelcast.client.proxy.ClientListProxy;
import com.hazelcast.client.proxy.ClientLockProxy;
import com.hazelcast.client.proxy.ClientMapProxy;
import com.hazelcast.client.proxy.ClientMapReduceProxy;
import com.hazelcast.client.proxy.ClientMultiMapProxy;
import com.hazelcast.client.proxy.ClientQueueProxy;
import com.hazelcast.client.proxy.ClientSemaphoreProxy;
import com.hazelcast.client.proxy.ClientSetProxy;
import com.hazelcast.client.proxy.ClientTopicProxy;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.ClientProxyFactory;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.util.ListenerUtil;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.DistributedObjectEvent;
import com.hazelcast.core.DistributedObjectListener;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.spi.DefaultObjectNamespace;
import com.hazelcast.spi.ObjectNamespace;
import com.hazelcast.spi.impl.PortableDistributedObjectEvent;
import com.hazelcast.util.ExceptionUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class ProxyManager {
    private static final ILogger logger = Logger.getLogger(ProxyManager.class);
    private final HazelcastClient client;
    private final ConcurrentMap<String, ClientProxyFactory> proxyFactories = new ConcurrentHashMap<String, ClientProxyFactory>();
    private final ConcurrentMap<ObjectNamespace, ClientProxy> proxies = new ConcurrentHashMap<ObjectNamespace, ClientProxy>();

    public ProxyManager(HazelcastClient client) {
        this.client = client;
        List<ListenerConfig> listenerConfigs = client.getClientConfig().getListenerConfigs();
        if (listenerConfigs != null && !listenerConfigs.isEmpty()) {
            for (ListenerConfig listenerConfig : listenerConfigs) {
                if (!(listenerConfig.getImplementation() instanceof DistributedObjectListener)) continue;
                this.addDistributedObjectListener((DistributedObjectListener)listenerConfig.getImplementation());
            }
        }
    }

    public void init(ClientConfig config) {
        this.register("hz:impl:mapService", new ClientProxyFactory(){

            @Override
            public ClientProxy create(String id) {
                return new ClientMapProxy("hz:impl:mapService", String.valueOf(id));
            }
        });
        this.register("hz:impl:queueService", new ClientProxyFactory(){

            @Override
            public ClientProxy create(String id) {
                return new ClientQueueProxy("hz:impl:queueService", String.valueOf(id));
            }
        });
        this.register("hz:impl:multiMapService", new ClientProxyFactory(){

            @Override
            public ClientProxy create(String id) {
                return new ClientMultiMapProxy("hz:impl:multiMapService", String.valueOf(id));
            }
        });
        this.register("hz:impl:listService", new ClientProxyFactory(){

            @Override
            public ClientProxy create(String id) {
                return new ClientListProxy("hz:impl:listService", String.valueOf(id));
            }
        });
        this.register("hz:impl:setService", new ClientProxyFactory(){

            @Override
            public ClientProxy create(String id) {
                return new ClientSetProxy("hz:impl:setService", String.valueOf(id));
            }
        });
        this.register("hz:impl:semaphoreService", new ClientProxyFactory(){

            @Override
            public ClientProxy create(String id) {
                return new ClientSemaphoreProxy("hz:impl:semaphoreService", String.valueOf(id));
            }
        });
        this.register("hz:impl:topicService", new ClientProxyFactory(){

            @Override
            public ClientProxy create(String id) {
                return new ClientTopicProxy("hz:impl:topicService", String.valueOf(id));
            }
        });
        this.register("hz:impl:atomicLongService", new ClientProxyFactory(){

            @Override
            public ClientProxy create(String id) {
                return new ClientAtomicLongProxy("hz:impl:atomicLongService", String.valueOf(id));
            }
        });
        this.register("hz:impl:atomicReferenceService", new ClientProxyFactory(){

            @Override
            public ClientProxy create(String id) {
                return new ClientAtomicReferenceProxy("hz:impl:atomicReferenceService", String.valueOf(id));
            }
        });
        this.register("hz:impl:executorService", new ClientProxyFactory(){

            @Override
            public ClientProxy create(String id) {
                return new ClientExecutorServiceProxy("hz:impl:executorService", String.valueOf(id));
            }
        });
        this.register("hz:impl:lockService", new ClientProxyFactory(){

            @Override
            public ClientProxy create(String id) {
                return new ClientLockProxy("hz:impl:lockService", id);
            }
        });
        this.register("hz:impl:idGeneratorService", new ClientProxyFactory(){

            @Override
            public ClientProxy create(String id) {
                String name = String.valueOf(id);
                IAtomicLong atomicLong = ProxyManager.this.client.getAtomicLong("hz:atomic:idGenerator:" + name);
                return new ClientIdGeneratorProxy("hz:impl:idGeneratorService", name, atomicLong);
            }
        });
        this.register("hz:impl:countDownLatchService", new ClientProxyFactory(){

            @Override
            public ClientProxy create(String id) {
                return new ClientCountDownLatchProxy("hz:impl:countDownLatchService", String.valueOf(id));
            }
        });
        this.register("hz:impl:mapReduceService", new ClientProxyFactory(){

            @Override
            public ClientProxy create(String id) {
                return new ClientMapReduceProxy("hz:impl:mapReduceService", id);
            }
        });
        for (ProxyFactoryConfig proxyFactoryConfig : config.getProxyFactoryConfigs()) {
            try {
                ClientProxyFactory clientProxyFactory = (ClientProxyFactory)ClassLoaderUtil.newInstance(config.getClassLoader(), proxyFactoryConfig.getClassName());
                this.register(proxyFactoryConfig.getService(), clientProxyFactory);
            }
            catch (Exception e) {
                logger.severe(e);
            }
        }
    }

    public void register(String serviceName, ClientProxyFactory factory) {
        if (this.proxyFactories.putIfAbsent(serviceName, factory) != null) {
            throw new IllegalArgumentException("Factory for service: " + serviceName + " is already registered!");
        }
    }

    public ClientProxy getProxy(String service, String id) {
        DefaultObjectNamespace ns = new DefaultObjectNamespace(service, id);
        ClientProxy proxy = (ClientProxy)this.proxies.get(ns);
        if (proxy != null) {
            return proxy;
        }
        ClientProxyFactory factory = (ClientProxyFactory)this.proxyFactories.get(service);
        if (factory == null) {
            throw new IllegalArgumentException("No factory registered for service: " + service);
        }
        ClientProxy clientProxy = factory.create(id);
        this.initialize(clientProxy);
        ClientProxy current = this.proxies.putIfAbsent(ns, clientProxy);
        if (current != null) {
            return current;
        }
        return clientProxy;
    }

    public ClientProxy removeProxy(String service, String id) {
        DefaultObjectNamespace ns = new DefaultObjectNamespace(service, id);
        return (ClientProxy)this.proxies.remove(ns);
    }

    private void initialize(ClientProxy clientProxy) {
        ClientCreateRequest request = new ClientCreateRequest(clientProxy.getName(), clientProxy.getServiceName());
        try {
            this.client.getInvocationService().invokeOnRandomTarget(request).get();
        }
        catch (Exception e) {
            ExceptionUtil.rethrow(e);
        }
        clientProxy.setContext(new ClientContext(this.client.getSerializationService(), this.client.getClientClusterService(), this.client.getClientPartitionService(), this.client.getInvocationService(), this.client.getClientExecutionService(), this, this.client.getClientConfig()));
    }

    public Collection<? extends DistributedObject> getDistributedObjects() {
        return Collections.unmodifiableCollection(this.proxies.values());
    }

    public void destroy() {
        this.proxies.clear();
    }

    public String addDistributedObjectListener(final DistributedObjectListener listener) {
        DistributedObjectListenerRequest request = new DistributedObjectListenerRequest();
        ClientContext context = new ClientContext(this.client.getSerializationService(), this.client.getClientClusterService(), this.client.getClientPartitionService(), this.client.getInvocationService(), this.client.getClientExecutionService(), this, this.client.getClientConfig());
        EventHandler<PortableDistributedObjectEvent> eventHandler = new EventHandler<PortableDistributedObjectEvent>(){

            @Override
            public void handle(PortableDistributedObjectEvent e) {
                DefaultObjectNamespace ns = new DefaultObjectNamespace(e.getServiceName(), e.getName());
                ClientProxy proxy = (ClientProxy)ProxyManager.this.proxies.get(ns);
                if (proxy == null) {
                    proxy = ProxyManager.this.getProxy(e.getServiceName(), e.getName());
                }
                DistributedObjectEvent event = new DistributedObjectEvent(e.getEventType(), e.getServiceName(), proxy);
                if (DistributedObjectEvent.EventType.CREATED.equals((Object)e.getEventType())) {
                    listener.distributedObjectCreated(event);
                } else if (DistributedObjectEvent.EventType.DESTROYED.equals((Object)e.getEventType())) {
                    listener.distributedObjectDestroyed(event);
                }
            }
        };
        return ListenerUtil.listen(context, request, null, eventHandler);
    }

    public boolean removeDistributedObjectListener(String id) {
        RemoveDistributedObjectListenerRequest request = new RemoveDistributedObjectListenerRequest(id);
        ClientContext context = new ClientContext(this.client.getSerializationService(), this.client.getClientClusterService(), this.client.getClientPartitionService(), this.client.getInvocationService(), this.client.getClientExecutionService(), this, this.client.getClientConfig());
        return ListenerUtil.stopListening(context, request, id);
    }
}

