/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.config.ClientAliasedDiscoveryConfigUtils;
import com.hazelcast.client.config.ClientCloudConfig;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientConfigSections;
import com.hazelcast.client.config.ClientConnectionStrategyConfig;
import com.hazelcast.client.config.ClientFlakeIdGeneratorConfig;
import com.hazelcast.client.config.ClientIcmpPingConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.config.ClientReliableTopicConfig;
import com.hazelcast.client.config.ClientSecurityConfig;
import com.hazelcast.client.config.ClientUserCodeDeploymentConfig;
import com.hazelcast.client.config.ConnectionRetryConfig;
import com.hazelcast.client.config.ProxyFactoryConfig;
import com.hazelcast.client.config.QueryCacheConfigBuilderHelper;
import com.hazelcast.client.config.QueryCacheXmlConfigBuilderHelper;
import com.hazelcast.client.config.SocketOptions;
import com.hazelcast.client.util.RandomLB;
import com.hazelcast.client.util.RoundRobinLB;
import com.hazelcast.config.AbstractDomConfigProcessor;
import com.hazelcast.config.AliasedDiscoveryConfig;
import com.hazelcast.config.AliasedDiscoveryConfigUtils;
import com.hazelcast.config.CredentialsFactoryConfig;
import com.hazelcast.config.DiscoveryConfig;
import com.hazelcast.config.DiscoveryStrategyConfig;
import com.hazelcast.config.DomConfigHelper;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.NearCachePreloaderConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.topic.TopicOverloadPolicy;
import com.hazelcast.util.StringUtil;
import java.util.HashMap;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class ClientDomConfigProcessor
extends AbstractDomConfigProcessor {
    private static final ILogger LOGGER = Logger.getLogger(ClientDomConfigProcessor.class);
    protected final ClientConfig clientConfig;
    protected final QueryCacheConfigBuilderHelper queryCacheConfigBuilderHelper;

    ClientDomConfigProcessor(boolean domLevel3, ClientConfig clientConfig) {
        this(domLevel3, clientConfig, new QueryCacheXmlConfigBuilderHelper(domLevel3));
    }

    ClientDomConfigProcessor(boolean domLevel3, ClientConfig clientConfig, QueryCacheConfigBuilderHelper queryCacheConfigBuilderHelper) {
        super(domLevel3);
        this.clientConfig = clientConfig;
        this.queryCacheConfigBuilderHelper = queryCacheConfigBuilderHelper;
    }

    @Override
    public void buildConfig(Node rootNode) throws Exception {
        for (Node node : DomConfigHelper.childElements(rootNode)) {
            String nodeName = DomConfigHelper.cleanNodeName(node);
            if (this.occurrenceSet.contains(nodeName)) {
                throw new InvalidConfigurationException("Duplicate '" + nodeName + "' definition found in the configuration");
            }
            this.handleNode(node, nodeName);
            if (ClientConfigSections.canOccurMultipleTimes(nodeName)) continue;
            this.occurrenceSet.add(nodeName);
        }
    }

    private void handleNode(Node node, String nodeName) {
        if (ClientConfigSections.SECURITY.isEqual(nodeName)) {
            this.handleSecurity(node);
        } else if (ClientConfigSections.PROXY_FACTORIES.isEqual(nodeName)) {
            this.handleProxyFactories(node);
        } else if (ClientConfigSections.PROPERTIES.isEqual(nodeName)) {
            this.fillProperties(node, this.clientConfig.getProperties());
        } else if (ClientConfigSections.SERIALIZATION.isEqual(nodeName)) {
            this.handleSerialization(node);
        } else if (ClientConfigSections.NATIVE_MEMORY.isEqual(nodeName)) {
            this.fillNativeMemoryConfig(node, this.clientConfig.getNativeMemoryConfig());
        } else if (ClientConfigSections.GROUP.isEqual(nodeName)) {
            this.handleGroup(node);
        } else if (ClientConfigSections.LISTENERS.isEqual(nodeName)) {
            this.handleListeners(node);
        } else if (ClientConfigSections.NETWORK.isEqual(nodeName)) {
            this.handleNetwork(node);
        } else if (ClientConfigSections.LOAD_BALANCER.isEqual(nodeName)) {
            this.handleLoadBalancer(node);
        } else if (ClientConfigSections.NEAR_CACHE.isEqual(nodeName)) {
            this.handleNearCache(node);
        } else if (ClientConfigSections.QUERY_CACHES.isEqual(nodeName)) {
            this.queryCacheConfigBuilderHelper.handleQueryCache(this.clientConfig, node);
        } else if (ClientConfigSections.EXECUTOR_POOL_SIZE.isEqual(nodeName)) {
            this.handleExecutorPoolSize(node);
        } else if (ClientConfigSections.LICENSE_KEY.isEqual(nodeName)) {
            this.clientConfig.setLicenseKey(this.getTextContent(node));
        } else if (ClientConfigSections.INSTANCE_NAME.isEqual(nodeName)) {
            this.clientConfig.setInstanceName(this.getTextContent(node));
        } else if (ClientConfigSections.CONNECTION_STRATEGY.isEqual(nodeName)) {
            this.handleConnectionStrategy(node);
        } else if (ClientConfigSections.USER_CODE_DEPLOYMENT.isEqual(nodeName)) {
            this.handleUserCodeDeployment(node);
        } else if (ClientConfigSections.FLAKE_ID_GENERATOR.isEqual(nodeName)) {
            this.handleFlakeIdGenerator(node);
        } else if (ClientConfigSections.RELIABLE_TOPIC.isEqual(nodeName)) {
            this.handleReliableTopic(node);
        } else if (ClientConfigSections.LABELS.isEqual(nodeName)) {
            this.handleLabels(node);
        }
    }

    private void handleLabels(Node node) {
        for (Node n : DomConfigHelper.childElements(node)) {
            String value = this.getTextContent(n);
            this.clientConfig.addLabel(value);
        }
    }

    private void handleConnectionStrategy(Node node) {
        ClientConnectionStrategyConfig strategyConfig = new ClientConnectionStrategyConfig();
        String attrValue = this.getAttribute(node, "async-start");
        strategyConfig.setAsyncStart(attrValue != null && DomConfigHelper.getBooleanValue(attrValue.trim()));
        attrValue = this.getAttribute(node, "reconnect-mode");
        if (attrValue != null) {
            strategyConfig.setReconnectMode(ClientConnectionStrategyConfig.ReconnectMode.valueOf(StringUtil.upperCaseInternal(attrValue.trim())));
        }
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (!"connection-retry".equals(nodeName)) continue;
            this.handleConnectionRetry(child, strategyConfig);
        }
        this.clientConfig.setConnectionStrategyConfig(strategyConfig);
    }

    private void handleConnectionRetry(Node node, ClientConnectionStrategyConfig strategyConfig) {
        boolean enabled;
        Node enabledNode = node.getAttributes().getNamedItem("enabled");
        boolean bl = enabled = enabledNode != null && DomConfigHelper.getBooleanValue(this.getTextContent(enabledNode).trim());
        if (!enabled) {
            LOGGER.warning("Exponential Connection Strategy is not enabled.");
        }
        ConnectionRetryConfig connectionRetryConfig = new ConnectionRetryConfig();
        connectionRetryConfig.setEnabled(enabled);
        String initialBackoffMillis = "initial-backoff-millis";
        String maxBackoffMillis = "max-backoff-millis";
        String multiplier = "multiplier";
        String jitter = "jitter";
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            String value = this.getTextContent(child).trim();
            if (initialBackoffMillis.equals(nodeName)) {
                connectionRetryConfig.setInitialBackoffMillis(DomConfigHelper.getIntegerValue(initialBackoffMillis, value));
                continue;
            }
            if (maxBackoffMillis.equals(nodeName)) {
                connectionRetryConfig.setMaxBackoffMillis(DomConfigHelper.getIntegerValue(maxBackoffMillis, value));
                continue;
            }
            if (multiplier.equals(nodeName)) {
                connectionRetryConfig.setMultiplier(DomConfigHelper.getIntegerValue(multiplier, value));
                continue;
            }
            if ("fail-on-max-backoff".equals(nodeName)) {
                connectionRetryConfig.setFailOnMaxBackoff(DomConfigHelper.getBooleanValue(value));
                continue;
            }
            if (!jitter.equals(nodeName)) continue;
            connectionRetryConfig.setJitter(DomConfigHelper.getDoubleValue(jitter, value));
        }
        strategyConfig.setConnectionRetryConfig(connectionRetryConfig);
    }

    private void handleUserCodeDeployment(Node node) {
        NamedNodeMap atts = node.getAttributes();
        Node enabledNode = atts.getNamedItem("enabled");
        boolean enabled = enabledNode != null && DomConfigHelper.getBooleanValue(this.getTextContent(enabledNode).trim());
        ClientUserCodeDeploymentConfig userCodeDeploymentConfig = new ClientUserCodeDeploymentConfig();
        userCodeDeploymentConfig.setEnabled(enabled);
        for (Node child : DomConfigHelper.childElements(node)) {
            this.handleUserCodeDeploymentNode(userCodeDeploymentConfig, child);
        }
        this.clientConfig.setUserCodeDeploymentConfig(userCodeDeploymentConfig);
    }

    protected void handleUserCodeDeploymentNode(ClientUserCodeDeploymentConfig userCodeDeploymentConfig, Node child) {
        String childNodeName = DomConfigHelper.cleanNodeName(child);
        if ("classnames".equals(childNodeName)) {
            for (Node classNameNode : DomConfigHelper.childElements(child)) {
                userCodeDeploymentConfig.addClass(this.getTextContent(classNameNode));
            }
        } else if ("jarpaths".equals(childNodeName)) {
            for (Node jarPathNode : DomConfigHelper.childElements(child)) {
                userCodeDeploymentConfig.addJar(this.getTextContent(jarPathNode));
            }
        } else {
            throw new InvalidConfigurationException("User code deployement can either be className or jarPath. " + childNodeName + " is invalid");
        }
    }

    private void handleExecutorPoolSize(Node node) {
        int poolSize = Integer.parseInt(this.getTextContent(node));
        this.clientConfig.setExecutorPoolSize(poolSize);
    }

    protected void handleNearCache(Node node) {
        this.handleNearCacheNode(node);
    }

    protected void handleNearCacheNode(Node node) {
        String name = this.getName(node);
        NearCacheConfig nearCacheConfig = new NearCacheConfig(name);
        Boolean serializeKeys = null;
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            String value = this.getTextContent(child).trim();
            if ("max-size".equals(nodeName)) {
                nearCacheConfig.setMaxSize(Integer.parseInt(value));
                LOGGER.warning("The element <max-size/> for <near-cache/> is deprecated, please use <eviction/> instead!");
                continue;
            }
            if ("time-to-live-seconds".equals(nodeName)) {
                nearCacheConfig.setTimeToLiveSeconds(Integer.parseInt(value));
                continue;
            }
            if ("max-idle-seconds".equals(nodeName)) {
                nearCacheConfig.setMaxIdleSeconds(Integer.parseInt(value));
                continue;
            }
            if ("eviction-policy".equals(nodeName)) {
                nearCacheConfig.setEvictionPolicy(value);
                LOGGER.warning("The element <eviction-policy/> for <near-cache/> is deprecated, please use <eviction/> instead!");
                continue;
            }
            if ("in-memory-format".equals(nodeName)) {
                nearCacheConfig.setInMemoryFormat(InMemoryFormat.valueOf(StringUtil.upperCaseInternal(value)));
                continue;
            }
            if ("serialize-keys".equals(nodeName)) {
                serializeKeys = Boolean.parseBoolean(value);
                nearCacheConfig.setSerializeKeys(serializeKeys);
                continue;
            }
            if ("invalidate-on-change".equals(nodeName)) {
                nearCacheConfig.setInvalidateOnChange(Boolean.parseBoolean(value));
                continue;
            }
            if ("cache-local-entries".equals(nodeName)) {
                nearCacheConfig.setCacheLocalEntries(Boolean.parseBoolean(value));
                continue;
            }
            if ("local-update-policy".equals(nodeName)) {
                nearCacheConfig.setLocalUpdatePolicy(NearCacheConfig.LocalUpdatePolicy.valueOf(value));
                continue;
            }
            if ("eviction".equals(nodeName)) {
                nearCacheConfig.setEvictionConfig(this.getEvictionConfig(child));
                continue;
            }
            if (!"preloader".equals(nodeName)) continue;
            nearCacheConfig.setPreloaderConfig(this.getNearCachePreloaderConfig(child));
        }
        if (serializeKeys != null && !serializeKeys.booleanValue() && nearCacheConfig.getInMemoryFormat() == InMemoryFormat.NATIVE) {
            LOGGER.warning("The Near Cache doesn't support keys by-reference with NATIVE in-memory-format. This setting will have no effect!");
        }
        this.clientConfig.addNearCacheConfig(nearCacheConfig);
    }

    protected String getName(Node node) {
        return this.getAttribute(node, "name");
    }

    protected void handleFlakeIdGenerator(Node node) {
        this.handleFlakeIdGeneratorNode(node);
    }

    protected void handleFlakeIdGeneratorNode(Node node) {
        String name = this.getName(node);
        ClientFlakeIdGeneratorConfig config = new ClientFlakeIdGeneratorConfig(name);
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            String value = this.getTextContent(child).trim();
            if ("prefetch-count".equals(nodeName)) {
                config.setPrefetchCount(Integer.parseInt(value));
                continue;
            }
            if (!"prefetch-validity-millis".equalsIgnoreCase(nodeName)) continue;
            config.setPrefetchValidityMillis(Long.parseLong(value));
        }
        this.clientConfig.addFlakeIdGeneratorConfig(config);
    }

    protected void handleReliableTopic(Node node) {
        this.handleReliableTopicNode(node);
    }

    protected void handleReliableTopicNode(Node node) {
        String name = this.getName(node);
        ClientReliableTopicConfig config = new ClientReliableTopicConfig(name);
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            String value = this.getTextContent(child).trim();
            if ("topic-overload-policy".equals(nodeName)) {
                config.setTopicOverloadPolicy(TopicOverloadPolicy.valueOf(value));
                continue;
            }
            if (!"read-batch-size".equalsIgnoreCase(nodeName)) continue;
            config.setReadBatchSize(Integer.parseInt(value));
        }
        this.clientConfig.addReliableTopicConfig(config);
    }

    private EvictionConfig getEvictionConfig(Node node) {
        EvictionConfig evictionConfig = new EvictionConfig();
        Node size = node.getAttributes().getNamedItem("size");
        Node maxSizePolicy = node.getAttributes().getNamedItem("max-size-policy");
        Node evictionPolicy = node.getAttributes().getNamedItem("eviction-policy");
        Node comparatorClassName = node.getAttributes().getNamedItem("comparator-class-name");
        if (size != null) {
            evictionConfig.setSize(Integer.parseInt(this.getTextContent(size)));
        }
        if (maxSizePolicy != null) {
            evictionConfig.setMaximumSizePolicy(EvictionConfig.MaxSizePolicy.valueOf(StringUtil.upperCaseInternal(this.getTextContent(maxSizePolicy))));
        }
        if (evictionPolicy != null) {
            evictionConfig.setEvictionPolicy(EvictionPolicy.valueOf(StringUtil.upperCaseInternal(this.getTextContent(evictionPolicy))));
        }
        if (comparatorClassName != null) {
            evictionConfig.setComparatorClassName(this.getTextContent(comparatorClassName));
        }
        return evictionConfig;
    }

    private NearCachePreloaderConfig getNearCachePreloaderConfig(Node node) {
        NearCachePreloaderConfig preloaderConfig = new NearCachePreloaderConfig();
        String enabled = this.getAttribute(node, "enabled");
        String directory = this.getAttribute(node, "directory");
        String storeInitialDelaySeconds = this.getAttribute(node, "store-initial-delay-seconds");
        String storeIntervalSeconds = this.getAttribute(node, "store-interval-seconds");
        if (enabled != null) {
            preloaderConfig.setEnabled(DomConfigHelper.getBooleanValue(enabled));
        }
        if (directory != null) {
            preloaderConfig.setDirectory(directory);
        }
        if (storeInitialDelaySeconds != null) {
            preloaderConfig.setStoreInitialDelaySeconds(DomConfigHelper.getIntegerValue("storage-initial-delay-seconds", storeInitialDelaySeconds));
        }
        if (storeIntervalSeconds != null) {
            preloaderConfig.setStoreIntervalSeconds(DomConfigHelper.getIntegerValue("storage-interval-seconds", storeIntervalSeconds));
        }
        return preloaderConfig;
    }

    private void handleLoadBalancer(Node node) {
        String type = this.getAttribute(node, "type");
        if ("random".equals(type)) {
            this.clientConfig.setLoadBalancer(new RandomLB());
        } else if ("round-robin".equals(type)) {
            this.clientConfig.setLoadBalancer(new RoundRobinLB());
        }
    }

    private void handleNetwork(Node node) {
        ClientNetworkConfig clientNetworkConfig = new ClientNetworkConfig();
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if ("cluster-members".equals(nodeName)) {
                this.handleClusterMembers(child, clientNetworkConfig);
                continue;
            }
            if ("smart-routing".equals(nodeName)) {
                clientNetworkConfig.setSmartRouting(Boolean.parseBoolean(this.getTextContent(child)));
                continue;
            }
            if ("redo-operation".equals(nodeName)) {
                clientNetworkConfig.setRedoOperation(Boolean.parseBoolean(this.getTextContent(child)));
                continue;
            }
            if ("connection-timeout".equals(nodeName)) {
                clientNetworkConfig.setConnectionTimeout(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if ("connection-attempt-period".equals(nodeName)) {
                clientNetworkConfig.setConnectionAttemptPeriod(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if ("connection-attempt-limit".equals(nodeName)) {
                clientNetworkConfig.setConnectionAttemptLimit(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if ("socket-options".equals(nodeName)) {
                this.handleSocketOptions(child, clientNetworkConfig);
                continue;
            }
            if ("socket-interceptor".equals(nodeName)) {
                this.handleSocketInterceptorConfig(child, clientNetworkConfig);
                continue;
            }
            if ("ssl".equals(nodeName)) {
                this.handleSSLConfig(child, clientNetworkConfig);
                continue;
            }
            if (AliasedDiscoveryConfigUtils.supports(nodeName)) {
                this.handleAliasedDiscoveryStrategy(child, clientNetworkConfig, nodeName);
                continue;
            }
            if ("discovery-strategies".equals(nodeName)) {
                this.handleDiscoveryStrategies(child, clientNetworkConfig);
                continue;
            }
            if ("outbound-ports".equals(nodeName)) {
                this.handleOutboundPorts(child, clientNetworkConfig);
                continue;
            }
            if ("icmp-ping".equals(nodeName)) {
                this.handleIcmpPing(child, clientNetworkConfig);
                continue;
            }
            if (!"hazelcast-cloud".equals(nodeName)) continue;
            this.handleHazelcastCloud(child, clientNetworkConfig);
        }
        this.clientConfig.setNetworkConfig(clientNetworkConfig);
    }

    private void handleHazelcastCloud(Node node, ClientNetworkConfig clientNetworkConfig) {
        ClientCloudConfig cloudConfig = clientNetworkConfig.getCloudConfig();
        NamedNodeMap atts = node.getAttributes();
        Node enabledNode = atts.getNamedItem("enabled");
        boolean enabled = enabledNode != null && DomConfigHelper.getBooleanValue(this.getTextContent(enabledNode).trim());
        cloudConfig.setEnabled(enabled);
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (!"discovery-token".equals(nodeName)) continue;
            cloudConfig.setDiscoveryToken(this.getTextContent(child));
        }
    }

    private void handleIcmpPing(Node node, ClientNetworkConfig clientNetworkConfig) {
        ClientIcmpPingConfig icmpPingConfig = clientNetworkConfig.getClientIcmpPingConfig();
        NamedNodeMap atts = node.getAttributes();
        Node enabledNode = atts.getNamedItem("enabled");
        boolean enabled = enabledNode != null && DomConfigHelper.getBooleanValue(this.getTextContent(enabledNode).trim());
        icmpPingConfig.setEnabled(enabled);
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if ("timeout-milliseconds".equals(nodeName)) {
                icmpPingConfig.setTimeoutMilliseconds(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if ("interval-milliseconds".equals(nodeName)) {
                icmpPingConfig.setIntervalMilliseconds(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if ("ttl".equals(nodeName)) {
                icmpPingConfig.setTtl(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if ("max-attempts".equals(nodeName)) {
                icmpPingConfig.setMaxAttempts(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if (!"echo-fail-fast-on-startup".equals(nodeName)) continue;
            icmpPingConfig.setEchoFailFastOnStartup(Boolean.parseBoolean(this.getTextContent(child)));
        }
        clientNetworkConfig.setClientIcmpPingConfig(icmpPingConfig);
    }

    protected void handleDiscoveryStrategies(Node node, ClientNetworkConfig clientNetworkConfig) {
        DiscoveryConfig discoveryConfig = clientNetworkConfig.getDiscoveryConfig();
        for (Node child : DomConfigHelper.childElements(node)) {
            String name = DomConfigHelper.cleanNodeName(child);
            if ("discovery-strategy".equals(name)) {
                this.handleDiscoveryStrategy(child, discoveryConfig);
                continue;
            }
            if (!"node-filter".equals(name)) continue;
            this.handleDiscoveryNodeFilter(child, discoveryConfig);
        }
    }

    protected void handleDiscoveryNodeFilter(Node node, DiscoveryConfig discoveryConfig) {
        NamedNodeMap atts = node.getAttributes();
        Node att = atts.getNamedItem("class");
        if (att != null) {
            discoveryConfig.setNodeFilterClass(this.getTextContent(att).trim());
        }
    }

    protected void handleDiscoveryStrategy(Node node, DiscoveryConfig discoveryConfig) {
        NamedNodeMap atts = node.getAttributes();
        boolean enabled = false;
        String clazz = null;
        for (int a = 0; a < atts.getLength(); ++a) {
            Node att = atts.item(a);
            String value = this.getTextContent(att).trim();
            if ("enabled".equalsIgnoreCase(att.getNodeName())) {
                enabled = DomConfigHelper.getBooleanValue(value);
                continue;
            }
            if (!"class".equals(att.getNodeName())) continue;
            clazz = value;
        }
        if (!enabled || clazz == null) {
            return;
        }
        HashMap<String, Comparable> properties = new HashMap<String, Comparable>();
        for (Node child : DomConfigHelper.childElements(node)) {
            String name = DomConfigHelper.cleanNodeName(child);
            if (!"properties".equals(name)) continue;
            this.fillProperties(child, properties);
        }
        discoveryConfig.addDiscoveryStrategyConfig(new DiscoveryStrategyConfig(clazz, properties));
    }

    private void handleAliasedDiscoveryStrategy(Node node, ClientNetworkConfig clientNetworkConfig, String tag) {
        AliasedDiscoveryConfig config = ClientAliasedDiscoveryConfigUtils.getConfigByTag(clientNetworkConfig, tag);
        NamedNodeMap atts = node.getAttributes();
        for (int i = 0; i < atts.getLength(); ++i) {
            Node att = atts.item(i);
            String value = this.getTextContent(att).trim();
            if ("enabled".equalsIgnoreCase(att.getNodeName())) {
                config.setEnabled(DomConfigHelper.getBooleanValue(value));
                continue;
            }
            if (!att.getNodeName().equals("connection-timeout-seconds")) continue;
            config.setProperty("connection-timeout-seconds", value);
        }
        for (Node n : DomConfigHelper.childElements(node)) {
            String key = DomConfigHelper.cleanNodeName(n);
            String value = this.getTextContent(n).trim();
            config.setProperty(key, value);
        }
    }

    private void handleSSLConfig(Node node, ClientNetworkConfig clientNetworkConfig) {
        SSLConfig sslConfig = new SSLConfig();
        NamedNodeMap atts = node.getAttributes();
        Node enabledNode = atts.getNamedItem("enabled");
        boolean enabled = enabledNode != null && DomConfigHelper.getBooleanValue(this.getTextContent(enabledNode).trim());
        sslConfig.setEnabled(enabled);
        for (Node n : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(n);
            if ("factory-class-name".equals(nodeName)) {
                sslConfig.setFactoryClassName(this.getTextContent(n).trim());
                continue;
            }
            if (!"properties".equals(nodeName)) continue;
            this.fillProperties(n, sslConfig.getProperties());
        }
        clientNetworkConfig.setSSLConfig(sslConfig);
    }

    private void handleSocketOptions(Node node, ClientNetworkConfig clientNetworkConfig) {
        SocketOptions socketOptions = this.clientConfig.getSocketOptions();
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if ("tcp-no-delay".equals(nodeName)) {
                socketOptions.setTcpNoDelay(Boolean.parseBoolean(this.getTextContent(child)));
                continue;
            }
            if ("keep-alive".equals(nodeName)) {
                socketOptions.setKeepAlive(Boolean.parseBoolean(this.getTextContent(child)));
                continue;
            }
            if ("reuse-address".equals(nodeName)) {
                socketOptions.setReuseAddress(Boolean.parseBoolean(this.getTextContent(child)));
                continue;
            }
            if ("linger-seconds".equals(nodeName)) {
                socketOptions.setLingerSeconds(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if (!"buffer-size".equals(nodeName)) continue;
            socketOptions.setBufferSize(Integer.parseInt(this.getTextContent(child)));
        }
        clientNetworkConfig.setSocketOptions(socketOptions);
    }

    protected void handleClusterMembers(Node node, ClientNetworkConfig clientNetworkConfig) {
        for (Node child : DomConfigHelper.childElements(node)) {
            if (!"address".equals(DomConfigHelper.cleanNodeName(child))) continue;
            clientNetworkConfig.addAddress(this.getTextContent(child));
        }
    }

    protected void handleListeners(Node node) {
        for (Node child : DomConfigHelper.childElements(node)) {
            if (!"listener".equals(DomConfigHelper.cleanNodeName(child))) continue;
            String className = this.getTextContent(child);
            this.clientConfig.addListenerConfig(new ListenerConfig(className));
        }
    }

    private void handleGroup(Node node) {
        for (Node n : DomConfigHelper.childElements(node)) {
            String value = this.getTextContent(n).trim();
            String nodeName = DomConfigHelper.cleanNodeName(n);
            if ("name".equals(nodeName)) {
                this.clientConfig.getGroupConfig().setName(value);
                continue;
            }
            if (!"password".equals(nodeName)) continue;
            this.clientConfig.getGroupConfig().setPassword(value);
        }
    }

    private void handleSerialization(Node node) {
        SerializationConfig serializationConfig = this.parseSerialization(node);
        this.clientConfig.setSerializationConfig(serializationConfig);
    }

    private void handleProxyFactories(Node node) {
        for (Node child : DomConfigHelper.childElements(node)) {
            this.handleProxyFactoryNode(child);
        }
    }

    protected void handleProxyFactoryNode(Node child) {
        String nodeName = DomConfigHelper.cleanNodeName(child);
        if ("proxy-factory".equals(nodeName)) {
            this.handleProxyFactory(child);
        }
    }

    protected void handleProxyFactory(Node node) {
        String service = this.getAttribute(node, "service");
        String className = this.getAttribute(node, "class-name");
        ProxyFactoryConfig proxyFactoryConfig = new ProxyFactoryConfig(className, service);
        this.clientConfig.addProxyFactoryConfig(proxyFactoryConfig);
    }

    private void handleSocketInterceptorConfig(Node node, ClientNetworkConfig clientNetworkConfig) {
        SocketInterceptorConfig socketInterceptorConfig = this.parseSocketInterceptorConfig(node);
        clientNetworkConfig.setSocketInterceptorConfig(socketInterceptorConfig);
    }

    private void handleSecurity(Node node) {
        ClientSecurityConfig clientSecurityConfig = new ClientSecurityConfig();
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if ("credentials".equals(nodeName)) {
                String className = this.getTextContent(child);
                clientSecurityConfig.setCredentialsClassname(className);
                continue;
            }
            if (!"credentials-factory".equals(nodeName)) continue;
            this.handleCredentialsFactory(child, clientSecurityConfig);
        }
        this.clientConfig.setSecurityConfig(clientSecurityConfig);
    }

    private void handleCredentialsFactory(Node node, ClientSecurityConfig clientSecurityConfig) {
        NamedNodeMap attrs = node.getAttributes();
        Node classNameNode = attrs.getNamedItem("class-name");
        String className = this.getTextContent(classNameNode);
        CredentialsFactoryConfig credentialsFactoryConfig = new CredentialsFactoryConfig(className);
        clientSecurityConfig.setCredentialsFactoryConfig(credentialsFactoryConfig);
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (!"properties".equals(nodeName)) continue;
            this.fillProperties(child, credentialsFactoryConfig.getProperties());
            break;
        }
    }

    protected void handleOutboundPorts(Node child, ClientNetworkConfig clientNetworkConfig) {
        for (Node n : DomConfigHelper.childElements(child)) {
            String nodeName = DomConfigHelper.cleanNodeName(n);
            if (!"ports".equals(nodeName)) continue;
            String value = this.getTextContent(n);
            clientNetworkConfig.addOutboundPortDefinition(value);
        }
    }
}

