/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.local;

import com.hazelcast.config.MapConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import com.hazelcast.hibernate.CacheEnvironment;
import com.hazelcast.hibernate.HazelcastTimestamper;
import com.hazelcast.hibernate.RegionCache;
import com.hazelcast.hibernate.local.Invalidation;
import com.hazelcast.hibernate.serialization.Expirable;
import com.hazelcast.hibernate.serialization.ExpiryMarker;
import com.hazelcast.hibernate.serialization.MarkerWrapper;
import com.hazelcast.hibernate.serialization.Value;
import com.hazelcast.util.Clock;
import com.hazelcast.util.EmptyStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.access.SoftLock;

public class LocalRegionCache
implements RegionCache {
    private static final long SEC_TO_MS = 1000L;
    private static final int MAX_SIZE = 100000;
    private static final float BASE_EVICTION_RATE = 0.2f;
    protected final HazelcastInstance hazelcastInstance;
    protected final ITopic<Object> topic;
    protected final MessageListener<Object> messageListener;
    protected final ConcurrentMap<Object, Expirable> cache;
    protected final Comparator versionComparator;
    protected final AtomicLong markerIdCounter;
    protected MapConfig config;

    public LocalRegionCache(String name, HazelcastInstance hazelcastInstance, CacheDataDescription metadata) {
        this(name, hazelcastInstance, metadata, true);
    }

    public LocalRegionCache(String name, HazelcastInstance hazelcastInstance, CacheDataDescription metadata, boolean withTopic) {
        this.hazelcastInstance = hazelcastInstance;
        try {
            this.config = hazelcastInstance != null ? hazelcastInstance.getConfig().findMapConfig(name) : null;
        }
        catch (UnsupportedOperationException ignored) {
            EmptyStatement.ignore(ignored);
        }
        this.versionComparator = metadata != null && metadata.isVersioned() ? metadata.getVersionComparator() : null;
        this.cache = new ConcurrentHashMap<Object, Expirable>();
        this.markerIdCounter = new AtomicLong();
        this.messageListener = this.createMessageListener();
        if (withTopic && hazelcastInstance != null) {
            this.topic = hazelcastInstance.getTopic(name);
            this.topic.addMessageListener(this.messageListener);
        } else {
            this.topic = null;
        }
    }

    @Override
    public Object get(Object key, long txTimestamp) {
        Expirable value = (Expirable)this.cache.get(key);
        return value == null ? null : value.getValue(txTimestamp);
    }

    @Override
    public boolean insert(Object key, Object value, Object currentVersion) {
        Value newValue = new Value(currentVersion, this.nextTimestamp(), value);
        return this.cache.putIfAbsent(key, newValue) == null;
    }

    @Override
    public boolean put(Object key, Object value, long txTimestamp, Object version) {
        block2: {
            while (true) {
                Expirable previous = (Expirable)this.cache.get(key);
                Value newValue = new Value(version, this.nextTimestamp(), value);
                if (previous == null) {
                    if (this.cache.putIfAbsent(key, newValue) != null) continue;
                    return true;
                }
                if (!previous.isReplaceableBy(txTimestamp, version, this.versionComparator)) break block2;
                if (this.cache.replace(key, previous, newValue)) break;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean update(Object key, Object newValue, Object newVersion, SoftLock softLock) {
        boolean updated = false;
        while (true) {
            Expirable revised;
            Expirable original = (Expirable)this.cache.get(key);
            long timestamp = this.nextTimestamp();
            if (original == null) {
                revised = new Value(newVersion, timestamp, newValue);
                updated = true;
                if (this.cache.putIfAbsent(key, revised) != null) continue;
                break;
            }
            if (!(softLock instanceof MarkerWrapper)) break;
            ExpiryMarker unwrappedMarker = ((MarkerWrapper)softLock).getMarker();
            if (original.matches(unwrappedMarker)) {
                ExpiryMarker marker = (ExpiryMarker)original;
                if (marker.isConcurrent()) {
                    revised = marker.expire(timestamp);
                    updated = false;
                } else {
                    revised = new Value(newVersion, timestamp, newValue);
                    updated = true;
                }
                if (!this.cache.replace(key, original, revised)) continue;
                break;
            }
            if (original.getValue() == null) {
                updated = false;
                break;
            }
            revised = new ExpiryMarker(newVersion, timestamp, this.nextMarkerId()).expire(timestamp);
            updated = false;
            if (this.cache.replace(key, original, revised)) break;
        }
        this.maybeNotifyTopic(key, newValue, newVersion);
        return updated;
    }

    protected void maybeNotifyTopic(Object key, Object value, Object version) {
        if (this.topic != null) {
            this.topic.publish(this.createMessage(key, value, version));
        }
    }

    protected Object createMessage(Object key, Object value, Object currentVersion) {
        return new Invalidation(key, currentVersion);
    }

    protected MessageListener<Object> createMessageListener() {
        return new MessageListener<Object>(){

            @Override
            public void onMessage(Message<Object> message) {
                LocalRegionCache.this.maybeInvalidate(message.getMessageObject());
            }
        };
    }

    @Override
    public boolean remove(Object key) {
        Expirable value = (Expirable)this.cache.remove(key);
        this.maybeNotifyTopic(key, null, value == null ? null : value.getVersion());
        return value != null;
    }

    @Override
    public SoftLock tryLock(Object key, Object version) {
        long timeout;
        ExpiryMarker marker;
        Expirable original;
        String markerId = this.nextMarkerId();
        do {
            original = (Expirable)this.cache.get(key);
            timeout = this.nextTimestamp() + (long)CacheEnvironment.getDefaultCacheTimeoutInMillis();
        } while (!(original == null ? this.cache.putIfAbsent(key, marker = new ExpiryMarker(version, timeout, markerId)) == null : this.cache.replace(key, original, marker = original.markForExpiration(timeout, markerId))));
        return new MarkerWrapper(marker);
    }

    @Override
    public void unlock(Object key, SoftLock lock) {
        ExpiryMarker revised;
        ExpiryMarker unwrappedMarker;
        Expirable original;
        while ((original = (Expirable)this.cache.get(key)) != null && lock instanceof MarkerWrapper && !(original.matches(unwrappedMarker = ((MarkerWrapper)lock).getMarker()) ? this.cache.replace(key, original, revised = ((ExpiryMarker)original).expire(this.nextTimestamp())) : original.getValue() == null || this.cache.remove(key, original))) {
        }
        this.maybeNotifyTopic(key, null, null);
    }

    @Override
    public boolean contains(Object key) {
        return this.cache.containsKey(key);
    }

    @Override
    public void clear() {
        this.cache.clear();
        this.maybeNotifyTopic(null, null, null);
    }

    @Override
    public long size() {
        return this.cache.size();
    }

    @Override
    public long getSizeInMemory() {
        return 0L;
    }

    @Override
    public Map asMap() {
        return this.cache;
    }

    void cleanup() {
        boolean limitSize;
        long timeToLive;
        int maxSize;
        if (this.config != null) {
            maxSize = this.config.getMaxSizeConfig().getSize();
            timeToLive = (long)this.config.getTimeToLiveSeconds() * 1000L;
        } else {
            maxSize = 100000;
            timeToLive = CacheEnvironment.getDefaultCacheTimeoutInMillis();
        }
        boolean bl = limitSize = maxSize > 0 && maxSize != Integer.MAX_VALUE;
        if (limitSize || timeToLive > 0L) {
            List<EvictionEntry> entries = this.searchEvictableEntries(timeToLive, limitSize);
            int diff = this.cache.size() - maxSize;
            int evictionRate = this.calculateEvictionRate(diff, maxSize);
            if (evictionRate > 0 && entries != null) {
                this.evictEntries(entries, evictionRate);
            }
        }
    }

    protected void maybeInvalidate(Object messageObject) {
        Invalidation invalidation = (Invalidation)messageObject;
        Object key = invalidation.getKey();
        if (key == null) {
            this.cache.clear();
        } else if (this.versionComparator == null) {
            this.cache.remove(key);
        } else {
            Expirable value = (Expirable)this.cache.get(key);
            if (value != null) {
                this.maybeInvalidateVersionedEntity(key, value, invalidation.getVersion());
            }
        }
    }

    private void maybeInvalidateVersionedEntity(Object key, Expirable value, Object newVersion) {
        if (newVersion == null) {
            this.cache.remove(key);
        } else {
            Object currentVersion = value.getVersion();
            if (this.versionComparator.compare(currentVersion, newVersion) < 0) {
                this.cache.remove(key, value);
            }
        }
    }

    private String nextMarkerId() {
        return Long.toString(this.markerIdCounter.getAndIncrement());
    }

    protected long nextTimestamp() {
        return this.hazelcastInstance == null ? Clock.currentTimeMillis() : HazelcastTimestamper.nextTimestamp(this.hazelcastInstance);
    }

    private List<EvictionEntry> searchEvictableEntries(long timeToLive, boolean limitSize) {
        ArrayList<EvictionEntry> entries = null;
        Iterator iter = this.cache.entrySet().iterator();
        long now = this.nextTimestamp();
        while (iter.hasNext()) {
            Map.Entry e = iter.next();
            Object k = e.getKey();
            Expirable expirable = (Expirable)e.getValue();
            if (expirable instanceof ExpiryMarker) continue;
            Value v = (Value)expirable;
            if (timeToLive > 0L && v.getTimestamp() + timeToLive < now) {
                iter.remove();
                continue;
            }
            if (!limitSize) continue;
            if (entries == null) {
                entries = new ArrayList<EvictionEntry>(this.cache.size());
            }
            entries.add(new EvictionEntry(k, v));
        }
        return entries;
    }

    private int calculateEvictionRate(int diff, int maxSize) {
        return diff >= 0 ? diff + (int)((float)maxSize * 0.2f) : 0;
    }

    private void evictEntries(List<EvictionEntry> entries, int evictionRate) {
        Collections.sort(entries);
        int removed = 0;
        for (EvictionEntry entry : entries) {
            if (!this.cache.remove(entry.key, entry.value) || ++removed != evictionRate) continue;
            break;
        }
    }

    private static final class EvictionEntry
    implements Comparable<EvictionEntry> {
        final Object key;
        final Value value;

        private EvictionEntry(Object key, Value value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public int compareTo(EvictionEntry o) {
            long anotherVal;
            long thisVal = this.value.getTimestamp();
            return thisVal < (anotherVal = o.value.getTimestamp()) ? -1 : (thisVal == anotherVal ? 0 : 1);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EvictionEntry that = (EvictionEntry)o;
            return (this.key == null ? that.key == null : this.key.equals(that.key)) && (this.value == null ? that.value == null : this.value.equals(that.value));
        }

        public int hashCode() {
            return this.key == null ? 0 : this.key.hashCode();
        }
    }
}

