/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.monitor.impl.PerIndexStats;
import com.hazelcast.query.impl.Index;
import com.hazelcast.query.impl.Indexes;
import com.hazelcast.query.impl.InternalIndex;
import com.hazelcast.query.impl.QueryContext;
import java.util.HashSet;

public class PartitionQueryContextWithStats
extends QueryContext {
    private final HashSet<PerIndexStats> trackedStats = new HashSet(8);

    public PartitionQueryContextWithStats(Indexes indexes) {
        super(indexes);
    }

    @Override
    void attachTo(Indexes indexes) {
        assert (indexes == this.indexes);
        for (PerIndexStats stats : this.trackedStats) {
            stats.resetPerQueryStats();
        }
        this.trackedStats.clear();
    }

    @Override
    public Index getIndex(String attributeName) {
        if (this.indexes == null) {
            return null;
        }
        InternalIndex index = this.indexes.getIndex(attributeName);
        if (index == null) {
            return null;
        }
        this.trackedStats.add(index.getPerIndexStats());
        return index;
    }

    @Override
    void applyPerQueryStats() {
        for (PerIndexStats stats : this.trackedStats) {
            stats.incrementQueryCount();
        }
    }
}

