/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.AbstractConfigBuilder;
import com.hazelcast.config.GlobalSerializerConfig;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.NativeMemoryConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.SerializerConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.instance.BuildInfo;
import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.memory.MemorySize;
import com.hazelcast.memory.MemoryUnit;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public abstract class AbstractXmlConfigHelper {
    private static final ILogger LOGGER = Logger.getLogger(AbstractXmlConfigHelper.class);
    protected boolean domLevel3 = true;
    final String xmlns = "http://www.hazelcast.com/schema/" + this.getNamespaceType();
    private final String hazelcastSchemaLocation;

    public AbstractXmlConfigHelper() {
        this.hazelcastSchemaLocation = this.getXmlType().name + "-config-" + this.getReleaseVersion() + ".xsd";
    }

    public static Iterable<Node> childElements(Node node) {
        return new IterableNodeList(node, 1);
    }

    public static Iterable<Node> asElementIterable(NodeList list) {
        return new IterableNodeList(list, 1);
    }

    public String getNamespaceType() {
        return this.getXmlType().name.equals("hazelcast") ? "config" : "client-config";
    }

    protected AbstractConfigBuilder.ConfigType getXmlType() {
        return AbstractConfigBuilder.ConfigType.SERVER;
    }

    protected void schemaValidation(Document doc) throws Exception {
        String[] xsdLocations;
        ArrayList<StreamSource> schemas = new ArrayList<StreamSource>();
        InputStream inputStream = null;
        String schemaLocation = doc.getDocumentElement().getAttribute("xsi:schemaLocation");
        schemaLocation = schemaLocation.replaceAll("^ +| +$| (?= )", "");
        for (String xsdLocation : xsdLocations = schemaLocation.split("(?<!\\G\\S+)\\s")) {
            if (xsdLocation.isEmpty()) continue;
            String namespace = xsdLocation.split('[' + StringUtil.LINE_SEPARATOR + " ]+")[0];
            String uri = xsdLocation.split('[' + StringUtil.LINE_SEPARATOR + " ]+")[1];
            if (namespace.equals(this.xmlns) && !uri.endsWith(this.hazelcastSchemaLocation)) {
                LOGGER.warning("Name of the hazelcast schema location is incorrect, using default");
            }
            if (namespace.equals(this.xmlns)) continue;
            inputStream = this.loadSchemaFile(uri);
            schemas.add(new StreamSource(inputStream));
        }
        schemas.add(new StreamSource(this.getClass().getClassLoader().getResourceAsStream(this.hazelcastSchemaLocation)));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        DOMSource xmlSource = new DOMSource(doc);
        StreamResult outputTarget = new StreamResult(outputStream);
        TransformerFactory.newInstance().newTransformer().transform(xmlSource, outputTarget);
        ByteArrayInputStream is = new ByteArrayInputStream(outputStream.toByteArray());
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(schemas.toArray(new Source[schemas.size()]));
        Validator validator = schema.newValidator();
        try {
            SAXSource source = new SAXSource(new InputSource(is));
            validator.validate(source);
        }
        catch (Exception e) {
            throw new InvalidConfigurationException(e.getMessage(), e);
        }
        finally {
            for (StreamSource source : schemas) {
                IOUtil.closeResource(source.getInputStream());
            }
            IOUtil.closeResource(inputStream);
        }
    }

    protected InputStream loadSchemaFile(String schemaLocation) {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(schemaLocation);
        if (inputStream == null) {
            try {
                inputStream = new URL(schemaLocation).openStream();
            }
            catch (Exception e) {
                throw new InvalidConfigurationException("Your xsd schema couldn't be loaded");
            }
        }
        return inputStream;
    }

    protected String getReleaseVersion() {
        BuildInfo buildInfo = BuildInfoProvider.getBuildInfo();
        String[] versionTokens = StringUtil.tokenizeVersionString(buildInfo.getVersion());
        return versionTokens[0] + "." + versionTokens[1];
    }

    protected String xmlToJavaName(String name) {
        String javaRefName = this.xmlRefToJavaName(name);
        if (javaRefName != null) {
            return javaRefName;
        }
        StringBuilder builder = new StringBuilder();
        char[] charArray = name.toCharArray();
        boolean dash = false;
        StringBuilder token = new StringBuilder();
        for (char aCharArray : charArray) {
            if (aCharArray == '-') {
                this.appendToken(builder, token);
                dash = true;
                continue;
            }
            token.append(dash ? Character.toUpperCase(aCharArray) : aCharArray);
            dash = false;
        }
        this.appendToken(builder, token);
        return builder.toString();
    }

    private String xmlRefToJavaName(String name) {
        if (name.equals("quorum-ref")) {
            return "quorumName";
        }
        return null;
    }

    protected void appendToken(StringBuilder builder, StringBuilder token) {
        String string = token.toString();
        if ("Jvm".equals(string)) {
            string = "JVM";
        }
        builder.append(string);
        token.setLength(0);
    }

    protected String getTextContent(Node node) {
        if (node != null) {
            String text = this.domLevel3 ? node.getTextContent() : this.getTextContentOld(node);
            return text != null ? text.trim() : "";
        }
        return "";
    }

    private String getTextContentOld(Node node) {
        Node child = node.getFirstChild();
        if (child != null) {
            Node next = child.getNextSibling();
            if (next == null) {
                return this.hasTextContent(child) ? child.getNodeValue() : "";
            }
            StringBuilder buf = new StringBuilder();
            this.appendTextContents(node, buf);
            return buf.toString();
        }
        return "";
    }

    private void appendTextContents(Node node, StringBuilder buf) {
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!this.hasTextContent(child)) continue;
            buf.append(child.getNodeValue());
        }
    }

    protected final boolean hasTextContent(Node node) {
        short nodeType = node.getNodeType();
        return nodeType != 8 && nodeType != 7;
    }

    public static String cleanNodeName(Node node) {
        String nodeName = node.getLocalName();
        if (nodeName == null) {
            throw new HazelcastException("Local node name is null for " + node);
        }
        return StringUtil.lowerCaseInternal(nodeName);
    }

    protected static boolean getBooleanValue(String value) {
        return Boolean.parseBoolean(StringUtil.lowerCaseInternal(value));
    }

    protected static int getIntegerValue(String parameterName, String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new InvalidConfigurationException(String.format("Invalid integer value for parameter %s: %s", parameterName, value));
        }
    }

    protected static int getIntegerValue(String parameterName, String value, int defaultValue) {
        if (StringUtil.isNullOrEmpty(value)) {
            return defaultValue;
        }
        return AbstractXmlConfigHelper.getIntegerValue(parameterName, value);
    }

    protected static long getLongValue(String parameterName, String value) {
        try {
            return Long.parseLong(value);
        }
        catch (Exception e) {
            throw new InvalidConfigurationException(String.format("Invalid long integer value for parameter %s: %s", parameterName, value));
        }
    }

    protected static long getLongValue(String parameterName, String value, long defaultValue) {
        if (StringUtil.isNullOrEmpty(value)) {
            return defaultValue;
        }
        return AbstractXmlConfigHelper.getLongValue(parameterName, value);
    }

    protected static double getDoubleValue(String parameterName, String value) {
        try {
            return Double.parseDouble(value);
        }
        catch (Exception e) {
            throw new InvalidConfigurationException(String.format("Invalid long integer value for parameter %s: %s", parameterName, value));
        }
    }

    protected static double getDoubleValue(String parameterName, String value, double defaultValue) {
        if (StringUtil.isNullOrEmpty(value)) {
            return defaultValue;
        }
        return AbstractXmlConfigHelper.getDoubleValue(parameterName, value);
    }

    protected String getAttribute(Node node, String attName) {
        Node attNode = node.getAttributes().getNamedItem(attName);
        if (attNode == null) {
            return null;
        }
        return this.getTextContent(attNode);
    }

    protected SocketInterceptorConfig parseSocketInterceptorConfig(Node node) {
        SocketInterceptorConfig socketInterceptorConfig = new SocketInterceptorConfig();
        NamedNodeMap atts = node.getAttributes();
        Node enabledNode = atts.getNamedItem("enabled");
        boolean enabled = enabledNode != null && AbstractXmlConfigHelper.getBooleanValue(this.getTextContent(enabledNode).trim());
        socketInterceptorConfig.setEnabled(enabled);
        for (Node n : AbstractXmlConfigHelper.childElements(node)) {
            String nodeName = AbstractXmlConfigHelper.cleanNodeName(n);
            if ("class-name".equals(nodeName)) {
                socketInterceptorConfig.setClassName(this.getTextContent(n).trim());
                continue;
            }
            if (!"properties".equals(nodeName)) continue;
            this.fillProperties(n, socketInterceptorConfig.getProperties());
        }
        return socketInterceptorConfig;
    }

    protected void fillProperties(Node node, Properties properties) {
        if (properties == null) {
            return;
        }
        for (Node n : AbstractXmlConfigHelper.childElements(node)) {
            String name = AbstractXmlConfigHelper.cleanNodeName(n);
            String propertyName = "property".equals(name) ? this.getTextContent(n.getAttributes().getNamedItem("name")).trim() : name;
            String value = this.getTextContent(n).trim();
            properties.setProperty(propertyName, value);
        }
    }

    protected void fillProperties(Node node, Map<String, Comparable> properties) {
        if (properties == null) {
            return;
        }
        for (Node n : AbstractXmlConfigHelper.childElements(node)) {
            if (n.getNodeType() == 3 || n.getNodeType() == 8) continue;
            String name = AbstractXmlConfigHelper.cleanNodeName(n);
            String propertyName = "property".equals(name) ? this.getTextContent(n.getAttributes().getNamedItem("name")).trim() : name;
            String value = this.getTextContent(n).trim();
            properties.put(propertyName, (Comparable)((Object)value));
        }
    }

    protected SerializationConfig parseSerialization(Node node) {
        SerializationConfig serializationConfig = new SerializationConfig();
        for (Node child : AbstractXmlConfigHelper.childElements(node)) {
            String value;
            String name = AbstractXmlConfigHelper.cleanNodeName(child);
            if ("portable-version".equals(name)) {
                value = this.getTextContent(child);
                serializationConfig.setPortableVersion(AbstractXmlConfigHelper.getIntegerValue(name, value));
                continue;
            }
            if ("check-class-def-errors".equals(name)) {
                value = this.getTextContent(child);
                serializationConfig.setCheckClassDefErrors(AbstractXmlConfigHelper.getBooleanValue(value));
                continue;
            }
            if ("use-native-byte-order".equals(name)) {
                serializationConfig.setUseNativeByteOrder(AbstractXmlConfigHelper.getBooleanValue(this.getTextContent(child)));
                continue;
            }
            if ("byte-order".equals(name)) {
                value = this.getTextContent(child);
                ByteOrder byteOrder = null;
                if (ByteOrder.BIG_ENDIAN.toString().equals(value)) {
                    byteOrder = ByteOrder.BIG_ENDIAN;
                } else if (ByteOrder.LITTLE_ENDIAN.toString().equals(value)) {
                    byteOrder = ByteOrder.LITTLE_ENDIAN;
                }
                serializationConfig.setByteOrder(byteOrder != null ? byteOrder : ByteOrder.BIG_ENDIAN);
                continue;
            }
            if ("enable-compression".equals(name)) {
                serializationConfig.setEnableCompression(AbstractXmlConfigHelper.getBooleanValue(this.getTextContent(child)));
                continue;
            }
            if ("enable-shared-object".equals(name)) {
                serializationConfig.setEnableSharedObject(AbstractXmlConfigHelper.getBooleanValue(this.getTextContent(child)));
                continue;
            }
            if ("allow-unsafe".equals(name)) {
                serializationConfig.setAllowUnsafe(AbstractXmlConfigHelper.getBooleanValue(this.getTextContent(child)));
                continue;
            }
            if ("data-serializable-factories".equals(name)) {
                this.fillDataSerializableFactories(child, serializationConfig);
                continue;
            }
            if ("portable-factories".equals(name)) {
                this.fillPortableFactories(child, serializationConfig);
                continue;
            }
            if (!"serializers".equals(name)) continue;
            this.fillSerializers(child, serializationConfig);
        }
        return serializationConfig;
    }

    protected void fillDataSerializableFactories(Node node, SerializationConfig serializationConfig) {
        for (Node child : AbstractXmlConfigHelper.childElements(node)) {
            String name = AbstractXmlConfigHelper.cleanNodeName(child);
            if (!"data-serializable-factory".equals(name)) continue;
            String value = this.getTextContent(child);
            Node factoryIdNode = child.getAttributes().getNamedItem("factory-id");
            if (factoryIdNode == null) {
                throw new IllegalArgumentException("'factory-id' attribute of 'data-serializable-factory' is required!");
            }
            int factoryId = Integer.parseInt(this.getTextContent(factoryIdNode));
            serializationConfig.addDataSerializableFactoryClass(factoryId, value);
        }
    }

    protected void fillPortableFactories(Node node, SerializationConfig serializationConfig) {
        for (Node child : AbstractXmlConfigHelper.childElements(node)) {
            String name = AbstractXmlConfigHelper.cleanNodeName(child);
            if (!"portable-factory".equals(name)) continue;
            String value = this.getTextContent(child);
            Node factoryIdNode = child.getAttributes().getNamedItem("factory-id");
            if (factoryIdNode == null) {
                throw new IllegalArgumentException("'factory-id' attribute of 'portable-factory' is required!");
            }
            int factoryId = Integer.parseInt(this.getTextContent(factoryIdNode));
            serializationConfig.addPortableFactoryClass(factoryId, value);
        }
    }

    protected void fillSerializers(Node node, SerializationConfig serializationConfig) {
        for (Node child : AbstractXmlConfigHelper.childElements(node)) {
            String name = AbstractXmlConfigHelper.cleanNodeName(child);
            String value = this.getTextContent(child);
            if ("serializer".equals(name)) {
                SerializerConfig serializerConfig = new SerializerConfig();
                String typeClassName = this.getAttribute(child, "type-class");
                String className = this.getAttribute(child, "class-name");
                serializerConfig.setTypeClassName(typeClassName);
                serializerConfig.setClassName(className);
                serializationConfig.addSerializerConfig(serializerConfig);
                continue;
            }
            if (!"global-serializer".equals(name)) continue;
            GlobalSerializerConfig globalSerializerConfig = new GlobalSerializerConfig();
            globalSerializerConfig.setClassName(value);
            String attrValue = this.getAttribute(child, "override-java-serialization");
            boolean overrideJavaSerialization = attrValue != null && AbstractXmlConfigHelper.getBooleanValue(attrValue.trim());
            globalSerializerConfig.setOverrideJavaSerialization(overrideJavaSerialization);
            serializationConfig.setGlobalSerializerConfig(globalSerializerConfig);
        }
    }

    protected void fillNativeMemoryConfig(Node node, NativeMemoryConfig nativeMemoryConfig) {
        NamedNodeMap atts = node.getAttributes();
        Node enabledNode = atts.getNamedItem("enabled");
        boolean enabled = enabledNode != null && AbstractXmlConfigHelper.getBooleanValue(this.getTextContent(enabledNode).trim());
        nativeMemoryConfig.setEnabled(enabled);
        Node allocTypeNode = atts.getNamedItem("allocator-type");
        String allocType = this.getTextContent(allocTypeNode);
        if (allocType != null && !"".equals(allocType)) {
            nativeMemoryConfig.setAllocatorType(NativeMemoryConfig.MemoryAllocatorType.valueOf(StringUtil.upperCaseInternal(allocType)));
        }
        for (Node n : AbstractXmlConfigHelper.childElements(node)) {
            String value;
            String nodeName = AbstractXmlConfigHelper.cleanNodeName(n);
            if ("size".equals(nodeName)) {
                NamedNodeMap attrs = n.getAttributes();
                String value2 = this.getTextContent(attrs.getNamedItem("value"));
                MemoryUnit unit = MemoryUnit.valueOf(this.getTextContent(attrs.getNamedItem("unit")));
                MemorySize memorySize = new MemorySize(Long.parseLong(value2), unit);
                nativeMemoryConfig.setSize(memorySize);
                continue;
            }
            if ("min-block-size".equals(nodeName)) {
                value = this.getTextContent(n);
                nativeMemoryConfig.setMinBlockSize(Integer.parseInt(value));
                continue;
            }
            if ("page-size".equals(nodeName)) {
                value = this.getTextContent(n);
                nativeMemoryConfig.setPageSize(Integer.parseInt(value));
                continue;
            }
            if (!"metadata-space-percentage".equals(nodeName)) continue;
            value = this.getTextContent(n);
            nativeMemoryConfig.setMetadataSpacePercentage(Float.parseFloat(value));
        }
    }

    private static class IterableNodeList
    implements Iterable<Node> {
        private final NodeList wrapped;
        private final int maximum;
        private final short nodeType;

        IterableNodeList(Node parent, short nodeType) {
            this(parent.getChildNodes(), nodeType);
        }

        IterableNodeList(NodeList wrapped, short nodeType) {
            this.wrapped = wrapped;
            this.nodeType = nodeType;
            this.maximum = wrapped.getLength();
        }

        @Override
        public Iterator<Node> iterator() {
            return new Iterator<Node>(){
                private int index;
                private Node next;

                @Override
                public boolean hasNext() {
                    this.next = null;
                    while (this.index < IterableNodeList.this.maximum) {
                        Node item = IterableNodeList.this.wrapped.item(this.index);
                        if (IterableNodeList.this.nodeType == 0 || item.getNodeType() == IterableNodeList.this.nodeType) {
                            this.next = item;
                            return true;
                        }
                        ++this.index;
                    }
                    return false;
                }

                @Override
                public Node next() {
                    if (this.hasNext()) {
                        ++this.index;
                        return this.next;
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

