/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.access;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.hibernate.access.AbstractAccessDelegate;
import com.hazelcast.hibernate.region.HazelcastRegion;
import java.util.Properties;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.access.SoftLock;

public class NonStrictReadWriteAccessDelegate<T extends HazelcastRegion>
extends AbstractAccessDelegate<T> {
    public NonStrictReadWriteAccessDelegate(T hazelcastRegion, Properties props) {
        super(hazelcastRegion, props);
    }

    @Override
    public boolean afterInsert(Object key, Object value, Object version) throws CacheException {
        return false;
    }

    @Override
    public boolean afterUpdate(Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) throws CacheException {
        this.unlockItem(key, lock);
        return false;
    }

    @Override
    public boolean insert(Object key, Object value, Object version) throws CacheException {
        return false;
    }

    @Override
    public boolean update(Object key, Object value, Object currentVersion, Object previousVersion) {
        this.remove(key);
        return false;
    }

    @Override
    public void remove(Object key) throws CacheException {
        try {
            this.cache.remove(key);
        }
        catch (HazelcastException e) {
            throw new CacheException("Operation timeout during remove operation from cache!", (Throwable)e);
        }
    }

    @Override
    public SoftLock lockItem(Object key, Object version) throws CacheException {
        return null;
    }

    @Override
    public void removeAll() throws CacheException {
        this.cache.clear();
    }

    @Override
    public void unlockItem(Object key, SoftLock lock) throws CacheException {
        this.remove(key);
    }
}

