/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.serialization;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.UnsafeHelper;
import com.hazelcast.nio.serialization.StreamSerializer;
import java.io.IOException;
import java.lang.reflect.Field;
import org.hibernate.EntityMode;
import org.hibernate.cache.CacheKey;
import org.hibernate.type.Type;
import sun.misc.Unsafe;

class Hibernate3CacheKeySerializer
implements StreamSerializer<CacheKey> {
    private static final Unsafe UNSAFE = UnsafeHelper.UNSAFE;
    private static final long KEY_OFFSET;
    private static final long TYPE_OFFSET;
    private static final long ENTITY_OR_ROLE_NAME_OFFSET;
    private static final long ENTITY_MODE_OFFSET;
    private static final long HASH_CODE_OFFSET;

    Hibernate3CacheKeySerializer() {
    }

    @Override
    public void write(ObjectDataOutput out, CacheKey object) throws IOException {
        try {
            Object key = UNSAFE.getObject(object, KEY_OFFSET);
            Type type = (Type)UNSAFE.getObject(object, TYPE_OFFSET);
            String entityOrRoleName = (String)UNSAFE.getObject(object, ENTITY_OR_ROLE_NAME_OFFSET);
            EntityMode entityMode = (EntityMode)UNSAFE.getObject(object, ENTITY_MODE_OFFSET);
            int hashCode = UNSAFE.getInt(object, HASH_CODE_OFFSET);
            out.writeObject(key);
            out.writeObject(type);
            out.writeUTF(entityOrRoleName);
            out.writeUTF(entityMode.toString());
            out.writeInt(hashCode);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
    }

    @Override
    public CacheKey read(ObjectDataInput in) throws IOException {
        try {
            Object key = in.readObject();
            Type type = (Type)in.readObject();
            String entityOrRoleName = in.readUTF();
            EntityMode entityMode = EntityMode.parse((String)in.readUTF());
            int hashCode = in.readInt();
            CacheKey cacheKey = (CacheKey)UNSAFE.allocateInstance(CacheKey.class);
            UNSAFE.putObjectVolatile(cacheKey, KEY_OFFSET, key);
            UNSAFE.putObjectVolatile(cacheKey, TYPE_OFFSET, type);
            UNSAFE.putObjectVolatile(cacheKey, ENTITY_OR_ROLE_NAME_OFFSET, entityOrRoleName);
            UNSAFE.putObjectVolatile(cacheKey, ENTITY_MODE_OFFSET, entityMode);
            UNSAFE.putIntVolatile(cacheKey, HASH_CODE_OFFSET, hashCode);
            return cacheKey;
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
    }

    @Override
    public int getTypeId() {
        return -200;
    }

    @Override
    public void destroy() {
    }

    static {
        try {
            Class<CacheKey> cacheKeyClass = CacheKey.class;
            Field key = cacheKeyClass.getDeclaredField("key");
            KEY_OFFSET = UNSAFE.objectFieldOffset(key);
            Field type = cacheKeyClass.getDeclaredField("type");
            TYPE_OFFSET = UNSAFE.objectFieldOffset(type);
            Field entityOrRoleName = cacheKeyClass.getDeclaredField("entityOrRoleName");
            ENTITY_OR_ROLE_NAME_OFFSET = UNSAFE.objectFieldOffset(entityOrRoleName);
            Field entityMode = cacheKeyClass.getDeclaredField("entityMode");
            ENTITY_MODE_OFFSET = UNSAFE.objectFieldOffset(entityMode);
            Field hashCode = cacheKeyClass.getDeclaredField("hashCode");
            HASH_CODE_OFFSET = UNSAFE.objectFieldOffset(hashCode);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

