/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.queue.proxy;

import com.hazelcast.config.ItemListenerConfig;
import com.hazelcast.config.QueueConfig;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.ItemListener;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.queue.AddAllOperation;
import com.hazelcast.queue.ClearOperation;
import com.hazelcast.queue.CompareAndRemoveOperation;
import com.hazelcast.queue.ContainsOperation;
import com.hazelcast.queue.DrainOperation;
import com.hazelcast.queue.IteratorOperation;
import com.hazelcast.queue.OfferOperation;
import com.hazelcast.queue.PeekOperation;
import com.hazelcast.queue.PollOperation;
import com.hazelcast.queue.QueueOperation;
import com.hazelcast.queue.QueueService;
import com.hazelcast.queue.RemoveOperation;
import com.hazelcast.queue.SizeOperation;
import com.hazelcast.spi.AbstractDistributedObject;
import com.hazelcast.spi.InitializingObject;
import com.hazelcast.spi.Invocation;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.impl.SerializableCollection;
import com.hazelcast.util.ExceptionUtil;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;

abstract class QueueProxySupport
extends AbstractDistributedObject<QueueService>
implements InitializingObject {
    final String name;
    final int partitionId;
    final QueueConfig config;

    QueueProxySupport(String name, QueueService queueService, NodeEngine nodeEngine) {
        super(nodeEngine, queueService);
        this.name = name;
        this.partitionId = nodeEngine.getPartitionService().getPartitionId(this.getNameAsPartitionAwareData());
        this.config = nodeEngine.getConfig().getQueueConfig(name);
    }

    @Override
    public void initialize() {
        NodeEngine nodeEngine = this.getNodeEngine();
        List<ItemListenerConfig> itemListenerConfigs = this.config.getItemListenerConfigs();
        for (ItemListenerConfig itemListenerConfig : itemListenerConfigs) {
            ItemListener listener = itemListenerConfig.getImplementation();
            if (listener == null && itemListenerConfig.getClassName() != null) {
                try {
                    listener = (ItemListener)ClassLoaderUtil.newInstance(nodeEngine.getConfigClassLoader(), itemListenerConfig.getClassName());
                }
                catch (Exception e) {
                    throw ExceptionUtil.rethrow(e);
                }
            }
            if (listener == null) continue;
            if (listener instanceof HazelcastInstanceAware) {
                ((HazelcastInstanceAware)((Object)listener)).setHazelcastInstance(nodeEngine.getHazelcastInstance());
            }
            this.addItemListener(listener, itemListenerConfig.isIncludeValue());
        }
    }

    boolean offerInternal(Data data, long timeout) throws InterruptedException {
        this.throwExceptionIfNull(data);
        OfferOperation operation = new OfferOperation(this.name, timeout, data);
        NodeEngine nodeEngine = this.getNodeEngine();
        try {
            Invocation inv = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:queueService", (Operation)operation, this.getPartitionId()).build();
            Future f = inv.invoke();
            return (Boolean)nodeEngine.toObject(f.get());
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrowAllowInterrupted(throwable);
        }
    }

    public int size() {
        SizeOperation operation = new SizeOperation(this.name);
        return (Integer)this.invoke(operation);
    }

    public void clear() {
        ClearOperation operation = new ClearOperation(this.name);
        this.invoke(operation);
    }

    Object peekInternal() {
        PeekOperation operation = new PeekOperation(this.name);
        return this.invokeData(operation);
    }

    Object pollInternal(long timeout) throws InterruptedException {
        PollOperation operation = new PollOperation(this.name, timeout);
        NodeEngine nodeEngine = this.getNodeEngine();
        try {
            Invocation inv = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:queueService", (Operation)operation, this.getPartitionId()).build();
            Future f = inv.invoke();
            return f.get();
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrowAllowInterrupted(throwable);
        }
    }

    boolean removeInternal(Data data) {
        this.throwExceptionIfNull(data);
        RemoveOperation operation = new RemoveOperation(this.name, data);
        return (Boolean)this.invoke(operation);
    }

    boolean containsInternal(Collection<Data> dataList) {
        ContainsOperation operation = new ContainsOperation(this.name, dataList);
        return (Boolean)this.invoke(operation);
    }

    List<Data> listInternal() {
        IteratorOperation operation = new IteratorOperation(this.name);
        SerializableCollection collectionContainer = (SerializableCollection)this.invoke(operation);
        return (List)collectionContainer.getCollection();
    }

    Collection<Data> drainInternal(int maxSize) {
        DrainOperation operation = new DrainOperation(this.name, maxSize);
        SerializableCollection collectionContainer = (SerializableCollection)this.invoke(operation);
        return collectionContainer.getCollection();
    }

    boolean addAllInternal(Collection<Data> dataList) {
        AddAllOperation operation = new AddAllOperation(this.name, dataList);
        return (Boolean)this.invoke(operation);
    }

    boolean compareAndRemove(Collection<Data> dataList, boolean retain) {
        CompareAndRemoveOperation operation = new CompareAndRemoveOperation(this.name, dataList, retain);
        return (Boolean)this.invoke(operation);
    }

    private int getPartitionId() {
        return this.partitionId;
    }

    private void throwExceptionIfNull(Object o) {
        if (o == null) {
            throw new NullPointerException("Object is null");
        }
    }

    private <T> T invoke(QueueOperation operation) {
        NodeEngine nodeEngine = this.getNodeEngine();
        try {
            Invocation inv = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:queueService", (Operation)operation, this.getPartitionId()).build();
            Future f = inv.invoke();
            return nodeEngine.toObject(f.get());
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    private Object invokeData(QueueOperation operation) {
        NodeEngine nodeEngine = this.getNodeEngine();
        try {
            Invocation inv = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:queueService", (Operation)operation, this.getPartitionId()).build();
            Future f = inv.invoke();
            return f.get();
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    @Override
    public final String getServiceName() {
        return "hz:impl:queueService";
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public String addItemListener(ItemListener listener, boolean includeValue) {
        return ((QueueService)this.getService()).addItemListener(this.name, listener, includeValue);
    }

    public boolean removeItemListener(String registrationId) {
        return ((QueueService)this.getService()).removeItemListener(this.name, registrationId);
    }
}

