/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.serialization;

import com.hazelcast.nio.UnsafeHelper;
import com.hazelcast.nio.serialization.ByteArrayObjectDataOutput;
import com.hazelcast.nio.serialization.SerializationService;
import java.io.IOException;
import java.nio.ByteOrder;

final class UnsafeObjectDataOutput
extends ByteArrayObjectDataOutput {
    UnsafeObjectDataOutput(int size, SerializationService service) {
        super(size, service);
    }

    UnsafeObjectDataOutput(byte[] buffer, SerializationService service) {
        super(buffer, service);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.ensureAvailable(2);
        UnsafeHelper.UNSAFE.putChar(this.buffer, UnsafeHelper.BYTE_ARRAY_BASE_OFFSET + (long)this.pos, (char)v);
        this.pos += 2;
    }

    @Override
    public void writeChar(int position, int v) throws IOException {
        this.checkAvailable(position, 2);
        UnsafeHelper.UNSAFE.putChar(this.buffer, UnsafeHelper.BYTE_ARRAY_BASE_OFFSET + (long)position, (char)v);
    }

    @Override
    public void writeChars(String s) throws IOException {
        int len = s.length();
        this.ensureAvailable(len * 2);
        for (int i = 0; i < len; ++i) {
            char v = s.charAt(i);
            this.writeChar(this.pos, v);
            this.pos += 2;
        }
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.ensureAvailable(8);
        UnsafeHelper.UNSAFE.putDouble(this.buffer, UnsafeHelper.BYTE_ARRAY_BASE_OFFSET + (long)this.pos, v);
        this.pos += 8;
    }

    @Override
    public void writeDouble(int position, double v) throws IOException {
        this.checkAvailable(position, 8);
        UnsafeHelper.UNSAFE.putDouble(this.buffer, UnsafeHelper.BYTE_ARRAY_BASE_OFFSET + (long)position, v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.ensureAvailable(4);
        UnsafeHelper.UNSAFE.putFloat(this.buffer, UnsafeHelper.BYTE_ARRAY_BASE_OFFSET + (long)this.pos, v);
        this.pos += 4;
    }

    @Override
    public void writeFloat(int position, float v) throws IOException {
        this.checkAvailable(position, 4);
        UnsafeHelper.UNSAFE.putFloat(this.buffer, UnsafeHelper.BYTE_ARRAY_BASE_OFFSET + (long)position, v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.ensureAvailable(4);
        UnsafeHelper.UNSAFE.putInt(this.buffer, UnsafeHelper.BYTE_ARRAY_BASE_OFFSET + (long)this.pos, v);
        this.pos += 4;
    }

    @Override
    public void writeInt(int position, int v) throws IOException {
        this.checkAvailable(position, 4);
        UnsafeHelper.UNSAFE.putInt(this.buffer, UnsafeHelper.BYTE_ARRAY_BASE_OFFSET + (long)position, v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.ensureAvailable(8);
        UnsafeHelper.UNSAFE.putLong(this.buffer, UnsafeHelper.BYTE_ARRAY_BASE_OFFSET + (long)this.pos, v);
        this.pos += 8;
    }

    @Override
    public void writeLong(int position, long v) throws IOException {
        this.checkAvailable(position, 8);
        UnsafeHelper.UNSAFE.putLong(this.buffer, UnsafeHelper.BYTE_ARRAY_BASE_OFFSET + (long)position, v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.ensureAvailable(2);
        UnsafeHelper.UNSAFE.putShort(this.buffer, UnsafeHelper.BYTE_ARRAY_BASE_OFFSET + (long)this.pos, (short)v);
        this.pos += 2;
    }

    @Override
    public void writeShort(int position, int v) throws IOException {
        this.checkAvailable(position, 2);
        UnsafeHelper.UNSAFE.putShort(this.buffer, UnsafeHelper.BYTE_ARRAY_BASE_OFFSET + (long)position, (short)v);
    }

    @Override
    public void writeCharArray(char[] values) throws IOException {
        int len = values != null ? values.length : 0;
        this.writeInt(len);
        if (len > 0) {
            this.unsafeMemCopy(values, UnsafeHelper.CHAR_ARRAY_BASE_OFFSET, len, UnsafeHelper.CHAR_ARRAY_INDEX_SCALE);
        }
    }

    @Override
    public void writeShortArray(short[] values) throws IOException {
        int len = values != null ? values.length : 0;
        this.writeInt(len);
        if (len > 0) {
            this.unsafeMemCopy(values, UnsafeHelper.SHORT_ARRAY_BASE_OFFSET, len, UnsafeHelper.SHORT_ARRAY_INDEX_SCALE);
        }
    }

    @Override
    public void writeIntArray(int[] values) throws IOException {
        int len = values != null ? values.length : 0;
        this.writeInt(len);
        if (len > 0) {
            this.unsafeMemCopy(values, UnsafeHelper.INT_ARRAY_BASE_OFFSET, len, UnsafeHelper.INT_ARRAY_INDEX_SCALE);
        }
    }

    @Override
    public void writeFloatArray(float[] values) throws IOException {
        int len = values != null ? values.length : 0;
        this.writeInt(len);
        if (len > 0) {
            this.unsafeMemCopy(values, UnsafeHelper.FLOAT_ARRAY_BASE_OFFSET, len, UnsafeHelper.FLOAT_ARRAY_INDEX_SCALE);
        }
    }

    @Override
    public void writeLongArray(long[] values) throws IOException {
        int len = values != null ? values.length : 0;
        this.writeInt(len);
        if (len > 0) {
            this.unsafeMemCopy(values, UnsafeHelper.LONG_ARRAY_BASE_OFFSET, len, UnsafeHelper.LONG_ARRAY_INDEX_SCALE);
        }
    }

    @Override
    public void writeDoubleArray(double[] values) throws IOException {
        int len = values != null ? values.length : 0;
        this.writeInt(len);
        if (len > 0) {
            this.unsafeMemCopy(values, UnsafeHelper.DOUBLE_ARRAY_BASE_OFFSET, len, UnsafeHelper.DOUBLE_ARRAY_INDEX_SCALE);
        }
    }

    private void unsafeMemCopy(Object srcArray, long srcArrayTypeOffset, int srcArrayLength, int indexScale) {
        if (srcArray == null) {
            throw new IllegalArgumentException("Source array is NULL!");
        }
        if (srcArrayLength < 0) {
            throw new NegativeArraySizeException("Source array length is negative: " + srcArrayLength);
        }
        int len = indexScale * srcArrayLength;
        this.ensureAvailable(len);
        UnsafeHelper.UNSAFE.copyMemory(srcArray, srcArrayTypeOffset, this.buffer, UnsafeHelper.BYTE_ARRAY_BASE_OFFSET + (long)this.pos, len);
        this.pos += len;
    }

    @Override
    public ByteOrder getByteOrder() {
        return ByteOrder.nativeOrder();
    }

    private void checkAvailable(int pos, int k) throws IOException {
        int size;
        if (pos < 0) {
            throw new IllegalArgumentException("Negative pos! -> " + pos);
        }
        int n = size = this.buffer != null ? this.buffer.length : 0;
        if (size - pos < k) {
            throw new IOException("Cannot write " + k + " bytes!");
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("UnsafeObjectDataOutput");
        sb.append("{size=").append(this.buffer != null ? this.buffer.length : 0);
        sb.append(", pos=").append(this.pos);
        sb.append(", byteOrder=").append(this.getByteOrder());
        sb.append('}');
        return sb.toString();
    }
}

