/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.operations.client;

import com.hazelcast.client.InitializingObjectRequest;
import com.hazelcast.multimap.MultiMapRecord;
import com.hazelcast.multimap.operations.MultiMapResponse;
import com.hazelcast.multimap.operations.RemoveAllOperation;
import com.hazelcast.multimap.operations.client.MultiMapKeyBasedRequest;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.MultiMapPermission;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.impl.PortableCollection;
import java.io.IOException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;

public class RemoveAllRequest
extends MultiMapKeyBasedRequest
implements InitializingObjectRequest {
    int threadId = -1;

    public RemoveAllRequest() {
    }

    public RemoveAllRequest(String name, Data key, int threadId) {
        super(name, key);
        this.threadId = threadId;
    }

    @Override
    protected Operation prepareOperation() {
        return new RemoveAllOperation(this.name, this.key, this.threadId);
    }

    @Override
    public int getClassId() {
        return 9;
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        writer.writeInt("t", this.threadId);
        super.writePortable(writer);
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        this.threadId = reader.readInt("t");
        super.readPortable(reader);
    }

    @Override
    protected Object filter(Object response) {
        if (response instanceof MultiMapResponse) {
            Collection coll = ((MultiMapResponse)response).getCollection();
            if (coll == null) {
                return new PortableCollection();
            }
            ArrayList<Data> collection = new ArrayList<Data>(coll.size());
            for (MultiMapRecord record : coll) {
                collection.add(this.getClientEngine().toData(record.getObject()));
            }
            return new PortableCollection(collection);
        }
        return super.filter(response);
    }

    @Override
    public Permission getRequiredPermission() {
        return new MultiMapPermission(this.name, "remove");
    }
}

