/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.map.EntryBackupProcessor;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.MapEntrySimple;
import com.hazelcast.map.SimpleEntryView;
import com.hazelcast.map.operation.EntryBackupOperation;
import com.hazelcast.map.operation.LockAwareOperation;
import com.hazelcast.map.record.Record;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.Operation;
import com.hazelcast.util.Clock;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Map;

public class EntryOperation
extends LockAwareOperation
implements BackupAwareOperation {
    private static final EntryEventType __NO_NEED_TO_FIRE_EVENT = null;
    private EntryProcessor entryProcessor;
    private transient EntryEventType eventType;
    private transient Object response;
    protected transient Data dataOldValue;

    public EntryOperation(String name, Data dataKey, EntryProcessor entryProcessor) {
        super(name, dataKey);
        this.entryProcessor = entryProcessor;
    }

    public EntryOperation() {
    }

    @Override
    public void innerBeforeRun() {
        if (this.entryProcessor instanceof HazelcastInstanceAware) {
            ((HazelcastInstanceAware)((Object)this.entryProcessor)).setHazelcastInstance(this.getNodeEngine().getHazelcastInstance());
        }
    }

    @Override
    public void run() {
        Map.Entry<Data, Data> mapEntry = this.recordStore.getMapEntryData(this.dataKey);
        this.dataOldValue = mapEntry.getValue();
        Object valueBeforeProcess = this.mapService.toObject(this.dataOldValue);
        MapEntrySimple<Object, Object> entry = new MapEntrySimple<Object, Object>(this.mapService.toObject(this.dataKey), valueBeforeProcess);
        this.response = this.mapService.toData(this.entryProcessor.process(entry));
        Object valueAfterProcess = entry.getValue();
        if (this.dataOldValue == null && valueAfterProcess == null) {
            this.eventType = __NO_NEED_TO_FIRE_EVENT;
        } else if (valueAfterProcess == null) {
            this.recordStore.remove(this.dataKey);
            this.eventType = EntryEventType.REMOVED;
        } else {
            this.eventType = this.dataOldValue == null ? EntryEventType.ADDED : (!entry.isModified() ? __NO_NEED_TO_FIRE_EVENT : EntryEventType.UPDATED);
            this.dataValue = this.mapService.toData(entry.getValue());
            this.recordStore.put(new AbstractMap.SimpleImmutableEntry<Data, Object>(this.dataKey, this.dataValue));
        }
    }

    @Override
    public void afterRun() throws Exception {
        super.afterRun();
        if (this.eventType == __NO_NEED_TO_FIRE_EVENT) {
            return;
        }
        this.mapService.publishEvent(this.getCallerAddress(), this.name, this.eventType, this.dataKey, this.dataOldValue, this.dataValue);
        this.invalidateNearCaches();
        if (this.mapContainer.getWanReplicationPublisher() != null && this.mapContainer.getWanMergePolicy() != null) {
            if (EntryEventType.REMOVED.equals((Object)this.eventType)) {
                this.mapService.publishWanReplicationRemove(this.name, this.dataKey, Clock.currentTimeMillis());
            } else {
                Record record = this.recordStore.getRecord(this.dataKey);
                SimpleEntryView<Data, Data> entryView = new SimpleEntryView<Data, Data>(this.dataKey, this.mapService.toData(this.dataValue), record.getStatistics(), record.getVersion());
                this.mapService.publishWanReplicationUpdate(this.name, entryView);
            }
        }
    }

    @Override
    public void onWaitExpire() {
        this.getResponseHandler().sendResponse(null);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.entryProcessor = (EntryProcessor)in.readObject();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.entryProcessor);
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    public String toString() {
        return "EntryOperation{}";
    }

    @Override
    public Operation getBackupOperation() {
        EntryBackupProcessor backupProcessor = this.entryProcessor.getBackupProcessor();
        return backupProcessor != null ? new EntryBackupOperation(this.name, this.dataKey, backupProcessor) : null;
    }

    @Override
    public boolean shouldBackup() {
        return this.entryProcessor.getBackupProcessor() != null;
    }

    @Override
    public int getAsyncBackupCount() {
        return this.mapContainer.getAsyncBackupCount();
    }

    @Override
    public int getSyncBackupCount() {
        return this.mapContainer.getBackupCount();
    }
}

