/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MapIndexConfig;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.config.MaxSizeConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.PartitioningStrategyConfig;
import com.hazelcast.config.WanReplicationRef;
import com.hazelcast.map.merge.PutIfAbsentMapMergePolicy;
import com.hazelcast.util.ValidationUtil;
import java.util.ArrayList;
import java.util.List;

public class MapConfig {
    public static final int MIN_BACKUP_COUNT = 0;
    public static final int DEFAULT_BACKUP_COUNT = 1;
    public static final int MAX_BACKUP_COUNT = 6;
    public static final int MIN_EVICTION_PERCENTAGE = 0;
    public static final int DEFAULT_EVICTION_PERCENTAGE = 25;
    public static final int MAX_EVICTION_PERCENTAGE = 100;
    public static final int DEFAULT_TTL_SECONDS = 0;
    public static final int DEFAULT_MAX_IDLE_SECONDS = 0;
    public static final int DEFAULT_MAX_SIZE = Integer.MAX_VALUE;
    public static final EvictionPolicy DEFAULT_EVICTION_POLICY = EvictionPolicy.NONE;
    public static final String DEFAULT_MAP_MERGE_POLICY = PutIfAbsentMapMergePolicy.class.getName();
    public static final InMemoryFormat DEFAULT_IN_MEMORY_FORMAT = InMemoryFormat.BINARY;
    private String name = null;
    private int backupCount = 1;
    private int asyncBackupCount = 0;
    private int evictionPercentage = 25;
    private int timeToLiveSeconds = 0;
    private int maxIdleSeconds = 0;
    private MaxSizeConfig maxSizeConfig = new MaxSizeConfig();
    private EvictionPolicy evictionPolicy = DEFAULT_EVICTION_POLICY;
    private MapStoreConfig mapStoreConfig = null;
    private NearCacheConfig nearCacheConfig = null;
    private boolean readBackupData = false;
    private boolean optimizeQueries = false;
    private String mergePolicy = DEFAULT_MAP_MERGE_POLICY;
    private InMemoryFormat inMemoryFormat = DEFAULT_IN_MEMORY_FORMAT;
    private WanReplicationRef wanReplicationRef;
    private List<EntryListenerConfig> listenerConfigs;
    private List<MapIndexConfig> mapIndexConfigs;
    private boolean statisticsEnabled = true;
    private PartitioningStrategyConfig partitioningStrategyConfig;

    public MapConfig(String name) {
        this.name = name;
    }

    public MapConfig() {
    }

    public MapConfig(MapConfig config) {
        this.name = config.name;
        this.backupCount = config.backupCount;
        this.evictionPercentage = config.evictionPercentage;
        this.timeToLiveSeconds = config.timeToLiveSeconds;
        this.maxIdleSeconds = config.maxIdleSeconds;
        this.maxSizeConfig = config.maxSizeConfig;
        this.evictionPolicy = config.evictionPolicy;
        this.inMemoryFormat = config.inMemoryFormat;
        this.mapStoreConfig = config.mapStoreConfig;
        this.nearCacheConfig = config.nearCacheConfig;
        this.readBackupData = config.readBackupData;
        this.statisticsEnabled = config.statisticsEnabled;
        this.mergePolicy = config.mergePolicy;
        this.wanReplicationRef = config.wanReplicationRef;
        this.listenerConfigs = new ArrayList<EntryListenerConfig>(config.getEntryListenerConfigs());
        this.partitioningStrategyConfig = config.partitioningStrategyConfig;
    }

    public String getName() {
        return this.name;
    }

    public MapConfig setName(String name) {
        this.name = name;
        return this;
    }

    public InMemoryFormat getInMemoryFormat() {
        return this.inMemoryFormat;
    }

    public MapConfig setInMemoryFormat(InMemoryFormat inMemoryFormat) {
        this.inMemoryFormat = ValidationUtil.isNotNull(inMemoryFormat, "inMemoryFormat");
        return this;
    }

    public int getBackupCount() {
        return this.backupCount;
    }

    public MapConfig setBackupCount(int backupCount) {
        if (backupCount < 0) {
            throw new IllegalArgumentException("map backup count must be equal to or bigger than 0");
        }
        if (backupCount + this.asyncBackupCount > 6) {
            throw new IllegalArgumentException("total (sync + async) map backup count must be less than 6");
        }
        this.backupCount = backupCount;
        return this;
    }

    public int getAsyncBackupCount() {
        return this.asyncBackupCount;
    }

    public MapConfig setAsyncBackupCount(int asyncBackupCount) {
        if (asyncBackupCount < 0) {
            throw new IllegalArgumentException("map async backup count must be equal to or bigger than 0");
        }
        if (this.backupCount + asyncBackupCount > 6) {
            throw new IllegalArgumentException("total (sync + async) map backup count must be less than 6");
        }
        this.asyncBackupCount = asyncBackupCount;
        return this;
    }

    public int getTotalBackupCount() {
        return this.backupCount + this.asyncBackupCount;
    }

    public int getEvictionPercentage() {
        return this.evictionPercentage;
    }

    public MapConfig setEvictionPercentage(int evictionPercentage) {
        if (evictionPercentage < 0) {
            throw new IllegalArgumentException("eviction percentage must be greater or equal than 0");
        }
        if (evictionPercentage > 100) {
            throw new IllegalArgumentException("eviction percentage must be smaller or equal than 100");
        }
        this.evictionPercentage = evictionPercentage;
        return this;
    }

    public int getTimeToLiveSeconds() {
        return this.timeToLiveSeconds;
    }

    public MapConfig setTimeToLiveSeconds(int timeToLiveSeconds) {
        this.timeToLiveSeconds = timeToLiveSeconds;
        return this;
    }

    public int getMaxIdleSeconds() {
        return this.maxIdleSeconds;
    }

    public MapConfig setMaxIdleSeconds(int maxIdleSeconds) {
        this.maxIdleSeconds = maxIdleSeconds;
        return this;
    }

    public MaxSizeConfig getMaxSizeConfig() {
        return this.maxSizeConfig;
    }

    public MapConfig setMaxSizeConfig(MaxSizeConfig maxSizeConfig) {
        this.maxSizeConfig = maxSizeConfig;
        return this;
    }

    public EvictionPolicy getEvictionPolicy() {
        return this.evictionPolicy;
    }

    public MapConfig setEvictionPolicy(EvictionPolicy evictionPolicy) {
        this.evictionPolicy = evictionPolicy;
        return this;
    }

    public MapStoreConfig getMapStoreConfig() {
        return this.mapStoreConfig;
    }

    public MapConfig setMapStoreConfig(MapStoreConfig mapStoreConfig) {
        this.mapStoreConfig = mapStoreConfig;
        return this;
    }

    public NearCacheConfig getNearCacheConfig() {
        return this.nearCacheConfig;
    }

    public MapConfig setNearCacheConfig(NearCacheConfig nearCacheConfig) {
        this.nearCacheConfig = nearCacheConfig;
        return this;
    }

    public String getMergePolicy() {
        return this.mergePolicy;
    }

    public MapConfig setMergePolicy(String mergePolicy) {
        this.mergePolicy = mergePolicy;
        return this;
    }

    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public MapConfig setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
        return this;
    }

    public boolean isReadBackupData() {
        return this.readBackupData;
    }

    public MapConfig setReadBackupData(boolean readBackupData) {
        this.readBackupData = readBackupData;
        return this;
    }

    public WanReplicationRef getWanReplicationRef() {
        return this.wanReplicationRef;
    }

    public MapConfig setWanReplicationRef(WanReplicationRef wanReplicationRef) {
        this.wanReplicationRef = wanReplicationRef;
        return this;
    }

    public MapConfig addEntryListenerConfig(EntryListenerConfig listenerConfig) {
        this.getEntryListenerConfigs().add(listenerConfig);
        return this;
    }

    public List<EntryListenerConfig> getEntryListenerConfigs() {
        if (this.listenerConfigs == null) {
            this.listenerConfigs = new ArrayList<EntryListenerConfig>();
        }
        return this.listenerConfigs;
    }

    public MapConfig setEntryListenerConfigs(List<EntryListenerConfig> listenerConfigs) {
        this.listenerConfigs = listenerConfigs;
        return this;
    }

    public MapConfig addMapIndexConfig(MapIndexConfig mapIndexConfig) {
        this.getMapIndexConfigs().add(mapIndexConfig);
        return this;
    }

    public List<MapIndexConfig> getMapIndexConfigs() {
        if (this.mapIndexConfigs == null) {
            this.mapIndexConfigs = new ArrayList<MapIndexConfig>();
        }
        return this.mapIndexConfigs;
    }

    public MapConfig setMapIndexConfigs(List<MapIndexConfig> mapIndexConfigs) {
        this.mapIndexConfigs = mapIndexConfigs;
        return this;
    }

    public PartitioningStrategyConfig getPartitioningStrategyConfig() {
        return this.partitioningStrategyConfig;
    }

    public MapConfig setPartitioningStrategyConfig(PartitioningStrategyConfig partitioningStrategyConfig) {
        this.partitioningStrategyConfig = partitioningStrategyConfig;
        return this;
    }

    public boolean isNearCacheEnabled() {
        return this.nearCacheConfig != null;
    }

    public boolean isOptimizeQueries() {
        return this.optimizeQueries;
    }

    public MapConfig setOptimizeQueries(boolean optimizeQueries) {
        this.optimizeQueries = optimizeQueries;
        return this;
    }

    public boolean isCompatible(MapConfig other) {
        if (this == other) {
            return true;
        }
        return other != null && (this.name != null ? this.name.equals(other.name) : other.name == null) && this.backupCount == other.backupCount && this.asyncBackupCount == other.asyncBackupCount && this.evictionPercentage == other.evictionPercentage && this.maxIdleSeconds == other.maxIdleSeconds && (this.maxSizeConfig.getSize() == other.maxSizeConfig.getSize() || Math.min(this.maxSizeConfig.getSize(), other.maxSizeConfig.getSize()) == 0 && Math.max(this.maxSizeConfig.getSize(), other.maxSizeConfig.getSize()) == Integer.MAX_VALUE) && this.timeToLiveSeconds == other.timeToLiveSeconds && this.readBackupData == other.readBackupData;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.backupCount;
        result = 31 * result + this.asyncBackupCount;
        result = 31 * result + this.evictionPercentage;
        result = 31 * result + (this.evictionPolicy == null ? 0 : this.evictionPolicy.hashCode());
        result = 31 * result + (this.mapStoreConfig == null ? 0 : this.mapStoreConfig.hashCode());
        result = 31 * result + this.maxIdleSeconds;
        result = 31 * result + this.maxSizeConfig.getSize();
        result = 31 * result + (this.mergePolicy == null ? 0 : this.mergePolicy.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.nearCacheConfig == null ? 0 : this.nearCacheConfig.hashCode());
        result = 31 * result + this.timeToLiveSeconds;
        result = 31 * result + (this.readBackupData ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MapConfig)) {
            return false;
        }
        MapConfig other = (MapConfig)obj;
        return (this.name != null ? this.name.equals(other.name) : other.name == null) && this.backupCount == other.backupCount && this.asyncBackupCount == other.asyncBackupCount && this.evictionPercentage == other.evictionPercentage && this.maxIdleSeconds == other.maxIdleSeconds && this.maxSizeConfig.getSize() == other.maxSizeConfig.getSize() && this.timeToLiveSeconds == other.timeToLiveSeconds && this.readBackupData == other.readBackupData && (this.mergePolicy != null ? this.mergePolicy.equals(other.mergePolicy) : other.mergePolicy == null) && (this.inMemoryFormat != null ? this.inMemoryFormat.equals((Object)other.inMemoryFormat) : other.inMemoryFormat == null) && (this.evictionPolicy != null ? this.evictionPolicy.equals((Object)other.evictionPolicy) : other.evictionPolicy == null) && (this.mapStoreConfig != null ? this.mapStoreConfig.equals(other.mapStoreConfig) : other.mapStoreConfig == null) && (this.nearCacheConfig != null ? this.nearCacheConfig.equals(other.nearCacheConfig) : other.nearCacheConfig == null);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MapConfig");
        sb.append("{name='").append(this.name).append('\'');
        sb.append(", inMemoryFormat=").append((Object)this.inMemoryFormat).append('\'');
        sb.append(", backupCount=").append(this.backupCount);
        sb.append(", asyncBackupCount=").append(this.asyncBackupCount);
        sb.append(", timeToLiveSeconds=").append(this.timeToLiveSeconds);
        sb.append(", maxIdleSeconds=").append(this.maxIdleSeconds);
        sb.append(", evictionPolicy='").append((Object)this.evictionPolicy).append('\'');
        sb.append(", evictionPercentage=").append(this.evictionPercentage);
        sb.append(", maxSizeConfig=").append(this.maxSizeConfig);
        sb.append(", readBackupData=").append(this.readBackupData);
        sb.append(", nearCacheConfig=").append(this.nearCacheConfig);
        sb.append(", mapStoreConfig=").append(this.mapStoreConfig);
        sb.append(", mergePolicyConfig='").append(this.mergePolicy).append('\'');
        sb.append(", wanReplicationRef=").append(this.wanReplicationRef);
        sb.append(", listenerConfigs=").append(this.listenerConfigs);
        sb.append(", mapIndexConfigs=").append(this.mapIndexConfigs);
        sb.append('}');
        return sb.toString();
    }

    public static enum EvictionPolicy {
        LRU,
        LFU,
        NONE;

    }
}

