/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.concurrent.atomiclong.client.AddAndGetRequest;
import com.hazelcast.concurrent.atomiclong.client.CompareAndSetRequest;
import com.hazelcast.concurrent.atomiclong.client.GetAndAddRequest;
import com.hazelcast.concurrent.atomiclong.client.GetAndSetRequest;
import com.hazelcast.concurrent.atomiclong.client.SetRequest;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.ExceptionUtil;

public class ClientAtomicLongProxy
extends ClientProxy
implements IAtomicLong {
    private final String name;
    private volatile Data key;

    public ClientAtomicLongProxy(String serviceName, String objectId) {
        super(serviceName, objectId);
        this.name = objectId;
    }

    @Override
    public long addAndGet(long delta) {
        AddAndGetRequest request = new AddAndGetRequest(this.name, delta);
        Long result = (Long)this.invoke(request);
        return result;
    }

    @Override
    public boolean compareAndSet(long expect, long update) {
        CompareAndSetRequest request = new CompareAndSetRequest(this.name, expect, update);
        Boolean result = (Boolean)this.invoke(request);
        return result;
    }

    @Override
    public long decrementAndGet() {
        return this.addAndGet(-1L);
    }

    @Override
    public long get() {
        return this.getAndAdd(0L);
    }

    @Override
    public long getAndAdd(long delta) {
        GetAndAddRequest request = new GetAndAddRequest(this.name, delta);
        Long result = (Long)this.invoke(request);
        return result;
    }

    @Override
    public long getAndSet(long newValue) {
        GetAndSetRequest request = new GetAndSetRequest(this.name, newValue);
        Long result = (Long)this.invoke(request);
        return result;
    }

    @Override
    public long incrementAndGet() {
        return this.addAndGet(1L);
    }

    @Override
    public long getAndIncrement() {
        return this.getAndAdd(1L);
    }

    @Override
    public void set(long newValue) {
        SetRequest request = new SetRequest(this.name, newValue);
        this.invoke(request);
    }

    @Override
    protected void onDestroy() {
    }

    private <T> T invoke(Object req) {
        try {
            return this.getContext().getInvocationService().invokeOnKeyOwner(req, this.getKey());
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    private Data getKey() {
        if (this.key == null) {
            this.key = this.getContext().getSerializationService().toData(this.name);
        }
        return this.key;
    }
}

