/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util.executor;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class ManagedExecutorService
implements ExecutorService {
    private final AtomicLong executedCount = new AtomicLong();
    private final String name;
    private final int maxPoolSize;
    private final ExecutorService cachedExecutor;
    private final BlockingQueue<Runnable> taskQ;
    private final Lock lock = new ReentrantLock();
    private volatile int size;

    public ManagedExecutorService(String name, ExecutorService cachedExecutor, int maxPoolSize) {
        this(name, cachedExecutor, maxPoolSize, Integer.MAX_VALUE);
    }

    public ManagedExecutorService(String name, ExecutorService cachedExecutor, int maxPoolSize, int queueCapacity) {
        if (maxPoolSize <= 0) {
            throw new IllegalArgumentException("Max pool size must be positive!");
        }
        if (queueCapacity <= 0) {
            throw new IllegalArgumentException("Queue capacity must be positive!");
        }
        this.name = name;
        this.maxPoolSize = maxPoolSize;
        this.cachedExecutor = cachedExecutor;
        this.taskQ = new LinkedBlockingQueue<Runnable>(queueCapacity);
    }

    public String getName() {
        return this.name;
    }

    public long getExecutedCount() {
        return this.executedCount.get();
    }

    public int maxPoolSize() {
        return this.maxPoolSize;
    }

    public int poolSize() {
        return this.size;
    }

    public int queueSize() {
        return this.taskQ.size();
    }

    public int queueRemainingCapacity() {
        return this.taskQ.remainingCapacity();
    }

    @Override
    public void execute(Runnable command) {
        if (!this.taskQ.offer(command)) {
            throw new RejectedExecutionException("Executor[" + this.name + "] is overloaded!");
        }
        this.addNewWorkerIfRequired();
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        FutureTask<T> rf = new FutureTask<T>(task);
        this.execute(rf);
        return rf;
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        FutureTask<T> rf = new FutureTask<T>(task, result);
        this.execute(rf);
        return rf;
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.submit(task, null);
    }

    private void addNewWorkerIfRequired() {
        block7: {
            if (this.size < this.maxPoolSize) {
                try {
                    if (!this.lock.tryLock(250L, TimeUnit.MILLISECONDS)) break block7;
                    try {
                        if (this.size < this.maxPoolSize && this.queueSize() > 0) {
                            ++this.size;
                            this.cachedExecutor.execute(new Worker());
                        }
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void shutdown() {
        this.taskQ.clear();
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown();
        return null;
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return false;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new UnsupportedOperationException();
    }

    private class Worker
    implements Runnable {
        private Worker() {
        }

        @Override
        public void run() {
            try {
                Runnable r;
                do {
                    if ((r = (Runnable)ManagedExecutorService.this.taskQ.poll(1L, TimeUnit.MILLISECONDS)) == null) continue;
                    r.run();
                    ManagedExecutorService.this.executedCount.incrementAndGet();
                } while (r != null);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.exit();
            }
        }

        void exit() {
            ManagedExecutorService.this.lock.lock();
            try {
                ManagedExecutorService.this.size--;
                if (ManagedExecutorService.this.taskQ.peek() != null) {
                    ManagedExecutorService.this.addNewWorkerIfRequired();
                }
            }
            finally {
                ManagedExecutorService.this.lock.unlock();
            }
        }
    }
}

