/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.nio.serialization.FieldType;
import com.hazelcast.query.impl.TypeConverters;

public enum AttributeType {
    DOUBLE(FieldType.DOUBLE.getId(), TypeConverters.DOUBLE_CONVERTER),
    LONG(FieldType.LONG.getId(), TypeConverters.LONG_CONVERTER),
    SHORT(FieldType.SHORT.getId(), TypeConverters.SHORT_CONVERTER),
    BOOLEAN(FieldType.BOOLEAN.getId(), TypeConverters.BOOLEAN_CONVERTER),
    BYTE(FieldType.BYTE.getId(), TypeConverters.BYTE_CONVERTER),
    STRING(FieldType.UTF.getId(), TypeConverters.STRING_CONVERTER),
    FLOAT(FieldType.FLOAT.getId(), TypeConverters.FLOAT_CONVERTER),
    CHAR(FieldType.CHAR.getId(), TypeConverters.CHAR_CONVERTER),
    INTEGER(FieldType.INT.getId(), TypeConverters.INTEGER_CONVERTER),
    ENUM(44, TypeConverters.ENUM_CONVERTER),
    BIG_INTEGER(45, TypeConverters.BIG_INTEGER_CONVERTER),
    BIG_DECIMAL(46, TypeConverters.BIG_DECIMAL_CONVERTER),
    SQL_TIMESTAMP(47, TypeConverters.SQL_TIMESTAMP_CONVERTER),
    SQL_DATE(48, TypeConverters.SQL_DATE_CONVERTER),
    DATE(49, TypeConverters.DATE_CONVERTER);

    private static final AttributeType[] types;
    private final int id;
    private final TypeConverters.TypeConverter converter;

    private AttributeType(int id, TypeConverters.TypeConverter converter) {
        this.id = id;
        this.converter = converter;
    }

    public int getId() {
        return this.id;
    }

    public TypeConverters.TypeConverter getConverter() {
        return this.converter;
    }

    public static AttributeType getAttributeType(int id) {
        return types[id];
    }

    static {
        types = new AttributeType[50];
        AttributeType[] attributeTypeArray = AttributeType.values();
        int n = attributeTypeArray.length;
        for (int i = 0; i < n; ++i) {
            AttributeType cop;
            AttributeType.types[cop.getId()] = cop = attributeTypeArray[i];
        }
    }
}

