/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.monitor.impl;

import com.hazelcast.monitor.LocalExecutorStats;
import com.hazelcast.monitor.LocalInstanceStats;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.monitor.LocalMultiMapStats;
import com.hazelcast.monitor.LocalQueueStats;
import com.hazelcast.monitor.LocalTopicStats;
import com.hazelcast.monitor.MemberState;
import com.hazelcast.monitor.impl.LocalExecutorStatsImpl;
import com.hazelcast.monitor.impl.LocalMapStatsImpl;
import com.hazelcast.monitor.impl.LocalMultiMapStatsImpl;
import com.hazelcast.monitor.impl.LocalQueueStatsImpl;
import com.hazelcast.monitor.impl.LocalTopicStatsImpl;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MemberStateImpl
implements MemberState {
    private static final long serialVersionUID = -1817978625085375340L;
    Address address = new Address();
    Map<String, Long> runtimeProps = new HashMap<String, Long>();
    Map<String, LocalMapStatsImpl> mapStats = new HashMap<String, LocalMapStatsImpl>();
    Map<String, LocalMultiMapStatsImpl> multiMapStats = new HashMap<String, LocalMultiMapStatsImpl>();
    Map<String, LocalQueueStatsImpl> queueStats = new HashMap<String, LocalQueueStatsImpl>();
    Map<String, LocalTopicStatsImpl> topicStats = new HashMap<String, LocalTopicStatsImpl>();
    Map<String, LocalExecutorStatsImpl> executorStats = new HashMap<String, LocalExecutorStatsImpl>();
    List<Integer> partitions = new ArrayList<Integer>(271);

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        this.address.writeData(out);
        out.writeInt(this.mapStats.size());
        for (Map.Entry<String, LocalMapStatsImpl> entry : this.mapStats.entrySet()) {
            out.writeUTF(entry.getKey());
            entry.getValue().writeData(out);
        }
        out.writeInt(this.multiMapStats.size());
        for (Map.Entry<String, LocalMapStatsImpl> entry : this.multiMapStats.entrySet()) {
            out.writeUTF(entry.getKey());
            ((LocalMultiMapStatsImpl)entry.getValue()).writeData(out);
        }
        out.writeInt(this.queueStats.size());
        for (Map.Entry<String, LocalInstanceStats> entry : this.queueStats.entrySet()) {
            out.writeUTF(entry.getKey());
            ((LocalQueueStatsImpl)entry.getValue()).writeData(out);
        }
        out.writeInt(this.topicStats.size());
        for (Map.Entry<String, LocalInstanceStats> entry : this.topicStats.entrySet()) {
            out.writeUTF(entry.getKey());
            ((LocalTopicStatsImpl)entry.getValue()).writeData(out);
        }
        out.writeInt(this.executorStats.size());
        for (Map.Entry<String, LocalInstanceStats> entry : this.executorStats.entrySet()) {
            out.writeUTF(entry.getKey());
            ((LocalExecutorStatsImpl)entry.getValue()).writeData(out);
        }
        out.writeInt(this.runtimeProps.size());
        for (Map.Entry<String, Serializable> entry : this.runtimeProps.entrySet()) {
            out.writeUTF(entry.getKey());
            out.writeLong((Long)entry.getValue());
        }
        out.writeInt(this.partitions.size());
        for (Integer n : this.partitions) {
            out.writeInt(n);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        LocalInstanceStats impl;
        String name;
        int i;
        this.address.readData(in);
        for (i = in.readInt(); i > 0; --i) {
            name = in.readUTF();
            impl = new LocalMapStatsImpl();
            impl.readData(in);
            this.mapStats.put(name, (LocalMapStatsImpl)impl);
        }
        for (i = in.readInt(); i > 0; --i) {
            name = in.readUTF();
            impl = new LocalMultiMapStatsImpl();
            impl.readData(in);
            this.multiMapStats.put(name, (LocalMultiMapStatsImpl)impl);
        }
        for (i = in.readInt(); i > 0; --i) {
            name = in.readUTF();
            impl = new LocalQueueStatsImpl();
            impl.readData(in);
            this.queueStats.put(name, (LocalQueueStatsImpl)impl);
        }
        for (i = in.readInt(); i > 0; --i) {
            name = in.readUTF();
            impl = new LocalTopicStatsImpl();
            impl.readData(in);
            this.topicStats.put(name, (LocalTopicStatsImpl)impl);
        }
        for (i = in.readInt(); i > 0; --i) {
            name = in.readUTF();
            impl = new LocalExecutorStatsImpl();
            impl.readData(in);
            this.executorStats.put(name, (LocalExecutorStatsImpl)impl);
        }
        for (i = in.readInt(); i > 0; --i) {
            name = in.readUTF();
            this.runtimeProps.put(name, in.readLong());
        }
        for (i = in.readInt(); i > 0; --i) {
            this.partitions.add(in.readInt());
        }
    }

    public void clearPartitions() {
        this.partitions.clear();
    }

    public void addPartition(int partitionId) {
        this.partitions.add(partitionId);
    }

    @Override
    public List<Integer> getPartitions() {
        return this.partitions;
    }

    public int hashCode() {
        int result = this.address != null ? this.address.hashCode() : 0;
        result = 31 * result + (this.mapStats != null ? this.mapStats.hashCode() : 0);
        result = 31 * result + (this.multiMapStats != null ? this.multiMapStats.hashCode() : 0);
        result = 31 * result + (this.queueStats != null ? this.queueStats.hashCode() : 0);
        result = 31 * result + (this.topicStats != null ? this.topicStats.hashCode() : 0);
        result = 31 * result + (this.executorStats != null ? this.executorStats.hashCode() : 0);
        result = 31 * result + (this.partitions != null ? this.partitions.hashCode() : 0);
        return result;
    }

    @Override
    public Map<String, Long> getRuntimeProps() {
        return this.runtimeProps;
    }

    public void setRuntimeProps(Map<String, Long> runtimeProps) {
        this.runtimeProps = runtimeProps;
    }

    @Override
    public LocalMapStats getLocalMapStats(String mapName) {
        return this.mapStats.get(mapName);
    }

    @Override
    public LocalMultiMapStats getLocalMultiMapStats(String mapName) {
        return this.multiMapStats.get(mapName);
    }

    @Override
    public LocalQueueStats getLocalQueueStats(String queueName) {
        return this.queueStats.get(queueName);
    }

    @Override
    public LocalTopicStats getLocalTopicStats(String topicName) {
        return this.topicStats.get(topicName);
    }

    @Override
    public LocalExecutorStats getLocalExecutorStats(String executorName) {
        return this.executorStats.get(executorName);
    }

    @Override
    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public void putLocalMapStats(String name, LocalMapStatsImpl localMapStats) {
        this.mapStats.put(name, localMapStats);
    }

    public void putLocalMultiMapStats(String name, LocalMultiMapStatsImpl localMultiMapStats) {
        this.multiMapStats.put(name, localMultiMapStats);
    }

    public void putLocalQueueStats(String name, LocalQueueStatsImpl localQueueStats) {
        this.queueStats.put(name, localQueueStats);
    }

    public void putLocalTopicStats(String name, LocalTopicStatsImpl localTopicStats) {
        this.topicStats.put(name, localTopicStats);
    }

    public void putLocalExecutorStats(String name, LocalExecutorStatsImpl localExecutorStats) {
        this.executorStats.put(name, localExecutorStats);
    }

    public String toString() {
        return "MemberStateImpl{address=" + this.address + ", runtimeProps=" + this.runtimeProps + ", mapStats=" + this.mapStats + ", multiMapStats=" + this.multiMapStats + ", queueStats=" + this.queueStats + ", topicStats=" + this.topicStats + ", executorStats=" + this.executorStats + ", partitions=" + this.partitions + '}';
    }
}

