/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.management;

import com.hazelcast.cluster.MemberInfo;
import com.hazelcast.concurrent.lock.LockResource;
import com.hazelcast.core.Member;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.management.ConnectionInfo;
import com.hazelcast.management.LockInfo;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.partition.InternalPartition;
import com.hazelcast.partition.MigrationInfo;
import com.hazelcast.partition.PartitionRuntimeState;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ClusterRuntimeState
extends PartitionRuntimeState
implements DataSerializable {
    private static final int LOCK_MAX_SIZE = 100;
    private int localMemberIndex;
    private Collection<ConnectionInfo> connectionInfos;
    private Collection<MigrationInfo> activeMigrations;
    private List<LockInfo> lockInfos;
    private int lockTotalNum = 0;

    public ClusterRuntimeState() {
    }

    public ClusterRuntimeState(Collection<Member> members, InternalPartition[] partitions, Collection<MigrationInfo> activeMigrations, Map<Address, Connection> connections, Collection<LockResource> locks) {
        this.activeMigrations = activeMigrations != null ? activeMigrations : Collections.emptySet();
        this.lockInfos = new LinkedList<LockInfo>();
        this.connectionInfos = new LinkedList<ConnectionInfo>();
        HashMap<Address, Integer> addressIndexes = new HashMap<Address, Integer>(members.size());
        int memberIndex = 0;
        for (Member member : members) {
            MemberImpl memberImpl = (MemberImpl)member;
            MemberInfo memberInfo = new MemberInfo(memberImpl.getAddress(), member.getUuid());
            this.addMemberInfo(memberInfo, addressIndexes, memberIndex);
            if (!member.localMember()) {
                Connection conn = connections.get(memberImpl.getAddress());
                ConnectionInfo connectionInfo = conn != null ? new ConnectionInfo(memberIndex, conn.live(), conn.lastReadTime(), conn.lastWriteTime()) : new ConnectionInfo(memberIndex, false, 0L, 0L);
                this.connectionInfos.add(connectionInfo);
            } else {
                this.localMemberIndex = memberIndex;
            }
            ++memberIndex;
        }
        this.setPartitions(partitions, addressIndexes);
        this.setLocks(locks, addressIndexes, members);
    }

    private void setLocks(Collection<LockResource> locks, Map<Address, Integer> addressIndexes, Collection<Member> members) {
        HashMap<String, Address> uuidToAddress = new HashMap<String, Address>(members.size());
        for (Member member : members) {
            uuidToAddress.put(member.getUuid(), ((MemberImpl)member).getAddress());
        }
        for (LockResource lock : locks) {
            if (!lock.isLocked()) continue;
            Integer index = addressIndexes.get(uuidToAddress.get(lock.getOwner()));
            if (index == null) {
                index = -1;
            }
            this.lockInfos.add(new LockInfo(lock.getOwner(), String.valueOf(lock.getKey()), lock.getAcquireTime(), index, lock.getLockCount()));
        }
        this.lockTotalNum = this.lockInfos.size();
        Collections.sort(this.lockInfos, new Comparator<LockInfo>(){

            @Override
            public int compare(LockInfo o1, LockInfo o2) {
                int comp1 = Integer.valueOf(o2.getWaitingThreadCount()).compareTo(o1.getWaitingThreadCount());
                if (comp1 == 0) {
                    return Long.valueOf(o1.getAcquireTime()).compareTo(o2.getAcquireTime());
                }
                return comp1;
            }
        });
        this.lockInfos = this.lockInfos.subList(0, Math.min(100, this.lockInfos.size()));
    }

    public MemberInfo getMember(int index) {
        return (MemberInfo)this.members.get(index);
    }

    public Collection<ConnectionInfo> getConnectionInfos() {
        return this.connectionInfos;
    }

    public Collection<MigrationInfo> getActiveMigrations() {
        return this.activeMigrations;
    }

    public MemberInfo getLocalMember() {
        return (MemberInfo)this.members.get(this.localMemberIndex);
    }

    public Collection<LockInfo> getLockInfos() {
        return this.lockInfos;
    }

    public int getLockTotalNum() {
        return this.lockTotalNum;
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.localMemberIndex = in.readInt();
        this.lockTotalNum = in.readInt();
        int connectionInfoSize = in.readInt();
        this.connectionInfos = new ArrayList<ConnectionInfo>(connectionInfoSize);
        for (int i = 0; i < connectionInfoSize; ++i) {
            ConnectionInfo connectionInfo = new ConnectionInfo();
            connectionInfo.readData(in);
            this.connectionInfos.add(connectionInfo);
        }
        int migrationsSize = in.readInt();
        this.activeMigrations = new ArrayList<MigrationInfo>(migrationsSize);
        for (int i = 0; i < migrationsSize; ++i) {
            MigrationInfo migrationInfo = new MigrationInfo();
            migrationInfo.readData(in);
            this.activeMigrations.add(migrationInfo);
        }
        int lockSize = in.readInt();
        this.lockInfos = new ArrayList<LockInfo>(lockSize);
        for (int i = 0; i < lockSize; ++i) {
            LockInfo lockInfo = new LockInfo();
            lockInfo.readData(in);
            this.lockInfos.add(lockInfo);
        }
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        out.writeInt(this.localMemberIndex);
        out.writeInt(this.lockTotalNum);
        int connectionInfoSize = this.connectionInfos != null ? this.connectionInfos.size() : 0;
        out.writeInt(connectionInfoSize);
        if (connectionInfoSize > 0) {
            for (ConnectionInfo connectionInfo : this.connectionInfos) {
                connectionInfo.writeData(out);
            }
        }
        int migrationsSize = this.activeMigrations != null ? this.activeMigrations.size() : 0;
        out.writeInt(migrationsSize);
        if (migrationsSize > 0) {
            for (MigrationInfo migrationInfo : this.activeMigrations) {
                migrationInfo.writeData(out);
            }
        }
        int n = this.lockInfos != null ? this.lockInfos.size() : 0;
        out.writeInt(n);
        if (n > 0) {
            for (LockInfo lockInfo : this.lockInfos) {
                lockInfo.writeData(out);
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ClusterRuntimeState");
        sb.append("{members=").append(this.members);
        sb.append(", localMember=").append(this.localMemberIndex);
        sb.append(", activeMigrations=").append(this.activeMigrations);
        sb.append(", waitingLockCount=").append(this.lockInfos.size());
        sb.append('}');
        return sb.toString();
    }
}

