/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance;

import com.hazelcast.instance.Node;
import com.hazelcast.instance.NodeInitializer;
import com.hazelcast.logging.ILogger;
import com.hazelcast.security.SecurityContext;
import com.hazelcast.storage.DataRef;
import com.hazelcast.storage.Storage;
import java.io.InputStream;
import java.util.Properties;

public class DefaultNodeInitializer
implements NodeInitializer {
    protected ILogger logger;
    protected ILogger systemLogger;
    protected Node node;
    protected String version;
    protected String build;
    private int buildNumber;

    @Override
    public void beforeInitialize(Node node) {
        this.node = node;
        this.systemLogger = node.getLogger("com.hazelcast.system");
        this.logger = node.getLogger("com.hazelcast.initializer");
        this.parseSystemProps();
    }

    @Override
    public void printNodeInfo(Node node) {
        this.systemLogger.info("Hazelcast Community Edition " + this.version + " (" + this.build + ") starting at " + node.getThisAddress());
        this.systemLogger.info("Copyright (C) 2008-2014 Hazelcast.com");
    }

    @Override
    public void afterInitialize(Node node) {
    }

    protected void parseSystemProps() {
        this.version = System.getProperty("hazelcast.version", "unknown");
        this.build = System.getProperty("hazelcast.build", "unknown");
        if ("unknown".equals(this.version) || "unknown".equals(this.build)) {
            try {
                InputStream inRuntimeProperties = NodeInitializer.class.getClassLoader().getResourceAsStream("hazelcast-runtime.properties");
                if (inRuntimeProperties != null) {
                    Properties runtimeProperties = new Properties();
                    runtimeProperties.load(inRuntimeProperties);
                    inRuntimeProperties.close();
                    this.version = runtimeProperties.getProperty("hazelcast.version");
                    this.build = runtimeProperties.getProperty("hazelcast.build");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.buildNumber = Integer.getInteger("hazelcast.build", -1);
            if (this.buildNumber == -1) {
                this.buildNumber = Integer.parseInt(this.build);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int getBuildNumber() {
        return this.buildNumber;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getBuild() {
        return this.build;
    }

    @Override
    public SecurityContext getSecurityContext() {
        this.logger.warning("Security features are only available on Hazelcast Enterprise Edition!");
        return null;
    }

    @Override
    public Storage<DataRef> getOffHeapStorage() {
        throw new UnsupportedOperationException("Offheap feature is only available on Hazelcast Enterprise Edition!");
    }

    @Override
    public void destroy() {
        this.logger.info("Destroying node initializer.");
    }
}

