/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.semaphore;

import com.hazelcast.concurrent.semaphore.DeadMemberBackupOperation;
import com.hazelcast.concurrent.semaphore.SemaphoreBackupAwareOperation;
import com.hazelcast.concurrent.semaphore.SemaphoreWaitNotifyKey;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.Notifier;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.WaitNotifyKey;
import java.io.IOException;

public class SemaphoreDeadMemberOperation
extends SemaphoreBackupAwareOperation
implements Notifier {
    String firstCaller;

    public SemaphoreDeadMemberOperation() {
    }

    public SemaphoreDeadMemberOperation(String name, String firstCaller) {
        super(name, -1);
        this.firstCaller = firstCaller;
    }

    @Override
    public void run() throws Exception {
        this.response = this.getPermit().memberRemoved(this.firstCaller);
    }

    @Override
    public boolean shouldBackup() {
        return Boolean.TRUE.equals(this.response);
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public Operation getBackupOperation() {
        return new DeadMemberBackupOperation(this.name, this.firstCaller);
    }

    @Override
    public void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.firstCaller);
    }

    @Override
    public void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.firstCaller = in.readUTF();
    }

    @Override
    public boolean shouldNotify() {
        return Boolean.TRUE.equals(this.response);
    }

    @Override
    public WaitNotifyKey getNotifiedKey() {
        return new SemaphoreWaitNotifyKey(this.name, "acquire");
    }
}

