/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.util;

import com.hazelcast.client.LoadBalancer;
import com.hazelcast.client.util.AbstractLoadBalancer;
import com.hazelcast.core.Member;
import com.hazelcast.core.MembershipListener;
import java.util.concurrent.atomic.AtomicInteger;

public class RoundRobinLB
extends AbstractLoadBalancer
implements LoadBalancer,
MembershipListener {
    private final AtomicInteger indexRef;

    public RoundRobinLB() {
        this((int)System.nanoTime());
    }

    public RoundRobinLB(int seed) {
        this.indexRef = new AtomicInteger(seed);
    }

    @Override
    public Member next() {
        Member[] members = this.getMembers();
        if (members == null || members.length == 0) {
            return null;
        }
        int length = members.length;
        return members[(this.indexRef.getAndAdd(1) % length + length) % length];
    }
}

