/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.monitor.impl;

import com.hazelcast.monitor.LocalExecutorStats;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.util.Clock;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;

public class LocalExecutorStatsImpl
implements LocalExecutorStats {
    private long creationTime;
    private final AtomicLong pending = new AtomicLong(0L);
    private final AtomicLong started = new AtomicLong(0L);
    private final AtomicLong completed = new AtomicLong(0L);
    private final AtomicLong cancelled = new AtomicLong(0L);
    private final AtomicLong totalStartLatency = new AtomicLong(0L);
    private final AtomicLong totalExecutionTime = new AtomicLong(0L);

    public LocalExecutorStatsImpl() {
        this.creationTime = Clock.currentTimeMillis();
    }

    public void startPending() {
        this.pending.incrementAndGet();
    }

    public void startExecution(long elapsed) {
        this.totalStartLatency.addAndGet(elapsed);
        this.started.incrementAndGet();
        this.pending.decrementAndGet();
    }

    public void finishExecution(long elapsed) {
        this.totalExecutionTime.addAndGet(elapsed);
        this.completed.incrementAndGet();
    }

    public void rejectExecution() {
        this.pending.decrementAndGet();
    }

    public void cancelExecution() {
        this.cancelled.incrementAndGet();
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public long getPendingTaskCount() {
        return this.pending.get();
    }

    @Override
    public long getStartedTaskCount() {
        return this.started.get();
    }

    @Override
    public long getCompletedTaskCount() {
        return this.completed.get();
    }

    @Override
    public long getCancelledTaskCount() {
        return this.cancelled.get();
    }

    @Override
    public long getTotalStartLatency() {
        return this.totalStartLatency.get();
    }

    @Override
    public long getTotalExecutionLatency() {
        return this.totalExecutionTime.get();
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.creationTime);
        out.writeLong(this.pending.get());
        out.writeLong(this.started.get());
        out.writeLong(this.totalStartLatency.get());
        out.writeLong(this.completed.get());
        out.writeLong(this.totalExecutionTime.get());
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.creationTime = in.readLong();
        this.pending.set(in.readLong());
        this.started.set(in.readLong());
        this.totalStartLatency.set(in.readLong());
        this.completed.set(in.readLong());
        this.totalExecutionTime.set(in.readLong());
    }
}

