/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.partition;

import com.hazelcast.partition.PartitionView;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class Partitions
implements Iterable<PartitionView> {
    private final PartitionView[] partitions;

    Partitions(PartitionView[] partitions) {
        this.partitions = partitions;
    }

    public PartitionView get(int partitionId) {
        if (partitionId < 0 || partitionId >= this.partitions.length) {
            throw new IllegalArgumentException();
        }
        return this.partitions[partitionId];
    }

    public int size() {
        return this.partitions.length;
    }

    @Override
    public Iterator<PartitionView> iterator() {
        return new Iterator<PartitionView>(){
            final int max;
            int pos;
            {
                this.max = Partitions.this.partitions.length - 1;
                this.pos = -1;
            }

            @Override
            public boolean hasNext() {
                return this.pos < this.max;
            }

            @Override
            public PartitionView next() {
                if (this.pos == this.max) {
                    throw new NoSuchElementException();
                }
                return Partitions.this.partitions[++this.pos];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

