/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.logging;

import com.hazelcast.logging.SystemLog;
import com.hazelcast.logging.SystemLogRecord;
import com.hazelcast.logging.SystemObjectLog;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Queue;
import java.util.TreeSet;
import java.util.concurrent.LinkedBlockingQueue;

public class SystemLogService {
    private final Queue<SystemLog> joinLogs = new LinkedBlockingQueue<SystemLog>(1000);
    private final Queue<SystemLog> connectionLogs = new LinkedBlockingQueue<SystemLog>(1000);
    private final Queue<SystemLog> partitionLogs = new LinkedBlockingQueue<SystemLog>(1000);
    private final Queue<SystemLog> nodeLogs = new LinkedBlockingQueue<SystemLog>(1000);
    private final Queue<SystemLog> warningLevelLogs = new LinkedBlockingQueue<SystemLog>(1000);
    private final boolean systemLogEnabled;

    public SystemLogService(boolean systemLogEnabled) {
        this.systemLogEnabled = systemLogEnabled;
    }

    public List<SystemLogRecord> getSystemWarnings() {
        ArrayList<SystemLogRecord> systemLogList = new ArrayList<SystemLogRecord>();
        ((LinkedBlockingQueue)this.warningLevelLogs).drainTo(systemLogList);
        return systemLogList;
    }

    public List<SystemLogRecord> getLogBundle() {
        ArrayList<SystemLogRecord> systemLogList = new ArrayList<SystemLogRecord>();
        for (SystemLog log : this.joinLogs) {
            systemLogList.add(new SystemLogRecord(log.getDate(), log.toString(), log.getType().toString()));
        }
        for (SystemLog log : this.nodeLogs) {
            systemLogList.add(new SystemLogRecord(log.getDate(), log.toString(), log.getType().toString()));
        }
        for (SystemLog log : this.connectionLogs) {
            systemLogList.add(new SystemLogRecord(log.getDate(), log.toString(), log.getType().toString()));
        }
        for (SystemLog log : this.partitionLogs) {
            systemLogList.add(new SystemLogRecord(log.getDate(), log.toString(), log.getType().toString()));
        }
        return systemLogList;
    }

    public void shutdown() {
        this.connectionLogs.clear();
        this.nodeLogs.clear();
        this.joinLogs.clear();
        this.partitionLogs.clear();
    }

    public String dump() {
        StringBuilder sb = new StringBuilder();
        TreeSet<SystemLog> sorted = new TreeSet<SystemLog>(new Comparator<SystemLog>(){

            @Override
            public int compare(SystemLog o1, SystemLog o2) {
                long thisVal = o1.date;
                long anotherVal = o2.date;
                return thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
            }
        });
        sorted.addAll(this.joinLogs);
        sorted.addAll(this.nodeLogs);
        sorted.addAll(this.connectionLogs);
        sorted.addAll(this.partitionLogs);
        for (SystemLog systemLog : sorted) {
            sb.append(systemLog.getType().toString());
            sb.append(" - ");
            sb.append(new Date(systemLog.getDate()).toString());
            sb.append(" - ");
            sb.append(systemLog.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    public void logConnection(String str) {
        if (this.systemLogEnabled) {
            SystemObjectLog systemLog = new SystemObjectLog(str);
            systemLog.setType(SystemLog.Type.CONNECTION);
            this.connectionLogs.offer(systemLog);
        }
    }

    public void logPartition(String str) {
        if (this.systemLogEnabled) {
            SystemObjectLog systemLog = new SystemObjectLog(str);
            systemLog.setType(SystemLog.Type.PARTITION);
            this.partitionLogs.offer(systemLog);
        }
    }

    public void logNode(String str) {
        if (this.systemLogEnabled) {
            SystemObjectLog systemLog = new SystemObjectLog(str);
            systemLog.setType(SystemLog.Type.NODE);
            this.nodeLogs.offer(systemLog);
        }
    }

    public void logJoin(String str) {
        if (this.systemLogEnabled) {
            SystemObjectLog systemLog = new SystemObjectLog(str);
            systemLog.setType(SystemLog.Type.JOIN);
            this.joinLogs.offer(systemLog);
        }
    }

    public void logWarningConnection(String str) {
        if (this.systemLogEnabled) {
            SystemObjectLog systemLog = new SystemObjectLog(str);
            systemLog.setType(SystemLog.Type.CONNECTION);
            this.connectionLogs.offer(systemLog);
            this.warningLevelLogs.offer(systemLog);
        }
    }

    public void logWarningPartition(String str) {
        if (this.systemLogEnabled) {
            SystemObjectLog systemLog = new SystemObjectLog(str);
            systemLog.setType(SystemLog.Type.PARTITION);
            this.partitionLogs.offer(systemLog);
            this.warningLevelLogs.offer(systemLog);
        }
    }

    public void logWarningNode(String str) {
        if (this.systemLogEnabled) {
            SystemObjectLog systemLog = new SystemObjectLog(str);
            systemLog.setType(SystemLog.Type.NODE);
            this.nodeLogs.offer(systemLog);
            this.warningLevelLogs.offer(systemLog);
        }
    }

    public void logWarningJoin(String str) {
        if (this.systemLogEnabled) {
            SystemObjectLog systemLog = new SystemObjectLog(str);
            systemLog.setType(SystemLog.Type.JOIN);
            this.joinLogs.offer(systemLog);
            this.warningLevelLogs.offer(systemLog);
        }
    }
}

