/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.spi.ClientExecutionService;
import com.hazelcast.util.executor.PoolExecutorThreadFactory;
import com.hazelcast.util.executor.SingleExecutorThreadFactory;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public final class ClientExecutionServiceImpl
implements ClientExecutionService {
    private final ExecutorService executor;
    private final ScheduledExecutorService scheduledExecutor;

    public ClientExecutionServiceImpl(String name, ThreadGroup threadGroup, ClassLoader classLoader, int poolSize) {
        if (poolSize <= 0) {
            int cores = Runtime.getRuntime().availableProcessors();
            poolSize = cores * 5;
        }
        this.executor = Executors.newFixedThreadPool(poolSize, new PoolExecutorThreadFactory(threadGroup, name + ".cached-", classLoader));
        this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor(new SingleExecutorThreadFactory(threadGroup, classLoader, name + ".scheduled"));
    }

    @Override
    public void execute(Runnable command) {
        this.executor.execute(command);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.executor.submit(task);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.executor.submit(task);
    }

    @Override
    public ScheduledFuture<?> schedule(final Runnable command, long delay, TimeUnit unit) {
        return this.scheduledExecutor.schedule(new Runnable(){

            @Override
            public void run() {
                ClientExecutionServiceImpl.this.execute(command);
            }
        }, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(final Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.scheduledExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                ClientExecutionServiceImpl.this.execute(command);
            }
        }, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(final Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.scheduledExecutor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                ClientExecutionServiceImpl.this.execute(command);
            }
        }, initialDelay, period, unit);
    }

    public void shutdown() {
        this.scheduledExecutor.shutdownNow();
        this.executor.shutdownNow();
    }
}

