/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.collection.client.CollectionAddAllRequest;
import com.hazelcast.collection.client.CollectionAddListenerRequest;
import com.hazelcast.collection.client.CollectionAddRequest;
import com.hazelcast.collection.client.CollectionClearRequest;
import com.hazelcast.collection.client.CollectionCompareAndRemoveRequest;
import com.hazelcast.collection.client.CollectionContainsRequest;
import com.hazelcast.collection.client.CollectionGetAllRequest;
import com.hazelcast.collection.client.CollectionRemoveRequest;
import com.hazelcast.collection.client.CollectionRequest;
import com.hazelcast.collection.client.CollectionSizeRequest;
import com.hazelcast.core.ICollection;
import com.hazelcast.core.ItemEvent;
import com.hazelcast.core.ItemEventType;
import com.hazelcast.core.ItemListener;
import com.hazelcast.core.Member;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.impl.PortableItemEvent;
import com.hazelcast.spi.impl.SerializableCollection;
import com.hazelcast.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class AbstractClientCollectionProxy<E>
extends ClientProxy
implements ICollection<E> {
    protected final String partitionKey = this.getPartitionKey();

    public AbstractClientCollectionProxy(String serviceName, String name) {
        super(serviceName, name);
    }

    @Override
    public int size() {
        CollectionSizeRequest request = new CollectionSizeRequest(this.getName());
        Integer result = (Integer)this.invoke(request);
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        this.throwExceptionIfNull(o);
        CollectionContainsRequest request = new CollectionContainsRequest(this.getName(), this.toData(o));
        Boolean result = (Boolean)this.invoke(request);
        return result;
    }

    @Override
    public Iterator<E> iterator() {
        return this.getAll().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.getAll().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.getAll().toArray(a);
    }

    @Override
    public boolean add(E e) {
        this.throwExceptionIfNull(e);
        CollectionAddRequest request = new CollectionAddRequest(this.getName(), this.toData(e));
        Boolean result = (Boolean)this.invoke(request);
        return result;
    }

    @Override
    public boolean remove(Object o) {
        this.throwExceptionIfNull(o);
        CollectionRemoveRequest request = new CollectionRemoveRequest(this.getName(), this.toData(o));
        Boolean result = (Boolean)this.invoke(request);
        return result;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.throwExceptionIfNull(c);
        HashSet<Data> valueSet = new HashSet<Data>(c.size());
        for (Object o : c) {
            this.throwExceptionIfNull(o);
            valueSet.add(this.toData(o));
        }
        CollectionContainsRequest request = new CollectionContainsRequest(this.getName(), valueSet);
        Boolean result = (Boolean)this.invoke(request);
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.throwExceptionIfNull(c);
        ArrayList<Data> valueList = new ArrayList<Data>(c.size());
        for (E e : c) {
            this.throwExceptionIfNull(e);
            valueList.add(this.toData(e));
        }
        CollectionAddAllRequest request = new CollectionAddAllRequest(this.getName(), valueList);
        Boolean result = (Boolean)this.invoke(request);
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.compareAndRemove(false, c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.compareAndRemove(true, c);
    }

    private boolean compareAndRemove(boolean retain, Collection<?> c) {
        this.throwExceptionIfNull(c);
        HashSet<Data> valueSet = new HashSet<Data>();
        for (Object o : c) {
            this.throwExceptionIfNull(o);
            valueSet.add(this.toData(o));
        }
        CollectionCompareAndRemoveRequest request = new CollectionCompareAndRemoveRequest(this.getName(), valueSet, retain);
        Boolean result = (Boolean)this.invoke(request);
        return result;
    }

    @Override
    public void clear() {
        CollectionClearRequest request = new CollectionClearRequest(this.getName());
        this.invoke(request);
    }

    @Override
    public String addItemListener(final ItemListener<E> listener, final boolean includeValue) {
        CollectionAddListenerRequest request = new CollectionAddListenerRequest(this.getName(), includeValue);
        request.setServiceName(this.getServiceName());
        EventHandler<PortableItemEvent> eventHandler = new EventHandler<PortableItemEvent>(){

            @Override
            public void handle(PortableItemEvent portableItemEvent) {
                Object item = includeValue ? AbstractClientCollectionProxy.this.getContext().getSerializationService().toObject(portableItemEvent.getItem()) : null;
                MemberImpl member = AbstractClientCollectionProxy.this.getContext().getClusterService().getMember(portableItemEvent.getUuid());
                ItemEvent<Object> itemEvent = new ItemEvent<Object>(AbstractClientCollectionProxy.this.getName(), portableItemEvent.getEventType(), item, (Member)member);
                if (portableItemEvent.getEventType() == ItemEventType.ADDED) {
                    listener.itemAdded(itemEvent);
                } else {
                    listener.itemRemoved(itemEvent);
                }
            }
        };
        return this.listen(request, this.getPartitionKey(), eventHandler);
    }

    @Override
    public boolean removeItemListener(String registrationId) {
        return this.stopListening(registrationId);
    }

    @Override
    protected void onDestroy() {
    }

    protected <T> T invoke(Object req) {
        if (req instanceof CollectionRequest) {
            CollectionRequest request = (CollectionRequest)req;
            request.setServiceName(this.getServiceName());
        }
        try {
            return this.getContext().getInvocationService().invokeOnKeyOwner(req, this.getPartitionKey());
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    protected Data toData(Object o) {
        return this.getContext().getSerializationService().toData(o);
    }

    protected Object toObject(Data data) {
        return this.getContext().getSerializationService().toObject(data);
    }

    protected void throwExceptionIfNull(Object o) {
        if (o == null) {
            throw new NullPointerException("Object is null");
        }
    }

    private Collection<E> getAll() {
        CollectionGetAllRequest request = new CollectionGetAllRequest(this.getName());
        SerializableCollection result = (SerializableCollection)this.invoke(request);
        Collection<Data> collection = result.getCollection();
        ArrayList<Object> list = new ArrayList<Object>(collection.size());
        for (Data value : collection) {
            list.add(this.toObject(value));
        }
        return list;
    }
}

