/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map;

import com.hazelcast.cluster.ClusterService;
import com.hazelcast.concurrent.lock.LockService;
import com.hazelcast.concurrent.lock.LockStoreInfo;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MaxSizeConfig;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.EntryView;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.DataAwareEntryEvent;
import com.hazelcast.map.EntryEventFilter;
import com.hazelcast.map.EventData;
import com.hazelcast.map.MapContainer;
import com.hazelcast.map.MapInterceptor;
import com.hazelcast.map.MapStoreWrapper;
import com.hazelcast.map.NearCache;
import com.hazelcast.map.PartitionContainer;
import com.hazelcast.map.PartitionRecordStore;
import com.hazelcast.map.QueryEventFilter;
import com.hazelcast.map.QueryResult;
import com.hazelcast.map.RecordStore;
import com.hazelcast.map.SimpleEntryView;
import com.hazelcast.map.merge.HigherHitsMapMergePolicy;
import com.hazelcast.map.merge.LatestUpdateMapMergePolicy;
import com.hazelcast.map.merge.MapMergePolicy;
import com.hazelcast.map.merge.PassThroughMergePolicy;
import com.hazelcast.map.merge.PutIfAbsentMapMergePolicy;
import com.hazelcast.map.operation.ClearOperation;
import com.hazelcast.map.operation.DeleteOperation;
import com.hazelcast.map.operation.InvalidateNearCacheOperation;
import com.hazelcast.map.operation.MapReplicationOperation;
import com.hazelcast.map.operation.MergeOperation;
import com.hazelcast.map.operation.PostJoinMapOperation;
import com.hazelcast.map.proxy.MapProxyImpl;
import com.hazelcast.map.record.AbstractRecord;
import com.hazelcast.map.record.CachedDataRecord;
import com.hazelcast.map.record.DataRecord;
import com.hazelcast.map.record.ObjectRecord;
import com.hazelcast.map.record.Record;
import com.hazelcast.map.record.RecordStatistics;
import com.hazelcast.map.tx.TransactionalMapProxy;
import com.hazelcast.map.wan.MapReplicationRemove;
import com.hazelcast.map.wan.MapReplicationUpdate;
import com.hazelcast.monitor.impl.LocalMapStatsImpl;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.partition.MigrationEndpoint;
import com.hazelcast.partition.PartitionService;
import com.hazelcast.partition.PartitionView;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.IndexService;
import com.hazelcast.query.impl.QueryEntry;
import com.hazelcast.query.impl.QueryResultEntryImpl;
import com.hazelcast.spi.EventFilter;
import com.hazelcast.spi.EventPublishingService;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.Invocation;
import com.hazelcast.spi.ManagedService;
import com.hazelcast.spi.MigrationAwareService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.ObjectNamespace;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationAccessor;
import com.hazelcast.spi.PartitionMigrationEvent;
import com.hazelcast.spi.PartitionReplicationEvent;
import com.hazelcast.spi.PostJoinAwareService;
import com.hazelcast.spi.RemoteService;
import com.hazelcast.spi.ReplicationSupportingService;
import com.hazelcast.spi.SplitBrainHandlerService;
import com.hazelcast.spi.TransactionalService;
import com.hazelcast.spi.impl.EventServiceImpl;
import com.hazelcast.spi.impl.ResponseHandlerFactory;
import com.hazelcast.transaction.impl.TransactionSupport;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.wan.WanReplicationEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class MapService
implements ManagedService,
MigrationAwareService,
TransactionalService,
RemoteService,
EventPublishingService<EventData, EntryListener>,
PostJoinAwareService,
SplitBrainHandlerService,
ReplicationSupportingService {
    public static final String SERVICE_NAME = "hz:impl:mapService";
    private final ILogger logger;
    private final NodeEngine nodeEngine;
    private final PartitionContainer[] partitionContainers;
    private final ConcurrentMap<String, MapContainer> mapContainers = new ConcurrentHashMap<String, MapContainer>();
    private final ConcurrentMap<String, NearCache> nearCacheMap = new ConcurrentHashMap<String, NearCache>();
    private final AtomicReference<List<Integer>> ownedPartitions;
    private final Map<String, MapMergePolicy> mergePolicyMap;
    private final ConcurrentMap<String, LocalMapStatsImpl> statsMap = new ConcurrentHashMap<String, LocalMapStatsImpl>(1000);
    private final ConstructorFunction<String, LocalMapStatsImpl> localMapStatsConstructorFunction = new ConstructorFunction<String, LocalMapStatsImpl>(){

        @Override
        public LocalMapStatsImpl createNew(String key) {
            return new LocalMapStatsImpl();
        }
    };
    private final ConstructorFunction<String, MapContainer> mapConstructor = new ConstructorFunction<String, MapContainer>(){

        @Override
        public MapContainer createNew(String mapName) {
            return new MapContainer(mapName, MapService.this.nodeEngine.getConfig().getMapConfig(mapName), MapService.this);
        }
    };
    private final ConstructorFunction<String, NearCache> nearCacheConstructor = new ConstructorFunction<String, NearCache>(){

        @Override
        public NearCache createNew(String mapName) {
            return new NearCache(mapName, MapService.this);
        }
    };

    public MapService(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.logger = nodeEngine.getLogger(MapService.class.getName());
        this.partitionContainers = new PartitionContainer[nodeEngine.getPartitionService().getPartitionCount()];
        this.ownedPartitions = new AtomicReference();
        this.mergePolicyMap = new ConcurrentHashMap<String, MapMergePolicy>();
        this.mergePolicyMap.put(PutIfAbsentMapMergePolicy.class.getName(), new PutIfAbsentMapMergePolicy());
        this.mergePolicyMap.put(HigherHitsMapMergePolicy.class.getName(), new HigherHitsMapMergePolicy());
        this.mergePolicyMap.put(PassThroughMergePolicy.class.getName(), new PassThroughMergePolicy());
        this.mergePolicyMap.put(LatestUpdateMapMergePolicy.class.getName(), new LatestUpdateMapMergePolicy());
    }

    public LocalMapStatsImpl getLocalMapStatsImpl(String name) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.statsMap, name, this.localMapStatsConstructorFunction);
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        int partitionCount = nodeEngine.getPartitionService().getPartitionCount();
        for (int i = 0; i < partitionCount; ++i) {
            this.partitionContainers[i] = new PartitionContainer(this, i);
        }
        LockService lockService = (LockService)nodeEngine.getSharedService("hz:impl:lockService");
        if (lockService != null) {
            lockService.registerLockStoreConstructor(SERVICE_NAME, new ConstructorFunction<ObjectNamespace, LockStoreInfo>(){

                @Override
                public LockStoreInfo createNew(final ObjectNamespace key) {
                    final MapContainer mapContainer = MapService.this.getMapContainer(String.valueOf(key.getObjectId()));
                    return new LockStoreInfo(){

                        @Override
                        public ObjectNamespace getObjectNamespace() {
                            return key;
                        }

                        @Override
                        public int getBackupCount() {
                            return mapContainer.getBackupCount();
                        }

                        @Override
                        public int getAsyncBackupCount() {
                            return mapContainer.getAsyncBackupCount();
                        }
                    };
                }
            });
        }
        nodeEngine.getExecutionService().scheduleAtFixedRate(new MapEvictTask(), 1L, 1L, TimeUnit.SECONDS);
    }

    @Override
    public void reset() {
        PartitionContainer[] containers;
        for (PartitionContainer container : containers = this.partitionContainers) {
            if (container == null) continue;
            container.clear();
        }
        for (NearCache nearCache : this.nearCacheMap.values()) {
            nearCache.clear();
        }
    }

    @Override
    public void shutdown() {
        PartitionContainer[] containers;
        this.flushMaps();
        this.destroyMapStores();
        for (PartitionContainer container : containers = this.partitionContainers) {
            if (container == null) continue;
            container.clear();
        }
        for (NearCache nearCache : this.nearCacheMap.values()) {
            nearCache.clear();
        }
        this.nearCacheMap.clear();
        this.mapContainers.clear();
    }

    private void destroyMapStores() {
        for (MapContainer mapContainer : this.mapContainers.values()) {
            MapStoreWrapper store = mapContainer.getStore();
            if (store == null) continue;
            store.destroy();
        }
    }

    private void flushMaps() {
        for (PartitionContainer partitionContainer : this.partitionContainers) {
            for (String mapName : this.mapContainers.keySet()) {
                partitionContainer.getRecordStore(mapName).flush();
            }
        }
    }

    @Override
    public Operation getPostJoinOperation() {
        PostJoinMapOperation o = new PostJoinMapOperation();
        for (MapContainer mapContainer : this.mapContainers.values()) {
            o.addMapIndex(mapContainer);
            o.addMapInterceptors(mapContainer);
        }
        return o;
    }

    @Override
    public Runnable prepareMergeRunnable() {
        HashMap<MapContainer, Collection<Record>> recordMap = new HashMap<MapContainer, Collection<Record>>(this.mapContainers.size());
        for (MapContainer mapContainer : this.mapContainers.values()) {
            for (int i = 0; i < this.nodeEngine.getPartitionService().getPartitionCount(); ++i) {
                RecordStore recordStore = this.getPartitionContainer(i).getRecordStore(mapContainer.getName());
                if (this.nodeEngine.getPartitionService().getPartitionOwner(i).equals(this.nodeEngine.getClusterService().getThisAddress())) {
                    if (!recordMap.containsKey(mapContainer)) {
                        recordMap.put(mapContainer, new ArrayList());
                    }
                    ((Collection)recordMap.get(mapContainer)).addAll(recordStore.getRecords().values());
                }
                recordStore.reset();
            }
        }
        return new Merger(recordMap);
    }

    @Override
    public void onReplicationEvent(WanReplicationEvent replicationEvent) {
        Object eventObject = replicationEvent.getEventObject();
        if (eventObject instanceof MapReplicationUpdate) {
            MapReplicationUpdate replicationUpdate = (MapReplicationUpdate)eventObject;
            EntryView entryView = replicationUpdate.getEntryView();
            MapMergePolicy mergePolicy = replicationUpdate.getMergePolicy();
            MergeOperation operation = new MergeOperation(replicationUpdate.getMapName(), this.toData(entryView.getKey()), entryView, mergePolicy);
            try {
                int partitionId = this.nodeEngine.getPartitionService().getPartitionId(entryView.getKey());
                Invocation invocation = this.nodeEngine.getOperationService().createInvocationBuilder(SERVICE_NAME, (Operation)operation, partitionId).build();
                invocation.invoke().get();
            }
            catch (Throwable t) {
                ExceptionUtil.rethrow(t);
            }
        } else if (eventObject instanceof MapReplicationRemove) {
            MapReplicationRemove replicationRemove = (MapReplicationRemove)eventObject;
            DeleteOperation operation = new DeleteOperation(replicationRemove.getMapName(), this.toData(replicationRemove.getKey()));
            try {
                int partitionId = this.nodeEngine.getPartitionService().getPartitionId(replicationRemove.getKey());
                Invocation invocation = this.nodeEngine.getOperationService().createInvocationBuilder(SERVICE_NAME, (Operation)operation, partitionId).build();
                invocation.invoke().get();
            }
            catch (Throwable t) {
                ExceptionUtil.rethrow(t);
            }
        }
    }

    public MapMergePolicy getMergePolicy(String mergePolicyName) {
        MapMergePolicy mergePolicy = this.mergePolicyMap.get(mergePolicyName);
        if (mergePolicy == null && mergePolicyName != null) {
            try {
                mergePolicy = (MapMergePolicy)ClassLoaderUtil.newInstance(this.nodeEngine.getConfigClassLoader(), mergePolicyName);
                this.mergePolicyMap.put(mergePolicyName, mergePolicy);
            }
            catch (Exception e) {
                this.logger.severe(e);
                throw ExceptionUtil.rethrow(e);
            }
        }
        if (mergePolicy == null) {
            return this.mergePolicyMap.get(MapConfig.DEFAULT_MAP_MERGE_POLICY);
        }
        return mergePolicy;
    }

    public MapContainer getMapContainer(String mapName) {
        return ConcurrencyUtil.getOrPutSynchronized(this.mapContainers, mapName, this.mapContainers, this.mapConstructor);
    }

    public PartitionContainer getPartitionContainer(int partitionId) {
        return this.partitionContainers[partitionId];
    }

    public RecordStore getRecordStore(int partitionId, String mapName) {
        return this.getPartitionContainer(partitionId).getRecordStore(mapName);
    }

    public AtomicReference<List<Integer>> getOwnedPartitions() {
        if (this.ownedPartitions.get() == null) {
            this.ownedPartitions.set(this.nodeEngine.getPartitionService().getMemberPartitions(this.nodeEngine.getThisAddress()));
        }
        return this.ownedPartitions;
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent event) {
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event) {
        PartitionContainer container = this.partitionContainers[event.getPartitionId()];
        MapReplicationOperation operation = new MapReplicationOperation(container, event.getPartitionId(), event.getReplicaIndex());
        return operation.isEmpty() ? null : operation;
    }

    @Override
    public void commitMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.SOURCE) {
            this.migrateIndex(event);
            this.clearPartitionData(event.getPartitionId());
        } else {
            this.migrateIndex(event);
        }
        this.ownedPartitions.set(this.nodeEngine.getPartitionService().getMemberPartitions(this.nodeEngine.getThisAddress()));
    }

    private void migrateIndex(PartitionMigrationEvent event) {
        PartitionContainer container = this.partitionContainers[event.getPartitionId()];
        for (PartitionRecordStore recordStore : container.getMaps().values()) {
            MapContainer mapContainer = this.getMapContainer(recordStore.name);
            IndexService indexService = mapContainer.getIndexService();
            if (!indexService.hasIndex()) continue;
            for (Record record : recordStore.getRecords().values()) {
                if (event.getMigrationEndpoint() == MigrationEndpoint.SOURCE) {
                    indexService.removeEntryIndex(record.getKey());
                    continue;
                }
                Object value = record.getValue();
                if (value == null) continue;
                indexService.saveEntryIndex(new QueryEntry(this.getSerializationService(), record.getKey(), record.getKey(), value));
            }
        }
    }

    @Override
    public void rollbackMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.DESTINATION) {
            this.clearPartitionData(event.getPartitionId());
        }
        this.ownedPartitions.set(this.nodeEngine.getPartitionService().getMemberPartitions(this.nodeEngine.getThisAddress()));
    }

    private void clearPartitionData(int partitionId) {
        PartitionContainer container = this.partitionContainers[partitionId];
        if (container != null) {
            for (PartitionRecordStore mapPartition : container.getMaps().values()) {
                mapPartition.clear();
            }
            container.getMaps().clear();
        }
    }

    @Override
    public void clearPartitionReplica(int partitionId) {
        this.clearPartitionData(partitionId);
    }

    public Record createRecord(String name, Data dataKey, Object value, long ttl) {
        return this.createRecord(name, dataKey, value, ttl, true);
    }

    public Record createRecord(String name, Data dataKey, Object value, long ttl, boolean shouldSchedule) {
        AbstractRecord record;
        MapContainer mapContainer = this.getMapContainer(name);
        MapConfig.InMemoryFormat inMemoryFormat = mapContainer.getMapConfig().getInMemoryFormat();
        boolean statisticsEnabled = mapContainer.getMapConfig().isStatisticsEnabled();
        if (inMemoryFormat == MapConfig.InMemoryFormat.BINARY) {
            record = new DataRecord(dataKey, this.toData(value), statisticsEnabled);
        } else if (inMemoryFormat == MapConfig.InMemoryFormat.OBJECT) {
            record = new ObjectRecord(dataKey, this.toObject(value), statisticsEnabled);
        } else if (inMemoryFormat == MapConfig.InMemoryFormat.CACHED) {
            record = new CachedDataRecord(dataKey, this.toData(value), statisticsEnabled);
        } else {
            throw new IllegalArgumentException("Should not happen!");
        }
        if (shouldSchedule) {
            if (ttl < 0L && mapContainer.getMapConfig().getTimeToLiveSeconds() > 0) {
                this.scheduleTtlEviction(name, record, mapContainer.getMapConfig().getTimeToLiveSeconds() * 1000);
            }
            if (ttl > 0L) {
                this.scheduleTtlEviction(name, record, ttl);
            }
            if (mapContainer.getMapConfig().getMaxIdleSeconds() > 0) {
                this.scheduleIdleEviction(name, dataKey, mapContainer.getMapConfig().getMaxIdleSeconds() * 1000);
            }
        }
        return record;
    }

    public TransactionalMapProxy createTransactionalObject(Object id, TransactionSupport transaction) {
        return new TransactionalMapProxy(String.valueOf(id), this, this.nodeEngine, transaction);
    }

    private NearCache getNearCache(String mapName) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.nearCacheMap, mapName, this.nearCacheConstructor);
    }

    public void putNearCache(String mapName, Data key, Data value) {
        NearCache nearCache = this.getNearCache(mapName);
        nearCache.put(key, value);
    }

    public void invalidateNearCache(String mapName, Data key) {
        NearCache nearCache = this.getNearCache(mapName);
        nearCache.invalidate(key);
    }

    public void invalidateAllNearCaches(String mapName, Data key) {
        Collection<MemberImpl> members = this.nodeEngine.getClusterService().getMemberList();
        for (MemberImpl member : members) {
            try {
                if (member.localMember()) continue;
                InvalidateNearCacheOperation operation = new InvalidateNearCacheOperation(mapName, key);
                Invocation invocation = this.nodeEngine.getOperationService().createInvocationBuilder(SERVICE_NAME, (Operation)operation, member.getAddress()).build();
                invocation.invoke();
            }
            catch (Throwable throwable) {
                throw new HazelcastException(throwable);
            }
        }
        this.invalidateNearCache(mapName, key);
    }

    public Object getFromNearCache(String mapName, Data key) {
        NearCache nearCache = this.getNearCache(mapName);
        return nearCache.get(key);
    }

    public NodeEngine getNodeEngine() {
        return this.nodeEngine;
    }

    @Override
    public MapProxyImpl createDistributedObject(Object objectId) {
        String name = String.valueOf(objectId);
        return new MapProxyImpl(name, this, this.nodeEngine);
    }

    @Override
    public void destroyDistributedObject(Object objectId) {
        PartitionContainer[] containers;
        this.logger.warning("Destroying object: " + objectId);
        String name = String.valueOf(objectId);
        this.mapContainers.remove(name);
        for (PartitionContainer container : containers = this.partitionContainers) {
            if (container == null) continue;
            container.destroyMap(name);
        }
        this.nodeEngine.getEventService().deregisterAllListeners(SERVICE_NAME, name);
    }

    public String addInterceptor(String mapName, MapInterceptor interceptor) {
        return this.getMapContainer(mapName).addInterceptor(interceptor);
    }

    public void removeInterceptor(String mapName, String id) {
        this.getMapContainer(mapName).removeInterceptor(id);
    }

    public Object interceptGet(String mapName, Object value) {
        List<MapInterceptor> interceptors = this.getMapContainer(mapName).getInterceptors();
        Object result = null;
        if (!interceptors.isEmpty()) {
            result = this.toObject(value);
            for (MapInterceptor interceptor : interceptors) {
                Object temp = interceptor.interceptGet(result);
                if (temp == null) continue;
                result = temp;
            }
        }
        return result == null ? value : result;
    }

    public void interceptAfterGet(String mapName, Object value) {
        List<MapInterceptor> interceptors = this.getMapContainer(mapName).getInterceptors();
        if (!interceptors.isEmpty()) {
            value = this.toObject(value);
            for (MapInterceptor interceptor : interceptors) {
                interceptor.afterGet(value);
            }
        }
    }

    public Object interceptPut(String mapName, Object oldValue, Object newValue) {
        List<MapInterceptor> interceptors = this.getMapContainer(mapName).getInterceptors();
        Object result = null;
        if (!interceptors.isEmpty()) {
            result = this.toObject(newValue);
            oldValue = this.toObject(oldValue);
            for (MapInterceptor interceptor : interceptors) {
                Object temp = interceptor.interceptPut(oldValue, result);
                if (temp == null) continue;
                result = temp;
            }
        }
        return result == null ? newValue : result;
    }

    public void interceptAfterPut(String mapName, Object newValue) {
        List<MapInterceptor> interceptors = this.getMapContainer(mapName).getInterceptors();
        if (!interceptors.isEmpty()) {
            newValue = this.toObject(newValue);
            for (MapInterceptor interceptor : interceptors) {
                interceptor.afterPut(newValue);
            }
        }
    }

    public Object interceptRemove(String mapName, Object value) {
        List<MapInterceptor> interceptors = this.getMapContainer(mapName).getInterceptors();
        Object result = null;
        if (!interceptors.isEmpty()) {
            result = this.toObject(value);
            for (MapInterceptor interceptor : interceptors) {
                Object temp = interceptor.interceptRemove(result);
                if (temp == null) continue;
                result = temp;
            }
        }
        return result == null ? value : result;
    }

    public void interceptAfterRemove(String mapName, Object value) {
        List<MapInterceptor> interceptors = this.getMapContainer(mapName).getInterceptors();
        if (!interceptors.isEmpty()) {
            for (MapInterceptor interceptor : interceptors) {
                value = this.toObject(value);
                interceptor.afterRemove(value);
            }
        }
    }

    public void publishWanReplicationUpdate(String mapName, EntryView entryView) {
        MapContainer mapContainer = this.getMapContainer(mapName);
        MapReplicationUpdate replicationEvent = new MapReplicationUpdate(mapName, mapContainer.getWanMergePolicy(), entryView);
        mapContainer.getWanReplicationPublisher().publishReplicationEvent(SERVICE_NAME, replicationEvent);
    }

    public void publishWanReplicationRemove(String mapName, Data key, long removeTime) {
        MapContainer mapContainer = this.getMapContainer(mapName);
        MapReplicationRemove replicationEvent = new MapReplicationRemove(mapName, key, removeTime);
        mapContainer.getWanReplicationPublisher().publishReplicationEvent(SERVICE_NAME, replicationEvent);
    }

    public void publishEvent(Address caller, String mapName, EntryEventType eventType, Data dataKey, Data dataOldValue, Data dataValue) {
        Collection<EventRegistration> candidates = this.nodeEngine.getEventService().getRegistrations(SERVICE_NAME, mapName);
        HashSet<EventRegistration> registrationsWithValue = new HashSet<EventRegistration>();
        HashSet<EventRegistration> registrationsWithoutValue = new HashSet<EventRegistration>();
        if (candidates.isEmpty()) {
            return;
        }
        Object key = null;
        Object value = null;
        Object oldValue = null;
        for (EventRegistration candidate : candidates) {
            EventFilter filter = candidate.getFilter();
            if (filter instanceof EventServiceImpl.EmptyFilter) {
                registrationsWithValue.add(candidate);
                continue;
            }
            if (filter instanceof QueryEventFilter) {
                Object testValue = eventType == EntryEventType.REMOVED || eventType == EntryEventType.EVICTED ? (oldValue = oldValue != null ? oldValue : this.toObject(dataOldValue)) : (value = value != null ? value : this.toObject(dataValue));
                Object object = key = key != null ? key : this.toObject(dataKey);
                QueryEventFilter queryEventFilter = (QueryEventFilter)filter;
                QueryEntry entry = new QueryEntry(this.getSerializationService(), dataKey, key, testValue);
                if (!queryEventFilter.eval(entry)) continue;
                if (queryEventFilter.isIncludeValue()) {
                    registrationsWithValue.add(candidate);
                    continue;
                }
                registrationsWithoutValue.add(candidate);
                continue;
            }
            if (!filter.eval(dataKey)) continue;
            EntryEventFilter eventFilter = (EntryEventFilter)filter;
            if (eventFilter.isIncludeValue()) {
                registrationsWithValue.add(candidate);
                continue;
            }
            registrationsWithoutValue.add(candidate);
        }
        if (registrationsWithValue.isEmpty() && registrationsWithoutValue.isEmpty()) {
            return;
        }
        String source = this.nodeEngine.getThisAddress().toString();
        if (eventType == EntryEventType.REMOVED || eventType == EntryEventType.EVICTED) {
            dataValue = dataValue != null ? dataValue : dataOldValue;
        }
        EventData event = new EventData(source, mapName, caller, dataKey, dataValue, dataOldValue, eventType.getType());
        int orderKey = dataKey.hashCode();
        this.nodeEngine.getEventService().publishEvent(SERVICE_NAME, registrationsWithValue, (Object)event, orderKey);
        this.nodeEngine.getEventService().publishEvent(SERVICE_NAME, registrationsWithoutValue, event.cloneWithoutValues(), orderKey);
    }

    public String addLocalEventListener(EntryListener entryListener, String mapName) {
        EventRegistration registration = this.nodeEngine.getEventService().registerLocalListener(SERVICE_NAME, mapName, entryListener);
        return registration.getId();
    }

    public String addEventListener(EntryListener entryListener, EventFilter eventFilter, String mapName) {
        EventRegistration registration = this.nodeEngine.getEventService().registerListener(SERVICE_NAME, mapName, eventFilter, entryListener);
        return registration.getId();
    }

    public boolean removeEventListener(String mapName, String registrationId) {
        return this.nodeEngine.getEventService().deregisterListener(SERVICE_NAME, mapName, registrationId);
    }

    public Object toObject(Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof Data) {
            return this.nodeEngine.toObject(data);
        }
        return data;
    }

    public Data toData(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Data) {
            return (Data)object;
        }
        return this.nodeEngine.toData(object);
    }

    public boolean compare(String mapName, Object value1, Object value2) {
        if (value1 == null && value2 == null) {
            return true;
        }
        if (value1 == null && value2 != null) {
            return false;
        }
        if (value1 != null && value2 == null) {
            return false;
        }
        MapContainer mapContainer = this.getMapContainer(mapName);
        if (mapContainer.getMapConfig().getInMemoryFormat().equals((Object)MapConfig.InMemoryFormat.BINARY)) {
            return this.toData(value1).equals(this.toData(value2));
        }
        if (mapContainer.getMapConfig().getInMemoryFormat().equals((Object)MapConfig.InMemoryFormat.OBJECT)) {
            return this.toObject(value1).equals(this.toObject(value2));
        }
        return value1.equals(value2);
    }

    @Override
    public void dispatchEvent(EventData eventData, EntryListener listener) {
        MemberImpl member = this.nodeEngine.getClusterService().getMember(eventData.getCaller());
        DataAwareEntryEvent event = new DataAwareEntryEvent(member, eventData.getEventType(), eventData.getSource(), eventData.getDataKey(), eventData.getDataNewValue(), eventData.getDataOldValue(), this.getSerializationService());
        switch (event.getEventType()) {
            case ADDED: {
                listener.entryAdded(event);
                break;
            }
            case EVICTED: {
                listener.entryEvicted(event);
                break;
            }
            case UPDATED: {
                listener.entryUpdated(event);
                break;
            }
            case REMOVED: {
                listener.entryRemoved(event);
            }
        }
        MapContainer mapContainer = this.getMapContainer(eventData.getMapName());
        if (mapContainer.getMapConfig().isStatisticsEnabled()) {
            this.getLocalMapStatsImpl(eventData.getMapName()).incrementReceivedEvents();
        }
    }

    public void scheduleIdleEviction(String mapName, Data key, long delay) {
        this.getMapContainer(mapName).getIdleEvictionScheduler().schedule(delay, key, null);
    }

    public void scheduleTtlEviction(String mapName, Record record, long delay) {
        if (record.getStatistics() != null) {
            record.getStatistics().setExpirationTime(Clock.currentTimeMillis() + delay);
        }
        this.getMapContainer(mapName).getTtlEvictionScheduler().schedule(delay, this.toData(record.getKey()), null);
    }

    public void scheduleMapStoreWrite(String mapName, Data key, Object value, long delay) {
        this.getMapContainer(mapName).getMapStoreWriteScheduler().schedule(delay, key, value);
    }

    public void scheduleMapStoreDelete(String mapName, Data key, long delay) {
        this.getMapContainer(mapName).getMapStoreDeleteScheduler().schedule(delay, key, null);
    }

    public SerializationService getSerializationService() {
        return this.nodeEngine.getSerializationService();
    }

    public QueryResult queryOnPartition(String mapName, Predicate predicate, int partitionId) {
        QueryResult result = new QueryResult();
        PartitionContainer container = this.getPartitionContainer(partitionId);
        RecordStore recordStore = container.getRecordStore(mapName);
        Map<Data, Record> records = recordStore.getRecords();
        SerializationService serializationService = this.nodeEngine.getSerializationService();
        for (Record record : records.values()) {
            QueryEntry queryEntry;
            Data key = record.getKey();
            Object value = record.getValue();
            if (value == null || !predicate.apply(queryEntry = new QueryEntry(serializationService, key, key, value))) continue;
            result.add(new QueryResultEntryImpl(key, key, queryEntry.getValueData()));
        }
        return result;
    }

    public LocalMapStatsImpl createLocalMapStats(String mapName) {
        MapContainer mapContainer = this.getMapContainer(mapName);
        LocalMapStatsImpl localMapStats = this.getLocalMapStatsImpl(mapName);
        if (!mapContainer.getMapConfig().isStatisticsEnabled()) {
            return localMapStats;
        }
        long ownedEntryCount = 0L;
        long backupEntryCount = 0L;
        long dirtyCount = 0L;
        long ownedEntryMemoryCost = 0L;
        long backupEntryMemoryCost = 0L;
        long hits = 0L;
        long lockedEntryCount = 0L;
        int backupCount = mapContainer.getTotalBackupCount();
        ClusterService clusterService = this.nodeEngine.getClusterService();
        PartitionService partitionService = this.nodeEngine.getPartitionService();
        Address thisAddress = clusterService.getThisAddress();
        for (int partitionId = 0; partitionId < partitionService.getPartitionCount(); ++partitionId) {
            PartitionView partition = partitionService.getPartition(partitionId);
            if (partition.getOwner().equals(thisAddress)) {
                PartitionContainer partitionContainer = this.getPartitionContainer(partitionId);
                RecordStore recordStore = partitionContainer.getRecordStore(mapName);
                Map<Data, Record> records = recordStore.getRecords();
                for (Record record : records.values()) {
                    RecordStatistics stats = record.getStatistics();
                    ++ownedEntryCount;
                    ownedEntryMemoryCost += record.getCost();
                    localMapStats.setLastAccessTime(stats.getLastAccessTime());
                    hits += (long)stats.getHits();
                    if (!recordStore.isLocked(record.getKey())) continue;
                    ++lockedEntryCount;
                }
                continue;
            }
            for (int replica = 1; replica <= backupCount; ++replica) {
                Address replicaAddress = partition.getReplicaAddress(replica);
                int tryCount = 30;
                while (replicaAddress == null && clusterService.getSize() > backupCount && tryCount-- > 0) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        throw ExceptionUtil.rethrow(e);
                    }
                    replicaAddress = partition.getReplicaAddress(replica);
                }
                if (replicaAddress != null && replicaAddress.equals(thisAddress)) {
                    PartitionContainer partitionContainer = this.getPartitionContainer(partitionId);
                    RecordStore recordStore = partitionContainer.getRecordStore(mapName);
                    Map<Data, Record> records = recordStore.getRecords();
                    for (Record record : records.values()) {
                        ++backupEntryCount;
                        backupEntryMemoryCost += record.getCost();
                    }
                    continue;
                }
                if (replicaAddress != null || clusterService.getSize() <= backupCount) continue;
                this.logger.warning("Partition: " + partition + ", replica: " + replica + " has no owner!");
            }
        }
        if (mapContainer.getMapStoreWriteScheduler() != null && mapContainer.getMapStoreDeleteScheduler() != null) {
            dirtyCount = mapContainer.getMapStoreWriteScheduler().size() + mapContainer.getMapStoreDeleteScheduler().size();
        }
        localMapStats.setBackupCount(backupCount);
        localMapStats.setDirtyEntryCount(MapService.zeroOrPositive(dirtyCount));
        localMapStats.setLockedEntryCount(MapService.zeroOrPositive(lockedEntryCount));
        localMapStats.setHits(MapService.zeroOrPositive(hits));
        localMapStats.setOwnedEntryCount(MapService.zeroOrPositive(ownedEntryCount));
        localMapStats.setBackupEntryCount(MapService.zeroOrPositive(backupEntryCount));
        localMapStats.setOwnedEntryMemoryCost(MapService.zeroOrPositive(ownedEntryMemoryCost));
        localMapStats.setBackupEntryMemoryCost(MapService.zeroOrPositive(backupEntryMemoryCost));
        return localMapStats;
    }

    static long zeroOrPositive(long value) {
        return value > 0L ? value : 0L;
    }

    private class MapEvictTask
    implements Runnable {
        private MapEvictTask() {
        }

        @Override
        public void run() {
            for (MapContainer mapContainer : MapService.this.mapContainers.values()) {
                boolean check;
                MapConfig.EvictionPolicy evictionPolicy = mapContainer.getMapConfig().getEvictionPolicy();
                MaxSizeConfig maxSizeConfig = mapContainer.getMapConfig().getMaxSizeConfig();
                if (evictionPolicy == MapConfig.EvictionPolicy.NONE || maxSizeConfig.getSize() <= 0 || !(check = this.checkLimits(mapContainer))) continue;
                this.evictMap(mapContainer);
            }
        }

        private void evictMap(MapContainer mapContainer) {
            MapConfig mapConfig = mapContainer.getMapConfig();
            MapConfig.EvictionPolicy evictionPolicy = mapConfig.getEvictionPolicy();
            Comparator<AbstractRecord> comparator = null;
            if (evictionPolicy == MapConfig.EvictionPolicy.LRU) {
                comparator = new Comparator<AbstractRecord>(){

                    @Override
                    public int compare(AbstractRecord o1, AbstractRecord o2) {
                        return o1.getLastAccessTime().compareTo(o2.getLastAccessTime());
                    }
                };
            } else if (evictionPolicy == MapConfig.EvictionPolicy.LFU) {
                comparator = new Comparator<AbstractRecord>(){

                    @Override
                    public int compare(AbstractRecord o1, AbstractRecord o2) {
                        return o1.getHits().compareTo(o2.getHits());
                    }
                };
            }
            int evictionPercentage = mapConfig.getEvictionPercentage();
            int memberCount = MapService.this.nodeEngine.getClusterService().getMembers().size();
            int targetSizePerPartition = -1;
            int maxPartitionSize = 0;
            MaxSizeConfig.MaxSizePolicy maxSizePolicy = mapConfig.getMaxSizeConfig().getMaxSizePolicy();
            if (maxSizePolicy == MaxSizeConfig.MaxSizePolicy.PER_NODE) {
                maxPartitionSize = mapConfig.getMaxSizeConfig().getSize() * memberCount / MapService.this.nodeEngine.getPartitionService().getPartitionCount();
                targetSizePerPartition = Double.valueOf((double)maxPartitionSize * ((double)(100 - evictionPercentage) / 100.0)).intValue();
            } else if (maxSizePolicy == MaxSizeConfig.MaxSizePolicy.PER_PARTITION) {
                maxPartitionSize = mapConfig.getMaxSizeConfig().getSize();
                targetSizePerPartition = Double.valueOf((double)maxPartitionSize * ((double)(100 - evictionPercentage) / 100.0)).intValue();
            }
            for (int i = 0; i < 8; ++i) {
                MapService.this.nodeEngine.getExecutionService().execute("hz:map-evict", new EvictRunner(i, mapConfig, targetSizePerPartition, comparator, evictionPercentage));
            }
        }

        private boolean checkLimits(MapContainer mapContainer) {
            MaxSizeConfig maxSizeConfig = mapContainer.getMapConfig().getMaxSizeConfig();
            MaxSizeConfig.MaxSizePolicy maxSizePolicy = maxSizeConfig.getMaxSizePolicy();
            String mapName = mapContainer.getName();
            int maxSize = maxSizeConfig.getSize() * 95 / 100;
            if (maxSizePolicy == MaxSizeConfig.MaxSizePolicy.PER_NODE || maxSizePolicy == MaxSizeConfig.MaxSizePolicy.PER_PARTITION) {
                int totalSize = 0;
                for (int i = 0; i < MapService.this.nodeEngine.getPartitionService().getPartitionCount(); ++i) {
                    Address owner = MapService.this.nodeEngine.getPartitionService().getPartitionOwner(i);
                    if (!MapService.this.nodeEngine.getThisAddress().equals(owner)) continue;
                    PartitionContainer container = MapService.this.partitionContainers[i];
                    if (container == null) {
                        return false;
                    }
                    int size = container.getRecordStore(mapName).getRecords().size();
                    if (maxSizePolicy == MaxSizeConfig.MaxSizePolicy.PER_PARTITION) {
                        if (size < maxSize) continue;
                        return true;
                    }
                    totalSize += size;
                }
                return maxSizePolicy == MaxSizeConfig.MaxSizePolicy.PER_NODE && totalSize >= maxSize;
            }
            if (maxSizePolicy == MaxSizeConfig.MaxSizePolicy.USED_HEAP_SIZE || maxSizePolicy == MaxSizeConfig.MaxSizePolicy.USED_HEAP_PERCENTAGE) {
                long total = Runtime.getRuntime().totalMemory();
                long used = total - Runtime.getRuntime().freeMemory();
                if (maxSizePolicy == MaxSizeConfig.MaxSizePolicy.USED_HEAP_SIZE) {
                    return (long)maxSize > used / 1024L / 1024L;
                }
                return (long)maxSize > used / total;
            }
            return false;
        }

        private class EvictRunner
        implements Runnable {
            final int mod;
            String mapName;
            int targetSizePerPartition;
            Comparator comparator;
            MaxSizeConfig.MaxSizePolicy maxSizePolicy;
            int evictionPercentage;

            private EvictRunner(int mod, MapConfig mapConfig, int targetSizePerPartition, Comparator comparator, int evictionPercentage) {
                this.mod = mod;
                this.mapName = mapConfig.getName();
                this.targetSizePerPartition = targetSizePerPartition;
                this.evictionPercentage = evictionPercentage;
                this.comparator = comparator;
                this.maxSizePolicy = mapConfig.getMaxSizeConfig().getMaxSizePolicy();
            }

            @Override
            public void run() {
                for (int i = 0; i < MapService.this.nodeEngine.getPartitionService().getPartitionCount(); ++i) {
                    if (i % 8 != this.mod) continue;
                    Address owner = MapService.this.nodeEngine.getPartitionService().getPartitionOwner(i);
                    if (!MapService.this.nodeEngine.getThisAddress().equals(owner)) continue;
                    PartitionContainer pc = MapService.this.partitionContainers[i];
                    RecordStore recordStore = pc.getRecordStore(this.mapName);
                    TreeSet<Record> sortedRecords = new TreeSet<Record>(this.comparator);
                    sortedRecords.addAll(recordStore.getRecords().values());
                    int evictSize = this.maxSizePolicy == MaxSizeConfig.MaxSizePolicy.PER_NODE || this.maxSizePolicy == MaxSizeConfig.MaxSizePolicy.PER_PARTITION ? Math.max(sortedRecords.size() - this.targetSizePerPartition, sortedRecords.size() * this.evictionPercentage / 100 + 1) : sortedRecords.size() * this.evictionPercentage / 100;
                    if (evictSize == 0) continue;
                    HashSet<Record> recordSet = new HashSet<Record>();
                    HashSet<Data> keySet = new HashSet<Data>();
                    Iterator iterator = sortedRecords.iterator();
                    while (iterator.hasNext() && evictSize-- > 0) {
                        Record rec = (Record)iterator.next();
                        recordSet.add(rec);
                        keySet.add(rec.getKey());
                    }
                    ClearOperation clearOperation = new ClearOperation(this.mapName, keySet);
                    clearOperation.setNodeEngine(MapService.this.nodeEngine);
                    clearOperation.setServiceName(MapService.SERVICE_NAME);
                    clearOperation.setResponseHandler(ResponseHandlerFactory.createEmptyResponseHandler());
                    clearOperation.setPartitionId(i);
                    OperationAccessor.setCallerAddress(clearOperation, MapService.this.nodeEngine.getThisAddress());
                    MapService.this.nodeEngine.getOperationService().executeOperation(clearOperation);
                    for (Record record : recordSet) {
                        MapService.this.publishEvent(MapService.this.nodeEngine.getThisAddress(), this.mapName, EntryEventType.EVICTED, record.getKey(), MapService.this.toData(record.getValue()), null);
                    }
                }
            }
        }
    }

    public class Merger
    implements Runnable {
        Map<MapContainer, Collection<Record>> recordMap;

        public Merger(Map<MapContainer, Collection<Record>> recordMap) {
            this.recordMap = recordMap;
        }

        @Override
        public void run() {
            for (final MapContainer mapContainer : this.recordMap.keySet()) {
                Collection<Record> recordList = this.recordMap.get(mapContainer);
                String mergePolicyName = mapContainer.getMapConfig().getMergePolicy();
                MapMergePolicy mergePolicy = MapService.this.getMergePolicy(mergePolicyName);
                for (final Record record : recordList) {
                    final MapMergePolicy finalMergePolicy = mergePolicy;
                    MapService.this.nodeEngine.getExecutionService().submit("hz:map-merge", new Runnable(){

                        @Override
                        public void run() {
                            SimpleEntryView<Data, Data> entryView = new SimpleEntryView<Data, Data>(record.getKey(), MapService.this.toData(record.getValue()), record);
                            MergeOperation operation = new MergeOperation(mapContainer.getName(), record.getKey(), entryView, finalMergePolicy);
                            try {
                                int partitionId = MapService.this.nodeEngine.getPartitionService().getPartitionId(record.getKey());
                                Invocation invocation = MapService.this.nodeEngine.getOperationService().createInvocationBuilder(MapService.SERVICE_NAME, (Operation)operation, partitionId).build();
                                invocation.invoke().get();
                            }
                            catch (Throwable t) {
                                ExceptionUtil.rethrow(t);
                            }
                        }
                    });
                }
            }
        }
    }
}

