/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.queue.tx;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.queue.tx.TransactionLogKey;
import com.hazelcast.queue.tx.TxnPollOperation;
import com.hazelcast.queue.tx.TxnPrepareOperation;
import com.hazelcast.queue.tx.TxnRollbackOperation;
import com.hazelcast.spi.Invocation;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.transaction.impl.KeyAwareTransactionLog;
import com.hazelcast.util.ExceptionUtil;
import java.io.IOException;
import java.util.concurrent.Future;

public class QueueTransactionLog
implements KeyAwareTransactionLog {
    long itemId;
    String name;
    Operation op;
    int partitionId;

    public QueueTransactionLog() {
    }

    public QueueTransactionLog(long itemId, String name, int partitionId, Operation op) {
        this.itemId = itemId;
        this.name = name;
        this.partitionId = partitionId;
        this.op = op;
    }

    @Override
    public Future prepare(NodeEngine nodeEngine) {
        boolean pollOperation = this.op instanceof TxnPollOperation;
        TxnPrepareOperation operation = new TxnPrepareOperation(this.name, this.itemId, pollOperation);
        try {
            Invocation invocation = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:queueService", (Operation)operation, this.partitionId).build();
            return invocation.invoke();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    public Future commit(NodeEngine nodeEngine) {
        try {
            Invocation invocation = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:queueService", this.op, this.partitionId).build();
            return invocation.invoke();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    public Future rollback(NodeEngine nodeEngine) {
        boolean pollOperation = this.op instanceof TxnPollOperation;
        TxnRollbackOperation operation = new TxnRollbackOperation(this.name, this.itemId, pollOperation);
        try {
            Invocation invocation = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:queueService", (Operation)operation, this.partitionId).build();
            return invocation.invoke();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.itemId);
        out.writeUTF(this.name);
        out.writeInt(this.partitionId);
        out.writeObject(this.op);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.itemId = in.readLong();
        this.name = in.readUTF();
        this.partitionId = in.readInt();
        this.op = (Operation)in.readObject();
    }

    @Override
    public Object getKey() {
        return new TransactionLogKey(this.itemId, this.name);
    }
}

