/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.collection.operations.client.AddEntryListenerRequest;
import com.hazelcast.collection.operations.client.ClearRequest;
import com.hazelcast.collection.operations.client.CollectionDestroyRequest;
import com.hazelcast.collection.operations.client.ContainsEntryRequest;
import com.hazelcast.collection.operations.client.CountRequest;
import com.hazelcast.collection.operations.client.EntrySetRequest;
import com.hazelcast.collection.operations.client.GetAllRequest;
import com.hazelcast.collection.operations.client.KeySetRequest;
import com.hazelcast.collection.operations.client.MultiMapIsLockedRequest;
import com.hazelcast.collection.operations.client.MultiMapLockRequest;
import com.hazelcast.collection.operations.client.MultiMapUnlockRequest;
import com.hazelcast.collection.operations.client.PortableEntrySetResponse;
import com.hazelcast.collection.operations.client.PutRequest;
import com.hazelcast.collection.operations.client.RemoveAllRequest;
import com.hazelcast.collection.operations.client.RemoveRequest;
import com.hazelcast.collection.operations.client.SizeRequest;
import com.hazelcast.collection.operations.client.ValuesRequest;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.MultiMap;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.monitor.LocalMultiMapStats;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.spi.impl.PortableCollection;
import com.hazelcast.spi.impl.PortableEntryEvent;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.ThreadUtil;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class ClientMultiMapProxy<K, V>
extends ClientProxy
implements MultiMap<K, V> {
    final CollectionProxyId proxyId;

    public ClientMultiMapProxy(String serviceName, CollectionProxyId objectId) {
        super(serviceName, objectId);
        this.proxyId = objectId;
    }

    @Override
    public boolean put(K key, V value) {
        Data keyData = this.getSerializationService().toData(key);
        Data valueData = this.getSerializationService().toData(value);
        PutRequest request = new PutRequest(this.proxyId, keyData, valueData, -1, ThreadUtil.getThreadId());
        Boolean result = (Boolean)this.invoke(request, keyData);
        return result;
    }

    @Override
    public Collection<V> get(K key) {
        Data keyData = this.getSerializationService().toData(key);
        GetAllRequest request = new GetAllRequest(this.proxyId, keyData);
        PortableCollection result = (PortableCollection)this.invoke(request, keyData);
        return this.toObjectCollection(result, true);
    }

    @Override
    public boolean remove(Object key, Object value) {
        Data keyData = this.getSerializationService().toData(key);
        Data valueData = this.getSerializationService().toData(value);
        RemoveRequest request = new RemoveRequest(this.proxyId, keyData, valueData, ThreadUtil.getThreadId());
        Boolean result = (Boolean)this.invoke(request, keyData);
        return result;
    }

    @Override
    public Collection<V> remove(Object key) {
        Data keyData = this.getSerializationService().toData(key);
        RemoveAllRequest request = new RemoveAllRequest(this.proxyId, keyData, ThreadUtil.getThreadId());
        PortableCollection result = (PortableCollection)this.invoke(request, keyData);
        return this.toObjectCollection(result, true);
    }

    @Override
    public Set<K> localKeySet() {
        throw new UnsupportedOperationException("Locality for client is ambiguous");
    }

    @Override
    public Set<K> keySet() {
        KeySetRequest request = new KeySetRequest(this.proxyId);
        PortableCollection result = (PortableCollection)this.invoke(request);
        return (Set)this.toObjectCollection(result, false);
    }

    @Override
    public Collection<V> values() {
        ValuesRequest request = new ValuesRequest(this.proxyId);
        PortableCollection result = (PortableCollection)this.invoke(request);
        return this.toObjectCollection(result, true);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySetRequest request = new EntrySetRequest(this.proxyId);
        PortableEntrySetResponse result = (PortableEntrySetResponse)this.invoke(request);
        Set<Map.Entry> dataEntrySet = result.getEntrySet();
        HashSet<Map.Entry<K, V>> entrySet = new HashSet<Map.Entry<K, V>>(dataEntrySet.size());
        for (Map.Entry entry : dataEntrySet) {
            Object key = this.getSerializationService().toObject((Data)entry.getKey());
            Object val = this.getSerializationService().toObject((Data)entry.getValue());
            entrySet.add(new AbstractMap.SimpleEntry<Object, Object>(key, val));
        }
        return entrySet;
    }

    @Override
    public boolean containsKey(K key) {
        Data keyData = this.getSerializationService().toData(key);
        ContainsEntryRequest request = new ContainsEntryRequest(this.proxyId, keyData, null);
        Boolean result = (Boolean)this.invoke(request, keyData);
        return result;
    }

    @Override
    public boolean containsValue(Object value) {
        Data valueData = this.getSerializationService().toData(value);
        ContainsEntryRequest request = new ContainsEntryRequest(this.proxyId, null, valueData);
        Boolean result = (Boolean)this.invoke(request);
        return result;
    }

    @Override
    public boolean containsEntry(K key, V value) {
        Data keyData = this.getSerializationService().toData(key);
        Data valueData = this.getSerializationService().toData(value);
        ContainsEntryRequest request = new ContainsEntryRequest(this.proxyId, keyData, valueData);
        Boolean result = (Boolean)this.invoke(request, keyData);
        return result;
    }

    @Override
    public int size() {
        SizeRequest request = new SizeRequest(this.proxyId);
        Integer result = (Integer)this.invoke(request);
        return result;
    }

    @Override
    public void clear() {
        ClearRequest request = new ClearRequest(this.proxyId);
        this.invoke(request);
    }

    @Override
    public int valueCount(K key) {
        Data keyData = this.getSerializationService().toData(key);
        CountRequest request = new CountRequest(this.proxyId, keyData);
        Integer result = (Integer)this.invoke(request, keyData);
        return result;
    }

    @Override
    public String addLocalEntryListener(EntryListener<K, V> listener) {
        throw new UnsupportedOperationException("Locality for client is ambiguous");
    }

    @Override
    public String addEntryListener(EntryListener<K, V> listener, boolean includeValue) {
        AddEntryListenerRequest request = new AddEntryListenerRequest(this.proxyId, null, includeValue);
        EventHandler<PortableEntryEvent> handler = this.createHandler(listener, includeValue);
        return this.listen(request, handler);
    }

    @Override
    public boolean removeEntryListener(String registrationId) {
        return this.stopListening(registrationId);
    }

    @Override
    public String addEntryListener(EntryListener<K, V> listener, K key, boolean includeValue) {
        Data keyData = this.getSerializationService().toData(key);
        AddEntryListenerRequest request = new AddEntryListenerRequest(this.proxyId, keyData, includeValue);
        EventHandler<PortableEntryEvent> handler = this.createHandler(listener, includeValue);
        return this.listen(request, keyData, handler);
    }

    @Override
    public void lock(K key) {
        Data keyData = this.getSerializationService().toData(key);
        MultiMapLockRequest request = new MultiMapLockRequest(keyData, ThreadUtil.getThreadId(), this.proxyId);
        this.invoke(request, keyData);
    }

    @Override
    public void lock(K key, long leaseTime, TimeUnit timeUnit) {
        Data keyData = this.getSerializationService().toData(key);
        MultiMapLockRequest request = new MultiMapLockRequest(keyData, ThreadUtil.getThreadId(), this.getTimeInMillis(leaseTime, timeUnit), -1L, this.proxyId);
        this.invoke(request, keyData);
    }

    @Override
    public boolean isLocked(K key) {
        Data keyData = this.getSerializationService().toData(key);
        MultiMapIsLockedRequest request = new MultiMapIsLockedRequest(keyData, this.proxyId);
        Boolean result = (Boolean)this.invoke(request, keyData);
        return result;
    }

    @Override
    public boolean tryLock(K key) {
        try {
            return this.tryLock(key, 0L, null);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    @Override
    public boolean tryLock(K key, long time, TimeUnit timeunit) throws InterruptedException {
        Data keyData = this.getSerializationService().toData(key);
        MultiMapLockRequest request = new MultiMapLockRequest(keyData, ThreadUtil.getThreadId(), Long.MAX_VALUE, this.getTimeInMillis(time, timeunit), this.proxyId);
        Boolean result = (Boolean)this.invoke(request, keyData);
        return result;
    }

    @Override
    public void unlock(K key) {
        Data keyData = this.getSerializationService().toData(key);
        MultiMapUnlockRequest request = new MultiMapUnlockRequest(keyData, ThreadUtil.getThreadId(), this.proxyId);
        this.invoke(request, keyData);
    }

    @Override
    public void forceUnlock(K key) {
        Data keyData = this.getSerializationService().toData(key);
        MultiMapUnlockRequest request = new MultiMapUnlockRequest(keyData, ThreadUtil.getThreadId(), true, this.proxyId);
        this.invoke(request, keyData);
    }

    @Override
    public LocalMultiMapStats getLocalMultiMapStats() {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    @Override
    protected void onDestroy() {
        CollectionDestroyRequest request = new CollectionDestroyRequest(this.proxyId);
        this.invoke(request);
    }

    @Override
    public String getName() {
        return this.proxyId.getName();
    }

    private <T> T invoke(Object req, Data key) {
        try {
            return this.getContext().getInvocationService().invokeOnKeyOwner(req, key);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    private <T> T invoke(Object req) {
        try {
            return this.getContext().getInvocationService().invokeOnRandomTarget(req);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    private Collection toObjectCollection(PortableCollection result, boolean list) {
        Collection<Data> coll = result.getCollection();
        AbstractCollection collection = list ? new ArrayList(coll == null ? 0 : coll.size()) : new HashSet(coll == null ? 0 : coll.size());
        if (coll == null) {
            return collection;
        }
        for (Data data : coll) {
            collection.add(this.getSerializationService().toObject(data));
        }
        return collection;
    }

    private SerializationService getSerializationService() {
        return this.getContext().getSerializationService();
    }

    protected long getTimeInMillis(long time, TimeUnit timeunit) {
        return timeunit != null ? timeunit.toMillis(time) : time;
    }

    private EventHandler<PortableEntryEvent> createHandler(final EntryListener<K, V> listener, final boolean includeValue) {
        return new EventHandler<PortableEntryEvent>(){

            @Override
            public void handle(PortableEntryEvent event) {
                Object value = null;
                Object oldValue = null;
                if (includeValue) {
                    value = ClientMultiMapProxy.this.getSerializationService().toObject(event.getValue());
                    oldValue = ClientMultiMapProxy.this.getSerializationService().toObject(event.getOldValue());
                }
                Object key = ClientMultiMapProxy.this.getSerializationService().toObject(event.getKey());
                MemberImpl member = ClientMultiMapProxy.this.getContext().getClusterService().getMember(event.getUuid());
                EntryEvent<Object, Object> entryEvent = new EntryEvent<Object, Object>(ClientMultiMapProxy.this.proxyId.getName(), member, event.getEventType().getType(), key, oldValue, value);
                switch (event.getEventType()) {
                    case ADDED: {
                        listener.entryAdded(entryEvent);
                        break;
                    }
                    case REMOVED: {
                        listener.entryRemoved(entryEvent);
                        break;
                    }
                    case UPDATED: {
                        listener.entryUpdated(entryEvent);
                        break;
                    }
                    case EVICTED: {
                        listener.entryEvicted(entryEvent);
                    }
                }
            }
        };
    }
}

